/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.TubeItem;

public class OverflowBuffer {
    private LinkedList<TubeItem> mBuffer = new LinkedList();

    public boolean isEmpty() {
        return this.mBuffer.isEmpty();
    }

    public void addItem(TubeItem item) {
        this.mBuffer.add(item);
    }

    public TubeItem getNext() {
        return this.mBuffer.removeFirst();
    }

    public TubeItem peekNext() {
        return this.mBuffer.getFirst();
    }

    public void save(NBTTagCompound root) {
        NBTTagList list = new NBTTagList();
        for (TubeItem item : this.mBuffer) {
            NBTTagCompound tag = new NBTTagCompound();
            item.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        root.func_74782_a("Overflow", (NBTBase)list);
    }

    public void load(NBTTagCompound root) {
        NBTTagList list = root.func_150295_c("Overflow", 10);
        this.mBuffer.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.mBuffer.add(TubeItem.readFromNBT(tag));
        }
    }

    public void onDropItems(List<ItemStack> itemsToDrop) {
        for (TubeItem item : this.mBuffer) {
            if (!(item.item instanceof ItemPayload)) continue;
            itemsToDrop.add((ItemStack)item.item.get());
        }
    }
}

