/*
 * Decompiled with CFR 0.152.
 */
package trailmix.common.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import trailmix.client.entity.EntityAttackFX;

public class PacketSpawnParticles
extends AbstractPacket {
    public int entId;
    public boolean entAlive;
    public static final ResourceLocation texChicken = new ResourceLocation("trailmix", "textures/fx/chicken.png");
    public static final ResourceLocation texCow = new ResourceLocation("trailmix", "textures/fx/cow.png");
    public static final ResourceLocation texOcelot = new ResourceLocation("trailmix", "textures/fx/ocelot.png");
    public static final ResourceLocation texPig = new ResourceLocation("trailmix", "textures/fx/pig.png");
    public static final ResourceLocation texSheep = new ResourceLocation("trailmix", "textures/fx/sheep.png");
    public static final ResourceLocation texSquid = new ResourceLocation("trailmix", "textures/fx/squid.png");
    public static final ResourceLocation texWolf = new ResourceLocation("trailmix", "textures/fx/wolf.png");
    public static final ResourceLocation texPika = new ResourceLocation("trailmix", "textures/fx/pika.png");
    public static final ResourceLocation[] texTx = new ResourceLocation[12];

    public PacketSpawnParticles() {
    }

    public PacketSpawnParticles(int entityId, boolean entityAlive) {
        this.entId = entityId;
        this.entAlive = entityAlive;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.entId);
        buffer.writeBoolean(this.entAlive);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.entId = buffer.readInt();
        this.entAlive = buffer.readBoolean();
    }

    public void execute(Side side, EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        Minecraft mc = Minecraft.func_71410_x();
        Entity ent = mc.field_71441_e.func_73045_a(this.entId);
        if (ent != null) {
            ResourceLocation texture;
            mc.field_71438_f.func_72708_a("largeexplode", ent.field_70165_t, (ent.field_70121_D.field_72338_b + ent.field_70121_D.field_72337_e) / 2.0, ent.field_70161_v, 0.0, 0.0, 0.0);
            int clr = 0xFFFFFF;
            if (mc.field_71441_e.field_73012_v.nextFloat() <= 0.05f) {
                if (ent instanceof EntityChicken) {
                    texture = texChicken;
                    clr = 12686147;
                } else if (ent instanceof EntityCow) {
                    texture = texCow;
                    clr = ent instanceof EntityMooshroom ? 10489616 : 4404517;
                } else if (ent instanceof EntityOcelot) {
                    texture = texOcelot;
                    clr = 15193471;
                } else if (ent instanceof EntityPig) {
                    texture = texPig;
                    clr = 15704998;
                } else if (ent instanceof EntitySheep) {
                    texture = texSheep;
                    clr = 0xCDCDCD;
                } else if (ent instanceof EntitySquid) {
                    texture = texSquid;
                    clr = 2243405;
                } else if (ent instanceof EntityWolf) {
                    texture = texWolf;
                    clr = 13545366;
                } else {
                    texture = texPika;
                    clr = 0xFFF200;
                }
            } else {
                int txIndex = (int)(Math.random() * 12.0);
                texture = texTx[txIndex];
                int x = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(8);
                switch (x) {
                    case 0: {
                        clr = 0xD30000;
                        break;
                    }
                    case 1: {
                        clr = 3428042;
                        break;
                    }
                    case 2: {
                        clr = 15483668;
                        break;
                    }
                    case 3: {
                        clr = 629315;
                        break;
                    }
                    case 4: {
                        clr = 8849818;
                        break;
                    }
                    case 5: {
                        clr = 10128905;
                        break;
                    }
                    case 6: {
                        clr = 603546;
                        break;
                    }
                    case 7: {
                        clr = 7313929;
                    }
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityAttackFX(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v, clr, texture));
        }
    }

    static {
        for (int i = 0; i < texTx.length; ++i) {
            PacketSpawnParticles.texTx[i] = new ResourceLocation("trailmix", "textures/fx/tx" + (i + 1) + ".png");
        }
    }
}

