package thKaguyaMod.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thKaguyaMod.entity.shot.EntityTHShot;

public class ItemUchide extends Item
{

	//周囲の時間を止めるアイテム　止まるのは基本移動のみ
	
	public ItemUchide()
	{
		super();
		this.setTextureName("thkaguyamod:UchidenoKoduchi");//テクスチャの指定
		maxStackSize = 1;//最大スタック数
		this.setMaxDamage(100);//耐久値
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブのその他タブに登録
	}
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player)
    {
		//player.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));
		
    	if(player.getFoodStats().getFoodLevel() > 0)//空腹ゲージ２以上で使用可能
    	{
    		int mode = 0;
    		if(player.isSneaking())//スニークなら低速モード　　通常は停止モード
    		{
    			mode = 2;
    		}
    		
    		boolean flag = true;
    		//周囲のEntityを取得
    		List list = world.getEntitiesWithinAABBExcludingEntity(player, player.boundingBox.addCoord(0.0D, 0.0D, 0.0D).expand(20.0D, 20.0D, 20.0D));
    		for(int k = 0; k < list.size(); k++)
    		{
    			Entity entity = (Entity)list.get(k);
    			if(entity instanceof EntityTHShot)//懐中時計があるなら
    			{
    				EntityTHShot shot = (EntityTHShot)entity;
    				if(shot.user == player)//その懐中時計の持ち主がこの時計の持ち主と同じなら
    				{
						shot.setShotSize(shot.getShotSize() + 0.5F);
    				}
    			}
    		}
    		/*if(!player.capabilities.isCreativeMode)//クリエイティブでないなら
    		{
    			if(mode == 0)
    			{
    				mode = 3;
    			}
    			else if(mode == 2)
    			{
    				mode = 4;
    			}
    			//world.playSoundAtEntity(player, "portal.travel", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));
    		}*/
    		//else
    		{
    			world.playSoundAtEntity(player, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));
    		}
    		player.swingItem();//投げる動作をさせる
    		itemStack.setItemDamage(itemStack.getItemDamage() + 30);
    		/*EntityPrivateSquare entityPrivateSquare = new EntityPrivateSquare(world, player, mode);
       		if(!world.isRemote)
       		{
         		world.spawnEntityInWorld(entityPrivateSquare);//時間停止空間を生み出す
         		itemStack.stackSize--;//スタックから消滅させる
       			
       		}*/
       		
    	}
       	return itemStack;
    }
	
	//インベントリにある限り常時呼び出されるメソッド
	@Override
	public void onUpdate(ItemStack itemStack, World world, Entity entity, int i, boolean flag)
	{
		itemStack.setItemDamage(itemStack.getItemDamage() - 1);
	}
	
	//Entityに当たったときの処理
    /*public boolean hitEntity(ItemStack itemStack, EntityLivingBase hitEntityLivingBase, EntityLivingBase useEntityLivingBase)
    {
    	hitEntityLivingBase.
    	return true;
    }*/
	
	//右クリックを終了したときに呼び出されるメソッド
	/*@Override
	public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int usedTime)
	{

	}*/
	
    /*public ItemStack onEaten(ItemStack itemStack, World world, EntityPlayer player)
    {
        return itemStack;
    }
    
    public int getMaxItemUseDuration(ItemStack itemStack)
    {
        return 72000;
    }
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack itemStack)
	{
		return EnumAction.bow;
	}*/
}
