package thKaguyaMod.item;

import java.util.List;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thKaguyaMod.entity.item.EntitySilverKnife;
import thKaguyaMod.init.THKaguyaItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemSilverKnife extends Item
{
	//咲夜の銀のナイフ　　投げてよし、切ってよし
	
	public static final String knifeColorNames[] =
    {
        "blue", "red", "green", "white"
    };
	public static final String knifeIconName[] =
	{
		"SilverKnife_Blue", "SilverKnife_Red", "SilverKnife_Green", "SilverKnife_White"
	};
	
    @SideOnly(Side.CLIENT)
    private IIcon[] icon;
	
	public ItemSilverKnife()
	{
		super();
		setHasSubtypes(true);
		setMaxDamage(0);
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
	}
	
	@Override
	public String getUnlocalizedName(ItemStack itemStack)
    {
        int i = MathHelper.clamp_int(itemStack.getItemDamage(), 0, 3);
        return super.getUnlocalizedName() + "." + knifeColorNames[i];
    }
	
	@Override
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public IIcon getIconFromDamage(int damage)
    {
        int i = MathHelper.clamp_int(damage, 0, 3);
        return this.icon[i];
    }
	
	@Override
	@SideOnly(Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister)
    {
        this.icon = new IIcon[knifeIconName.length];

        for (int i = 0; i < knifeIconName.length; ++i)
        {
            this.icon[i] = iconRegister.registerIcon("thkaguyamod:shot/" + knifeIconName[i]);
        }
    }
	
	//Entityに当たったときの処理
	@Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase living_hit, EntityLivingBase living_used)
    {
    	living_hit.attackEntityFrom(DamageSource.causeMobDamage(living_used), 3.0F);
    	//白ナイフなら消える
    	if(itemStack.getItemDamage() == 3)
    	{
    		itemStack.stackSize--;
    	}
    	return true;
    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player)
    {
    	double xVec,yVec,zVec;
    	double speed = 1.0D;
    	EntitySilverKnife silverKnife;

    	xVec = -Math.sin(player.rotationYaw / 180F * 3.141593F) * Math.cos(player.rotationPitch / 180F * 3.141593F) * speed;//X方向　水平方向
    	yVec = -Math.sin(player.rotationPitch / 180F * 3.141593F) * speed;//Y方向　上下
    	zVec =  Math.cos(player.rotationYaw / 180F * 3.141593F) * Math.cos(player.rotationPitch / 180F * 3.141593F) * speed;//Z方向　水平方向
    	silverKnife = new EntitySilverKnife(world, player, player.posX + xVec, player.posY + yVec + (double)player.getEyeHeight() - 0.10000000149011612D, player.posZ + zVec,
   			xVec, yVec, zVec, 0.28D, itemStack.getItemDamage());
       	
    	world.playSoundAtEntity(player, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
       	
    	if(!world.isRemote)
       	{
			world.spawnEntityInWorld(silverKnife);//銀のナイフを出現させる
			itemStack.stackSize--;//一つ消費
       	}
    	
    	player.swingItem();//投げる動作をさせる
        
    	return itemStack;
    }
	
	@Override
	@SideOnly(Side.CLIENT)
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
	public void getSubItems(Item item, CreativeTabs creativeTabs, List list)
    {
        for (int i = 0; i < 3; i++)
        {
            list.add(new ItemStack(THKaguyaItems.silver_knife, 1, i));
        }
    }
	
	
}