package thKaguyaMod.client.render;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

import thKaguyaMod.client.model.ModelTHFairy;
import thKaguyaMod.entity.living.EntityTHFairy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderTHFairy extends RenderLiving
{
	//妖精を描画する

    public RenderTHFairy()
    {
        super(new ModelTHFairy(), 0.25F);
    }
    
    @Override
    public void doRender(Entity entity, double x, double y, double z, float yaw, float pitch)
    {
    	super.doRender(entity, x, y, z, yaw, pitch);
    	this.renderTHFairy((EntityTHFairy)entity, x, y, z, yaw, pitch);
    	
    }

	public void renderTHFairy(EntityTHFairy thFairy, double x, double y, double z, float yaw, float pitch)
	{
		//ゾンビフェアリーかつ体力がないなら、輪っかを描画する
        if(thFairy.getHealth() <= 0 && thFairy.getDanmakuPattern() < 0)
        {
        	
        	GL11.glDisable(GL11.GL_LIGHTING);
    		GL11.glEnable(GL11.GL_BLEND);
        	GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
        	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画

        	Tessellator tessellator = Tessellator.instance;
        	float f3 = 0.75F;
            float f4 = 1.0F;
            float f5 = 0.5F;
            float f6 = 0.75F;
            float f7 = 1.0F;
            float f8 = 0.5F;
            float f9 = 0.5F;
            
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0F, 1.0F, 0.0F);
            tessellator.addVertexWithUV( x - 0.5F, y + 2.5F, z + 0.5D, f3, f6);
            tessellator.addVertexWithUV( x + 0.5F, y + 2.5F, z + 0.5D, f4, f6);
            tessellator.addVertexWithUV( x + 0.5F, y + 2.5F, z - 0.5D, f4, f5);
            tessellator.addVertexWithUV( x - 0.5F, y + 2.5F, z - 0.5D, f3, f5);
    		tessellator.draw();
    		GL11.glEnable(GL11.GL_CULL_FACE);//両面描画
    		GL11.glDisable(GL11.GL_BLEND);
    		GL11.glEnable(GL11.GL_LIGHTING);
        }
	}

    @Override
    protected ResourceLocation getEntityTexture(Entity entity)
    {
        return this.getEntityTexture((EntityTHFairy)entity);
    }
    
    protected ResourceLocation getEntityTexture(EntityTHFairy thFairy)
    {
    	ResourceLocation resourceLocation;
    	if(thFairy.getForm() >= 0)
    	{
    		resourceLocation = new ResourceLocation("thkaguyamod", "textures/mob/FairyTexture_" + thFairy.getDanmakuPattern() % 3 + ".png");
    	}
    	else
    	{
    		resourceLocation = new ResourceLocation("thkaguyamod", "textures/mob/ZombieFairyTexture.png");
    	}
        return resourceLocation;
    }
}
