package thKaguyaMod;

import java.util.HashMap;
import java.util.Map;

import thKaguyaMod.entity.shot.ISpecialShot;

public class SpecialShotRegistry {
	//public static Map<Integer, String> spellcardName = new HashMap<Integer, String>();
	public static Map<Integer, Class<? extends ISpecialShot>> specialShotClass = new HashMap<Integer, Class<? extends ISpecialShot>>();
	//public static Map<String, Integer> spellcardID = new HashMap<String, Integer>();
	
	/**
	 * スペルカードを登録する。登録するクラスはTHSpellCardを継承したもの
	 * @param spellcard_class : THSpellCardを継承したクラス。個別のスペルカード処理のみ書かれたもの
	 * @param name            : スペルカードの登録名。符名抜きの日本語名をローマ字表記が望ましい　for example: "MusouFuuin", "Kasho_no_Eimin"
	 * @param id              : 他のスペルカードと被らない数字。128以上が望ましい。
	 * @return 登録に成功したらtrue
	 */
	public static boolean registerSpecialShot(Class<? extends ISpecialShot> specialShot_class, int id)
	{
		specialShotClass.put(id, specialShot_class);
	
		return true;
	}
	
	/*private static boolean idCheck(int id)
	{
		for(String name : spellcardID.keySet())
		{
			if(spellcardID.get(name) == id)
			{
				return false;
			}
		}
		return true;
	}*/
	
	/**
	 * スペルカードIDからそのスペルカードの登録名を返す
	 * @param id
	 * @return
	 */
	/*public static String getSpellCardName(int id)
	{
		return spellcardName.get(id);
	}*/
	
	/**
	 * 登録名からスペルカードIDを返す
	 * @param name
	 * @return
	 */
	/*public static int getSpellCardNumber(String name)
	{
		return spellcardID.get(name);
	}*/
	
	/**
	 * 登録名からスペルカードの処理の書かれたクラスを返す
	 * @param name
	 * @return
	 */
	public static Class<? extends ISpecialShot> getSpecialShotClass(int id)
	{
		return specialShotClass.get(id);
	}
	
	/**
	 * スペルカードIDからスペルカードの処理の書かれたクラスを返す
	 * @param id
	 * @return
	 */
	/*public static Class<? extends THSpellCard> getSpellCardClass(int id)
	{
		return spellcardClass.get(getSpellCardName(id));
	}*/
	
	/**
	 * 登録されている特殊弾の合計数を返す
	 * @return
	 */
	public static int getNumberOfSpecialShot()
	{
		return specialShotClass.size();
	}
}
