package thKaguyaMod.init;

import java.io.File;

import net.minecraftforge.common.config.Configuration;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;

public class THKaguyaConfig
{
	//スキマの効果音の設定
	public static String sukimaWarpSE = "mob.endermen.portal";
	//public static String sukimaWarpSE = "random.sukima";
	
	//コンフィグで変更できる変数
	
	/*===================================EntityID関連========================================*/
	public static int entityIdTHFairy;//雑魚妖精
	public static int entityIdFamiliar;//使い魔
	public static int entityIdTHPhantom;//幽霊
	public static int entityIdHanabeeper;//ハナビーパー
	public static int entityIdCirno;//チルノ
	public static int entityIdRumia;//ルーミア
	public static int entityIdSanae;//早苗
	public static int entityIdToziko;//屠自古
	
	/*===================================エフェクト関連========================================*/
	public static float SpellCardVol;//スペルカード音の音量
	public static float MasterSparkVol;//マスタースパークの音量
	public static float HisoutenVol;	//全人類の緋想天の音量
	public static boolean UsingMasterSpark;//マスタースパークが使用できるか
	public static boolean MasterSparkDestroysBlocks;//マスタースパークでブロックを破壊できるか
	public static boolean useDefaultGapSE;//デフォルトのスキマのSEを使うかどうか
	public static boolean useTimeStopEffect;//時間停止のエフェクトを出現させるか
	
	/*===================================弾幕関連========================================*/
	public static boolean spawnDanmakuMob;//このMODで追加されるMOBが自然スポーンするか
	public static boolean spawnHanabeeper;//ハナビーパーが自然スポーンするか
	public static boolean spawnFairy;//妖精が自然スポーンするか
	public static boolean spawnPhantom;//幽霊が自然スポーンするか
	public static boolean spawnBoss;//ボスMOBがスポーンするか
	
	public static int fairySpawnRate;//妖精のスポーンする率
	public static int danmakuLevel;//弾幕のレベル 1～4を指定して、1がEasy、4がLunatic。 0は弾を出さない
	public static float danmakuAccuracy;//妖精などが弾幕を打つ方向の適格性（100でずれなし、0でずれまくり）
	
	public static boolean danmakuOneKillMode;//弾幕攻撃に当たると即死するモードにするかの設定
	public static boolean canUseWallPassingChisel;//壁抜けの鑿が使用できるかどうか
	public static int shotMaxNumber;//弾アイテムで出せる弾幕の限界量
	public static int laserMaxNumber;//レーザーアイテムで出せる弾幕の限界量
	
	public static boolean recipelessItemsRecipe;//レシピのないアイテムのレシピを追加するか
	
	
	
	public static void setConfig(FMLPreInitializationEvent event)
	{
		//コンフィグの設定
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		int setSpellCardVol;
		int setMasterSparkVol;
		int setHisoutenVol;
		
		try
		{
			/*
			* ファイルをロードする.
			*/
			cfg.load();
			
			/*===================================EntityID関連========================================*/
			entityIdHanabeeper   = cfg.get("EntityID", "Hanabeeper"  , 557).getInt();
			entityIdTHFairy   	= cfg.get("EntityID", "Fairy"   	, 530).getInt();
			entityIdFamiliar   	= cfg.get("EntityID", "Familiar"   	, 532).getInt();
			entityIdTHPhantom   	= cfg.get("EntityID", "Phantom"   	, 531).getInt();
			entityIdCirno   		= cfg.get("EntityID", "Cirno"   	, 561).getInt();
			entityIdRumia   		= cfg.get("EntityID", "Rumia"   	, 559).getInt();
			entityIdRumia   		= cfg.get("EntityID", "Toziko"   	, 560).getInt();
			entityIdSanae   		= cfg.get("EntityID", "Sanae"   	, 562).getInt();
			
			

			/*===================================制限関連========================================*/
			UsingMasterSpark = true;
			//マスタースパークの使用ができるか？
			UsingMasterSpark = cfg.get("Limit", "Use Master Spark", true).getBoolean(true);
			//マスタースパークが地形を破壊するかどうか
			MasterSparkDestroysBlocks = cfg.get("Limit", "Master Spark Destroys Blocks", true).getBoolean(true);
			//壁抜けの鑿の仕様を許可するか
			canUseWallPassingChisel = cfg.get("Limit", "Can Use Wall-Passing Chisel", true).getBoolean(true);
			
			//弾アイテムで出せる弾幕の限界量
			shotMaxNumber    = cfg.get("Limit", "Shot Max Number"   , 32).getInt();
			//レーザーアイテムで出せる弾幕の限界量
			laserMaxNumber   = cfg.get("Limit", "Laser Max Number"   , 8).getInt();

			
			/*===================================エフェクト関連========================================*/
			//時間停止のエフェクトを有効にするかどうか
			useTimeStopEffect = cfg.get("Effect", "Appear Time stop effect", true).getBoolean(true);
			
			//スキマのSEをデフォルトのものを使うか
			useDefaultGapSE = cfg.get("Effect", "Use default Gap(Sukima)SE", true).getBoolean(true);
			if(!useDefaultGapSE)
			{
				sukimaWarpSE = "thkaguyamod:sukima";
			}
			
			File sukimaFile = new File("bin/assets/thkaguyamod/sounds/sukima.ogg");
			File sukimaFile2 = new File("mods/modid-1.0.jar/assets/thkaguyamod/sounds/sukima.ogg");
			if(sukimaFile.exists() || sukimaFile2.exists())
			{
				sukimaWarpSE = "thkaguyamod:sukima";
			}

			//SEのボリュームのコンフィグ
			setSpellCardVol   = cfg.get("SE vol", "Spell Card Vol"   , 50).getInt();
			setMasterSparkVol = cfg.get("SE vol", "Master Spark Vol", 50).getInt();
			setHisoutenVol    = cfg.get("SE vol", "Hisouten Vol"   , 20).getInt();
			
			if(setSpellCardVol > 500)setSpellCardVol = 500;
			if(setMasterSparkVol > 500)setMasterSparkVol = 500;
			if(setHisoutenVol > 500)setHisoutenVol = 500;
			SpellCardVol = (float)setSpellCardVol / 100F;
			MasterSparkVol = (float)setMasterSparkVol / 100F;
			HisoutenVol = (float)setHisoutenVol / 100F;
			



			
			
			/*===================================弾幕関連========================================*/
			//弾幕攻撃で即死するモードにするか
			danmakuOneKillMode = cfg.get("Danmaku", "Danmaku 1 Kill Mode", false).getBoolean(false);
			
			//弾幕を扱うMOBが自然スポーンするか
			spawnDanmakuMob = cfg.get("Danmaku", "Spawn Danmaku Mob", true).getBoolean(false);
			
			//妖精が出現するか
			spawnFairy = cfg.get("Danmaku", "Spawn Fairy", true).getBoolean(false);
			
			//幽霊が出現するか
			spawnPhantom = cfg.get("Danmaku", "Spawn Phantom", true).getBoolean(false);
			
			//ボスMOBが出現するか
			spawnBoss = cfg.get("Danmaku", "Spawn Danmaku Mob Boss", true).getBoolean(false);
			
			//妖精の出現確率
			fairySpawnRate    = 100 - cfg.get("Danmaku", "Fairy Spawn Rate(%)"   , 50).getInt();
			
			//ハナビーパーが出現するか
			spawnHanabeeper = cfg.get("Other", "Spawn Hanabeeper", false).getBoolean(false);

			//妖精の出す弾幕のレベル デフォルトはノーマル
			danmakuLevel    = cfg.get("Danmaku", "Danmaku Level"   , 2).getInt();
			if(danmakuLevel > 4)
			{
				danmakuLevel = 4;
			}
			else if(danmakuLevel < 0)
			{
				danmakuLevel = 0;
			}
			//敵弾の命中の適格性
			danmakuAccuracy = (float)cfg.get("Danmaku", "Hit Rate of Enemy Danmaku(row=0,high=100)", 80).getInt();
			danmakuAccuracy = 360F * (1F - (danmakuAccuracy / 100F));
			
			/*===================================ゲームセッティング========================================*/

			
			//レシピなしのアイテムのレシピを追加するか
			recipelessItemsRecipe = cfg.get("Other", "Add Recipeless Items Recipe", false).getBoolean(false);
			
		}
		catch (Exception e)
		{
			/*
			* ファイルの読み込み/書き込み時に例外が発生した場合, ログに残す.
			*/
			FMLLog.severe("Error Message");
		}
		finally
		{
			/*
			* 最後に必ずセーブする.
			*/
			cfg.save();
		}
	}
}
