package thKaguyaMod;

//FMLにロードさせるためのアノテーション
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import thKaguyaMod.entity.living.EntityCirno;
import thKaguyaMod.entity.living.EntityDanmakuCreeper;
import thKaguyaMod.entity.living.EntityRumia;
import thKaguyaMod.entity.living.EntityTHFairy;
import thKaguyaMod.entity.living.EntityTHPhantom;
import thKaguyaMod.entity.living.EntityToziko;
import thKaguyaMod.init.THKaguyaBlocks;
import thKaguyaMod.init.THKaguyaConfig;
import thKaguyaMod.init.THKaguyaItems;
import thKaguyaMod.init.THKaguyaRecipe;
import thKaguyaMod.tileentity.TileEntityDivineSpirit;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
//Entityに関するレジストリ
//前初期化, 初期化のイベント
//プロキシシステムのためのアノテーション
//言語に関するレジストリ
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid = "THKaguyaMod", name = "Itutu no Nandai MOD+", version = "2.76_1.7.10")
public class THKaguyaCore
{
	
	
	// クライアント側とサーバー側で異なるインスタンスを生成
	@SidedProxy(clientSide = "thKaguyaMod.client.ClientProxy", serverSide = "thKaguyaMod.CommonProxy")
	public static CommonProxy proxy;
	
	// 自身のインスタンス
	@Mod.Instance("THKaguyaMod")//数行上の@Mod(modid = "......"で指定したmodid
	public static THKaguyaCore instance;
	
	//ブロックレンダーID
	public static int blockRenderId;
	
	//GUI
	public static int guiDanmakuCraftingID = 0;
	public static int guiDanmakuCraftingLaserID = 1;
	//public static int guiSpellCardID = 2;
	public static int guiMerchantSanaeId = 2;
	
	public static int hinezumiIndex; 
	public static int marisaIndex;
	public static int suwakoIndex;
	
	//クリエイティブタグの登録
	public static final CreativeTabs tabSpellCard = new CreativeTabSpellCard("spellcard");//スペルカードのタグを追加
	
	// 前処理
	@Mod.EventHandler
	public void preInit(FMLPreInitializationEvent event)
	{
		THKaguyaConfig.setConfig(event);
		
		blockRenderId = proxy.getNewRenderType();
		
		proxy.registerSpellCards();
		
		
		//アイテムの初期設定
		THKaguyaItems.setItems();
		//アイテムを登録
		proxy.registerItems();
		//ブロックの初期設定
		THKaguyaBlocks.setBlocks();
		//ブロックの登録
		proxy.registerBlocks();
		
		//TileEntityの登録
		GameRegistry.registerTileEntity(TileEntityDivineSpirit.class, "TileEntityDivineSpirit");
		
		//GUIの登録
		NetworkRegistry.INSTANCE.registerGuiHandler(this, new GuiHandler());
		
		//エンティティの登録
		proxy.registerEntitys();
		
		DanmakuPatternRegistry.setDanmakuPattern();
		
	}
	
	@Mod.EventHandler
	public void init(FMLInitializationEvent event)
	{	
		
		/*MOBをスポーンさせる
		entityClass    : スポーンさせるEntityのclass
		weightedProb   : スポーンする割合。大きいほどスポーンしやすい
		min            : 一度にスポーンする最低数
		max            : 一度にスポーンする最大数
		typeOfCreature : MOBのタイプ
		biomes         : スポーンするバイオーム
		*/
		if(THKaguyaConfig.spawnDanmakuMob)
		{
			if(THKaguyaConfig.spawnFairy)
			{	
				//妖精
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.plains);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.birchForest);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.birchForestHills);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.desert);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.extremeHills);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.extremeHillsEdge);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.extremeHillsPlus);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.forest);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.forestHills);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.taiga);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.swampland);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.icePlains);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.iceMountains);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.jungle);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.jungleHills);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.roofedForest);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.swampland);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.taiga);
				EntityRegistry.addSpawn(EntityTHFairy.class,  30, 1, 6,EnumCreatureType.monster, BiomeGenBase.taigaHills);
				
				//EntityRegistry.addSpawn(EntityTHFairy.class,  3, 1, 6,EnumCreatureType.monster, GensoukyouCore.gensoukyouPlains);
		

			}
			
			if(THKaguyaConfig.spawnPhantom)
			{
				//幽霊
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.plains);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.beach);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.birchForest);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.birchForestHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.coldBeach);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.coldTaiga);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.coldTaigaHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.deepOcean);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.desert);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.desertHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.extremeHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.extremeHillsEdge);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.extremeHillsPlus);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.forest);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.forestHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.frozenOcean);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.frozenRiver);
				//EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.hell);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.iceMountains);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.icePlains);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.jungle);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.jungleEdge);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.jungleHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.megaTaiga);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.megaTaigaHills);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.mesa);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.mesaPlateau);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.mesaPlateau_F);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.ocean);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.river);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.roofedForest);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.savanna);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.savannaPlateau);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.stoneBeach);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.swampland);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.taiga);
				EntityRegistry.addSpawn(EntityTHPhantom.class,  20, 1, 3,EnumCreatureType.monster, BiomeGenBase.taigaHills);
			}
			
			if(THKaguyaConfig.spawnHanabeeper)
			{
				EntityRegistry.addSpawn(EntityDanmakuCreeper.class,  2, 1, 4,EnumCreatureType.monster, BiomeGenBase.desert);
			}
			
			if(THKaguyaConfig.spawnBoss)
			{
				//チルノ
				EntityRegistry.addSpawn(EntityCirno.class,  2, 1, 1,EnumCreatureType.monster, BiomeGenBase.coldTaiga);
				EntityRegistry.addSpawn(EntityCirno.class,  2, 1, 1,EnumCreatureType.monster, BiomeGenBase.coldTaigaHills);
				EntityRegistry.addSpawn(EntityCirno.class,  2, 1, 1,EnumCreatureType.monster, BiomeGenBase.frozenRiver);
				EntityRegistry.addSpawn(EntityCirno.class,  2, 1, 1,EnumCreatureType.monster, BiomeGenBase.iceMountains);
				EntityRegistry.addSpawn(EntityCirno.class,  2, 1, 1,EnumCreatureType.monster, BiomeGenBase.icePlains);
				
				//ルーミア
				EntityRegistry.addSpawn(EntityRumia.class, 4, 1, 1, EnumCreatureType.monster, BiomeGenBase.forest);
				EntityRegistry.addSpawn(EntityRumia.class, 4, 1, 1, EnumCreatureType.monster, BiomeGenBase.plains);
				EntityRegistry.addSpawn(EntityRumia.class, 7, 1, 1, EnumCreatureType.monster, BiomeGenBase.roofedForest);
				EntityRegistry.addSpawn(EntityRumia.class, 4, 1, 1, EnumCreatureType.monster, BiomeGenBase.taiga);
				EntityRegistry.addSpawn(EntityRumia.class, 4, 1, 1, EnumCreatureType.monster, BiomeGenBase.taigaHills);
				
				//屠自古
				EntityRegistry.addSpawn(EntityToziko.class, 9, 1, 1, EnumCreatureType.monster, BiomeGenBase.forest);
				EntityRegistry.addSpawn(EntityToziko.class, 7, 1, 1, EnumCreatureType.monster, BiomeGenBase.plains);
				EntityRegistry.addSpawn(EntityToziko.class,20, 1, 1, EnumCreatureType.monster, BiomeGenBase.swampland);
			}
		}
		
		
		// サーバー側は何もしない, クライアント側ではレンダーの登録が行われる
		proxy.registerRenderers();
		
		
		//レシピの登録
		THKaguyaRecipe.setAllRecipes();
		if(THKaguyaConfig.recipelessItemsRecipe)
		{
			THKaguyaRecipe.setRecipelessItemsRecipe();
		}
		
	}
}