/*
 * Decompiled with CFR 0.152.
 */
package torchLevers.resourceMethods;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.apache.commons.io.IOUtils;
import torchLevers.TorchLevers;
import torchLevers.Utilities;
import torchLevers.resourceMethods.HiddenButtonMetadataSection;

public class TextureEvent {
    private static boolean nagged = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onResourcePackUpdate(TextureStitchEvent.Post event) {
        IIcon icon;
        int[] positions;
        String hash;
        TextureMap map = event.map;
        if (map.func_130086_a() != 0) {
            return;
        }
        boolean bookSet = false;
        boolean brickSet = false;
        boolean netherSet = false;
        if (!Minecraft.func_71410_x().func_110438_M().func_110613_c().isEmpty()) {
            List resourcepacks = Minecraft.func_71410_x().func_110438_M().func_110613_c();
            for (ResourcePackRepository.Entry entry : resourcepacks) {
                HiddenButtonMetadataSection meta;
                AbstractResourcePack resourcepack = (AbstractResourcePack)entry.func_110514_c();
                try {
                    meta = this.getMeta("book", resourcepack.func_110590_a(new ResourceLocation("TorchLevers", "buttonPositions.mcmeta")));
                    TorchLevers.topBookLeft = meta.get(0, 0);
                    TorchLevers.topBookTop = meta.get(0, 1);
                    TorchLevers.topBookRight = meta.get(0, 2);
                    TorchLevers.topBookBottom = meta.get(0, 3);
                    TorchLevers.bottomBookLeft = meta.get(1, 0);
                    TorchLevers.bottomBookTop = meta.get(1, 1);
                    TorchLevers.bottomBookRight = meta.get(1, 2);
                    TorchLevers.bottomBookBottom = meta.get(1, 3);
                    bookSet = true;
                }
                catch (Exception ex) {
                    bookSet = false;
                }
                try {
                    meta = this.getMeta("brick", resourcepack.func_110590_a(new ResourceLocation("TorchLevers", "buttonPositions.mcmeta")));
                    TorchLevers.topBrickLeft = meta.get(0, 0);
                    TorchLevers.topBrickTop = meta.get(0, 1);
                    TorchLevers.topBrickRight = meta.get(0, 2);
                    TorchLevers.topBrickBottom = meta.get(0, 3);
                    TorchLevers.bottomBrickLeft = meta.get(1, 0);
                    TorchLevers.bottomBrickTop = meta.get(1, 1);
                    TorchLevers.bottomBrickRight = meta.get(1, 2);
                    TorchLevers.bottomBrickBottom = meta.get(1, 3);
                    brickSet = true;
                }
                catch (Exception ex) {
                    brickSet = false;
                }
                try {
                    meta = this.getMeta("netherbrick", resourcepack.func_110590_a(new ResourceLocation("TorchLevers", "buttonPositions.mcmeta")));
                    TorchLevers.topNetherLeft = meta.get(0, 0);
                    TorchLevers.topNetherTop = meta.get(0, 1);
                    TorchLevers.topNetherRight = meta.get(0, 2);
                    TorchLevers.topNetherBottom = meta.get(0, 3);
                    TorchLevers.bottomNetherLeft = meta.get(1, 0);
                    TorchLevers.bottomNetherTop = meta.get(1, 1);
                    TorchLevers.bottomNetherRight = meta.get(1, 2);
                    TorchLevers.bottomNetherBottom = meta.get(1, 3);
                    netherSet = true;
                }
                catch (Exception ex) {
                    netherSet = false;
                }
            }
        }
        boolean hasUpdatedHash = false;
        if (!bookSet) {
            hash = this.getImageHash(Blocks.field_150342_X.func_149691_a(2, 0));
            try {
                positions = this.matchHash(hash);
                TorchLevers.topBookLeft = positions[0];
                TorchLevers.topBookTop = positions[1];
                TorchLevers.topBookRight = positions[2];
                TorchLevers.topBookBottom = positions[3];
                TorchLevers.bottomBookLeft = positions[4];
                TorchLevers.bottomBookTop = positions[5];
                TorchLevers.bottomBookRight = positions[6];
                TorchLevers.bottomBookBottom = positions[7];
                bookSet = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!bookSet) {
                try {
                    hasUpdatedHash = true;
                    if (this.checkForHashUpdate()) {
                        positions = this.matchHash(hash);
                        TorchLevers.topBookLeft = positions[0];
                        TorchLevers.topBookTop = positions[1];
                        TorchLevers.topBookRight = positions[2];
                        TorchLevers.topBookBottom = positions[3];
                        TorchLevers.bottomBookLeft = positions[4];
                        TorchLevers.bottomBookTop = positions[5];
                        TorchLevers.bottomBookRight = positions[6];
                        TorchLevers.bottomBookBottom = positions[7];
                        bookSet = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!bookSet && TorchLevers.hashWarning) {
                    TorchLevers.serverLog.warn("Unable to find suitable location for book button. Consider providing one for this texture pack, on the official Torch Levers Mod forum thread (http://bit.ly/TorchLevers). (You'll need this image hash = BOOK_" + hash + ")");
                }
            }
        }
        if (!brickSet) {
            hash = this.getImageHash(Blocks.field_150336_V.func_149691_a(2, 0));
            try {
                positions = this.matchHash(hash);
                TorchLevers.topBrickLeft = positions[0];
                TorchLevers.topBrickTop = positions[1];
                TorchLevers.topBrickRight = positions[2];
                TorchLevers.topBrickBottom = positions[3];
                TorchLevers.bottomBrickLeft = positions[4];
                TorchLevers.bottomBrickTop = positions[5];
                TorchLevers.bottomBrickRight = positions[6];
                TorchLevers.bottomBrickBottom = positions[7];
                brickSet = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!brickSet) {
                if (!hasUpdatedHash) {
                    try {
                        hasUpdatedHash = true;
                        if (this.checkForHashUpdate()) {
                            positions = this.matchHash(hash);
                            TorchLevers.topBrickLeft = positions[0];
                            TorchLevers.topBrickTop = positions[1];
                            TorchLevers.topBrickRight = positions[2];
                            TorchLevers.topBrickBottom = positions[3];
                            TorchLevers.bottomBrickLeft = positions[4];
                            TorchLevers.bottomBrickTop = positions[5];
                            TorchLevers.bottomBrickRight = positions[6];
                            TorchLevers.bottomBrickBottom = positions[7];
                            brickSet = true;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!brickSet && TorchLevers.hashWarning) {
                    TorchLevers.serverLog.warn("Unable to find suitable location for brick button. Consider providing one for this texture pack, on the official Torch Levers Mod forum thread (http://bit.ly/TorchLevers). (You'll need this image hash = BRICK_" + hash + ")");
                }
            }
        }
        if (!netherSet) {
            hash = this.getImageHash(Blocks.field_150385_bj.func_149691_a(2, 0));
            try {
                positions = this.matchHash(hash);
                TorchLevers.topNetherLeft = positions[0];
                TorchLevers.topNetherTop = positions[1];
                TorchLevers.topNetherRight = positions[2];
                TorchLevers.topNetherBottom = positions[3];
                TorchLevers.bottomNetherLeft = positions[4];
                TorchLevers.bottomNetherTop = positions[5];
                TorchLevers.bottomNetherRight = positions[6];
                TorchLevers.bottomNetherBottom = positions[7];
                netherSet = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!netherSet) {
                if (!hasUpdatedHash) {
                    try {
                        hasUpdatedHash = true;
                        if (this.checkForHashUpdate()) {
                            positions = this.matchHash(hash);
                            TorchLevers.topNetherLeft = positions[0];
                            TorchLevers.topNetherTop = positions[1];
                            TorchLevers.topNetherRight = positions[2];
                            TorchLevers.topNetherBottom = positions[3];
                            TorchLevers.bottomNetherLeft = positions[4];
                            TorchLevers.bottomNetherTop = positions[5];
                            TorchLevers.bottomNetherRight = positions[6];
                            TorchLevers.bottomNetherBottom = positions[7];
                            netherSet = true;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!netherSet && TorchLevers.hashWarning) {
                    TorchLevers.serverLog.warn("Unable to find suitable location for nether brick button. Consider providing one for this texture pack, on the official Torch Levers Mod forum thread (http://bit.ly/TorchLevers). (You'll need this image hash = NETHER_" + hash + ")");
                }
            }
        }
        if (bookSet) {
            float width;
            icon = Blocks.field_150342_X.func_149691_a(2, 0);
            float height = width = (float)this.getPixelSize(icon);
            TorchLevers.topBookLeft *= 16.0f / width;
            TorchLevers.topBookTop *= 16.0f / height;
            TorchLevers.topBookRight *= 16.0f / width;
            TorchLevers.topBookBottom *= 16.0f / height;
            TorchLevers.bottomBookLeft *= 16.0f / width;
            TorchLevers.bottomBookTop *= 16.0f / height;
            TorchLevers.bottomBookRight *= 16.0f / width;
            TorchLevers.bottomBookBottom *= 16.0f / height;
        } else {
            TorchLevers.topBookLeft = 2.0f;
            TorchLevers.topBookTop = 2.0f;
            TorchLevers.topBookRight = 7.0f;
            TorchLevers.topBookBottom = 5.0f;
            TorchLevers.bottomBookLeft = 9.0f;
            TorchLevers.bottomBookTop = 10.0f;
            TorchLevers.bottomBookRight = 14.0f;
            TorchLevers.bottomBookBottom = 13.0f;
        }
        if (brickSet) {
            float width;
            icon = Blocks.field_150336_V.func_149691_a(2, 0);
            float height = width = (float)this.getPixelSize(icon);
            TorchLevers.topBrickLeft *= 16.0f / width;
            TorchLevers.topBrickTop *= 16.0f / height;
            TorchLevers.topBrickRight *= 16.0f / width;
            TorchLevers.topBrickBottom *= 16.0f / height;
            TorchLevers.bottomBrickLeft *= 16.0f / width;
            TorchLevers.bottomBrickTop *= 16.0f / height;
            TorchLevers.bottomBrickRight *= 16.0f / width;
            TorchLevers.bottomBrickBottom *= 16.0f / height;
        } else {
            TorchLevers.topBrickLeft = 2.0f;
            TorchLevers.topBrickTop = 2.0f;
            TorchLevers.topBrickRight = 7.0f;
            TorchLevers.topBrickBottom = 5.0f;
            TorchLevers.bottomBrickLeft = 9.0f;
            TorchLevers.bottomBrickTop = 10.0f;
            TorchLevers.bottomBrickRight = 14.0f;
            TorchLevers.bottomBrickBottom = 13.0f;
        }
        if (netherSet) {
            float width;
            icon = Blocks.field_150385_bj.func_149691_a(2, 0);
            float height = width = (float)this.getPixelSize(icon);
            TorchLevers.topNetherLeft *= 16.0f / width;
            TorchLevers.topNetherTop *= 16.0f / height;
            TorchLevers.topNetherRight *= 16.0f / width;
            TorchLevers.topNetherBottom *= 16.0f / height;
            TorchLevers.bottomNetherLeft *= 16.0f / width;
            TorchLevers.bottomNetherTop *= 16.0f / height;
            TorchLevers.bottomNetherRight *= 16.0f / width;
            TorchLevers.bottomNetherBottom *= 16.0f / height;
        } else {
            TorchLevers.topNetherLeft = 2.0f;
            TorchLevers.topNetherTop = 2.0f;
            TorchLevers.topNetherRight = 7.0f;
            TorchLevers.topNetherBottom = 5.0f;
            TorchLevers.bottomNetherLeft = 9.0f;
            TorchLevers.bottomNetherTop = 10.0f;
            TorchLevers.bottomNetherRight = 14.0f;
            TorchLevers.bottomNetherBottom = 13.0f;
        }
    }

    private String getImageHash(IIcon icon) {
        String name = icon.func_94215_i();
        String hash = "";
        try {
            List resources = Minecraft.func_71410_x().func_110442_L().func_135056_b(new ResourceLocation("textures/blocks/" + name + ".png"));
            Iterator it = resources.iterator();
            IResource res = null;
            while (it.hasNext()) {
                res = (IResource)it.next();
            }
            InputStream stream = res.func_110527_b();
            byte[] bytes = TextureEvent.createChecksum(stream);
            stream.close();
            hash = "";
            for (int i = 0; i < bytes.length; ++i) {
                hash = hash + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return hash;
    }

    private static byte[] createChecksum(InputStream stream) throws Exception {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("SHA-1");
        do {
            if ((numRead = stream.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        return complete.digest();
    }

    private boolean checkForHashUpdate() {
        boolean needsUpdate = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(TorchLevers.configDir, "TorchLevers_TextureSupport.txt")));
            String line = reader.readLine();
            if (line != null) {
                String[] blocks = line.split(" ", 2);
                int version = Integer.parseInt(blocks[0]);
                String timeStamp = blocks[1];
                if (Integer.parseInt(timeStamp) != Integer.parseInt(Utilities.getDateStamp()) && Integer.parseInt(Utilities.readURL(TorchLevers.URLTextureUpdate)) > version) {
                    needsUpdate = true;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            Utilities.tellLocalUser("There is an updated Texture Hash file, attempting to update...");
            Utilities.downloadFromUrl(TorchLevers.URLHashFile, new File(TorchLevers.configDir, "TorchLevers_TextureSupport.txt"));
            try {
                Utilities.writeToFileOffset(new File(TorchLevers.configDir, "TorchLevers_TextureSupport.txt"), 9, Utilities.getDateStamp());
                Utilities.tellLocalUser("Update complete!");
                return true;
            }
            catch (Exception e) {
                Utilities.tellLocalUser("There was an error updating the texture file. You can download and update it manually if you would like. " + TorchLevers.URLHashFile);
            }
        } else {
            try {
                Utilities.writeToFileOffset(new File(TorchLevers.configDir, "TorchLevers_TextureSupport.txt"), 9, Utilities.getDateStamp());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private int[] matchHash(String hash) throws Exception {
        int[] results = new int[8];
        BufferedReader reader = new BufferedReader(new FileReader(new File(TorchLevers.configDir, "TorchLevers_TextureSupport.txt")));
        boolean searching = true;
        String line = reader.readLine();
        while (searching && (line = reader.readLine()) != null) {
            if (!line.substring(0, 40).trim().equalsIgnoreCase(hash.trim())) continue;
            String[] nums = line.substring(40).trim().split("\\s");
            for (int i = 0; i < 8; ++i) {
                results[i] = Integer.parseInt(nums[i]);
            }
            searching = false;
        }
        reader.close();
        if (searching) {
            throw new Exception("Hash not found");
        }
        return results;
    }

    private int getPixelSize(IIcon icon) {
        String name = icon.func_94215_i();
        try {
            List resources = Minecraft.func_71410_x().func_110442_L().func_135056_b(new ResourceLocation("textures/blocks/" + name + ".png"));
            Iterator it = resources.iterator();
            IResource res = null;
            while (it.hasNext()) {
                res = (IResource)it.next();
            }
            InputStream stream = res.func_110527_b();
            BufferedImage buff = ImageIO.read(stream);
            return buff.getWidth();
        }
        catch (Exception e) {
            TorchLevers.serverLog.warn("Unable to determine size of " + name + " using 16x16.");
            return 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HiddenButtonMetadataSection getMeta(String name, InputStream stream) {
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(stream));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedreader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (HiddenButtonMetadataSection)TorchLevers.metaSerializer.func_110503_a(name, jsonobject);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (TorchLevers.versionNagNeeded && !nagged && Minecraft.func_71410_x().field_71439_g != null) {
            nagged = true;
            try {
                Utilities.tellLocalUser(TorchLevers.versionChanges);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

