/*
 * Decompiled with CFR 0.152.
 */
package torchLevers.graphics;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import torchLevers.TorchLevers;
import torchLevers.blocks.TorchButtonBlock;
import torchLevers.graphics.CommonRenderMethods;

public class TorchLeverBlockRender
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.renderBlockTorch(block, x, y, z, world, renderer);
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return false;
    }

    public int getRenderId() {
        return TorchLevers.torchRenderId;
    }

    public boolean renderBlockTorch(Block block, int x, int y, int z, IBlockAccess world, RenderBlocks renderer) {
        int side;
        int meta = world.func_72805_g(x, y, z);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c(world, x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        double distance = 0.4f;
        double offset = 0.5 - distance;
        double bottomgap = 0.2f;
        double width = 0.0625;
        int angleSwap = 0;
        if (block instanceof TorchButtonBlock) {
            angleSwap = 4;
        }
        if (meta == 1 || meta == 9) {
            side = 0;
            if (meta == 9) {
                this.renderTorchAtAngle(tess, block, (double)x - offset, (double)y + bottomgap, z, -distance, 0.0, 1 + angleSwap);
            } else {
                this.renderTorchAtAngle(tess, block, (double)x - offset, (double)y + bottomgap, z, -distance, 0.0, 0);
            }
        } else if (meta == 2 || meta == 10) {
            side = 1;
            if (meta == 10) {
                this.renderTorchAtAngle(tess, block, (double)x + offset, (double)y + bottomgap, z, distance, 0.0, 2 + angleSwap);
            } else {
                this.renderTorchAtAngle(tess, block, (double)x + offset, (double)y + bottomgap, z, distance, 0.0, 0);
            }
        } else if (meta == 3 || meta == 11) {
            side = 2;
            if (meta == 11) {
                this.renderTorchAtAngle(tess, block, x, (double)y + bottomgap, (double)z - offset, 0.0, -distance, 3 + angleSwap);
            } else {
                this.renderTorchAtAngle(tess, block, x, (double)y + bottomgap, (double)z - offset, 0.0, -distance, 0);
            }
        } else {
            side = 3;
            if (meta == 12) {
                this.renderTorchAtAngle(tess, block, x, (double)y + bottomgap, (double)z + offset, 0.0, distance, 4 + angleSwap);
            } else {
                this.renderTorchAtAngle(tess, block, x, (double)y + bottomgap, (double)z + offset, 0.0, distance, 0);
            }
        }
        if (angleSwap > 0) {
            CommonRenderMethods.renderCamoBlock(x, y, z, side, 0.5625, 0.8125, 0.6875, 0.3125, meta > 8 ? 0.0125 : width, renderer, world, tess);
        } else {
            CommonRenderMethods.renderCamoBlock(x, y, z, side, 0.1875, 0.6875, 0.6875, 0.3125, width, renderer, world, tess);
        }
        return true;
    }

    public void renderTorchAtAngle(Tessellator tess, Block block, double x, double y, double z, double xshift, double zshift, int rotation) {
        IIcon icon = block.func_149733_h(0);
        double d5 = icon.func_94209_e();
        double d6 = icon.func_94206_g();
        double d7 = icon.func_94212_f();
        double d8 = icon.func_94210_h();
        double d9 = icon.func_94214_a(7.0);
        double d10 = icon.func_94207_b(6.0);
        double d11 = icon.func_94214_a(9.0);
        double d12 = icon.func_94207_b(8.0);
        double d13 = icon.func_94214_a(7.0);
        double d14 = icon.func_94207_b(13.0);
        double d15 = icon.func_94214_a(9.0);
        double d16 = icon.func_94207_b(15.0);
        double d17 = (x += 0.5) - 0.5;
        double d18 = x + 0.5;
        double d19 = (z += 0.5) - 0.5;
        double d20 = z + 0.5;
        double d21 = 0.0625;
        double d22 = 0.625;
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift * (1.0 - d22) - d21, y + d22, z + zshift * (1.0 - d22) - d21, d9, d10, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift * (1.0 - d22) - d21, y + d22, z + zshift * (1.0 - d22) + d21, d9, d12, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift * (1.0 - d22) + d21, y + d22, z + zshift * (1.0 - d22) + d21, d11, d12, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift * (1.0 - d22) + d21, y + d22, z + zshift * (1.0 - d22) - d21, d11, d10, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + d21 + xshift, y, z - d21 + zshift, d15, d14, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + d21 + xshift, y, z + d21 + zshift, d15, d16, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21 + xshift, y, z + d21 + zshift, d13, d16, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21 + xshift, y, z - d21 + zshift, d13, d14, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21, y + 1.0, d19, d5, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21 + xshift, y + 0.0, d19 + zshift, d5, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21 + xshift, y + 0.0, d20 + zshift, d7, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x - d21, y + 1.0, d20, d7, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + d21, y + 1.0, d20, d5, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift + d21, y + 0.0, d20 + zshift, d5, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + xshift + d21, y + 0.0, d19 + zshift, d7, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, x + d21, y + 1.0, d19, d7, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d17, y + 1.0, z + d21, d5, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d17 + xshift, y + 0.0, z + d21 + zshift, d5, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d18 + xshift, y + 0.0, z + d21 + zshift, d7, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d18, y + 1.0, z + d21, d7, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d18, y + 1.0, z - d21, d5, d6, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d18 + xshift, y + 0.0, z - d21 + zshift, d5, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d17 + xshift, y + 0.0, z - d21 + zshift, d7, d8, rotation);
        this.rotvert(tess, x + xshift, y + 0.09375, z + zshift, d17, y + 1.0, z - d21, d7, d6, rotation);
    }

    protected void rotvert(Tessellator tess, double ox, double oy, double oz, double x, double y, double z, double u, double v, int rotation) {
        boolean rotBack;
        double xprime = x;
        double yprime = y;
        double zprime = z;
        double cos = 0.7071067812;
        double sin = 0.7071067812;
        boolean bl = rotBack = rotation >= 5;
        if (rotBack) {
            cos = 0.9659258263;
            sin = -0.2588190451;
            rotation -= 4;
        }
        if (rotation == 1) {
            xprime = (x - ox) * cos - (y - oy) * -sin;
            yprime = (x - ox) * -sin + (y - oy) * cos;
            xprime += ox;
            yprime += oy;
        } else if (rotation == 2) {
            xprime = (x - ox) * cos - (y - oy) * sin;
            yprime = (x - ox) * sin + (y - oy) * cos;
            xprime += ox;
            yprime += oy;
        } else if (rotation == 3) {
            yprime = (y - oy) * cos - (z - oz) * sin;
            zprime = (y - oy) * sin + (z - oz) * cos;
            yprime += oy;
            zprime += oz;
        } else if (rotation == 4) {
            yprime = (y - oy) * cos - (z - oz) * -sin;
            zprime = (y - oy) * -sin + (z - oz) * cos;
            yprime += oy;
            zprime += oz;
        }
        tess.func_78374_a(xprime, yprime, zprime, u, v);
    }
}

