/*
 * Decompiled with CFR 0.152.
 */
package torchLevers.graphics;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import torchLevers.TorchLevers;
import torchLevers.blocks.CollapsingBlock;
import torchLevers.blocks.IllusionBlock;
import torchLevers.blocks.SpikeTrap;

public class NewRenderer3D
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (block instanceof CollapsingBlock) {
            this.renderStandardInventory(block, metadata, renderer);
        }
        if (block instanceof IllusionBlock) {
            this.renderTranslucentInventory(block, Block.func_149634_a((Item)TorchLevers.illusionBlocks[metadata + ((IllusionBlock)block).metaOffset].func_77973_b()), metadata, renderer, 0.5f);
        }
        if (block instanceof SpikeTrap) {
            this.renderSpikeTrapInventory(block, metadata, renderer);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        if (block instanceof CollapsingBlock) {
            return this.renderCollapsingBlock(world, renderer, block, x, y, z, meta);
        }
        if (block instanceof IllusionBlock) {
            if (((IllusionBlock)block).getCurrentRenderPass() == 0) {
                return renderer.func_147784_q(block, x, y, z);
            }
            return this.drawInsideBlock(world, renderer, block, Block.func_149634_a((Item)TorchLevers.illusionBlocks[meta + ((IllusionBlock)block).metaOffset].func_77973_b()), x, y, z, 0.5f);
        }
        if (block instanceof SpikeTrap) {
            return this.renderSpikeTrapWorld(world, renderer, block, x, y, z);
        }
        return false;
    }

    private boolean drawInsideBlock(IBlockAccess world, RenderBlocks renderer, Block block, Block renderBlock, int x, int y, int z, float opacity) {
        int metadata = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        if (block.func_149646_a(world, x, y - 1, z, 0)) {
            this.renderFace(renderer, renderBlock, x, (double)y + 0.003, z, renderer.func_147787_a(block, 0, metadata), opacity, 0, true, false);
        }
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        if (block.func_149646_a(world, x, y + 1, z, 1)) {
            this.renderFace(renderer, renderBlock, x, (double)y - 0.003, z, renderer.func_147787_a(block, 1, metadata), opacity, 1, true, false);
        }
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (block.func_149646_a(world, x, y, z - 1, 2)) {
            this.renderFace(renderer, renderBlock, x, y, (double)z + 0.003, renderer.func_147787_a(block, 2, metadata), opacity, 2, true, false);
        }
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (block.func_149646_a(world, x, y, z + 1, 3)) {
            this.renderFace(renderer, renderBlock, x, y, (double)z - 0.003, renderer.func_147787_a(block, 3, metadata), opacity, 3, true, false);
        }
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        if (block.func_149646_a(world, x - 1, y, z, 4)) {
            this.renderFace(renderer, renderBlock, (double)x + 0.003, y, z, renderer.func_147787_a(block, 4, metadata), opacity, 4, true, false);
        }
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        if (block.func_149646_a(world, x + 1, y, z, 5)) {
            this.renderFace(renderer, renderBlock, (double)x - 0.003, y, z, renderer.func_147787_a(block, 5, metadata), opacity, 5, true, false);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return TorchLevers.newRenderers3dId;
    }

    private void renderTranslucentInventory(Block block, Block renderBlock, int metadata, RenderBlocks renderer, float opacity) {
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(1);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata), opacity, 0, false, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata), opacity, 1, false, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata), opacity, 2, false, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata), opacity, 3, false, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata), opacity, 4, false, false);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderFace(renderer, renderBlock, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata), opacity, 5, false, false);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private void renderStandardInventory(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(1);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private boolean renderSpikeTrapWorld(IBlockAccess world, RenderBlocks renderer, Block block, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        if ((metadata & 7) >= 6) {
            tessellator.func_78386_a(0.9f, 0.9f, 1.0f);
        } else {
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        }
        renderer.func_147782_a(0.03125, 0.0, 0.03125, 0.96875, 0.028, 0.96875);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, (double)x, (double)y, (double)z, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.16666667, 0.0, 0.16666667, 0.41666667, 0.035, 0.41666667);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.16666667, 0.0, 0.58333333, 0.41666667, 0.035, 0.83333333);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.58333333, 0.0, 0.16666667, 0.83333333, 0.035, 0.41666667);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.58333333, 0.0, 0.58333333, 0.83333333, 0.035, 0.83333333);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, BlockCauldron.func_150026_e((String)"inner"));
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if ((metadata & 7) == 1) {
            red = 0.7f;
            blue = 0.7f;
        }
        if ((metadata & 7) == 2) {
            red = 0.4f;
            green = 0.6f;
            blue = 0.5f;
        }
        if ((metadata & 7) == 3) {
            red = 0.65f;
            green = 0.7f;
        }
        if ((metadata & 7) == 4) {
            green = 0.6f;
            blue = 0.3f;
        }
        if ((metadata & 7) == 5) {
            red = 0.4f;
            green = 0.4f;
            blue = 0.4f;
        }
        double height = (metadata & 8) > 0 ? 1.0 : 0.04;
        this.drawSpikeWithQuads(tessellator, (double)x + 0.20666667, y + 0, (double)z + 0.20666667, (double)x + 0.37666667, (double)y + height, (double)z + 0.37666667, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpikeWithQuads(tessellator, (double)x + 0.20666667, y + 0, (double)z + 0.62333333, (double)x + 0.37666667, (double)y + height, (double)z + 0.79333333, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpikeWithQuads(tessellator, (double)x + 0.62333333, y + 0, (double)z + 0.20666667, (double)x + 0.79333333, (double)y + height, (double)z + 0.37666667, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpikeWithQuads(tessellator, (double)x + 0.62333333, y + 0, (double)z + 0.62333333, (double)x + 0.79333333, (double)y + height, (double)z + 0.79333333, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        return true;
    }

    private void renderSpikeTrapInventory(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(1);
        GL11.glTranslatef((float)-0.5f, (float)-0.3f, (float)-0.5f);
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.09, 1.0);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_149691_a(0, 0));
        tessellator.func_78381_a();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.16666667, 0.0, 0.16666667, 0.41666667, 0.1, 0.41666667);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.16666667, 0.0, 0.58333333, 0.41666667, 0.1, 0.83333333);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.58333333, 0.0, 0.16666667, 0.83333333, 0.1, 0.41666667);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147782_a(0.58333333, 0.0, 0.58333333, 0.83333333, 0.1, 0.83333333);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, BlockCauldron.func_150026_e((String)"inner"));
        tessellator.func_78381_a();
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        double height = 0.75;
        if ((metadata & 7) == 1) {
            red = 0.7f;
            blue = 0.7f;
        }
        if ((metadata & 7) == 2) {
            red = 0.4f;
            green = 0.6f;
            blue = 0.5f;
        }
        if ((metadata & 7) == 3) {
            red = 0.65f;
            green = 0.7f;
        }
        if ((metadata & 7) == 4) {
            green = 0.6f;
            blue = 0.3f;
        }
        if ((metadata & 7) == 5) {
            red = 0.4f;
            green = 0.4f;
            blue = 0.4f;
        }
        if ((metadata & 7) >= 6) {
            height = 0.4f;
        }
        this.drawSpike(tessellator, 0.20666667, 0, 0.20666667, 0.37666667, height, 0.37666667, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpike(tessellator, 0.20666667, 0, 0.62333333, 0.37666667, height, 0.79333333, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpike(tessellator, 0.62333333, 0, 0.20666667, 0.79333333, height, 0.37666667, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        this.drawSpike(tessellator, 0.62333333, 0, 0.62333333, 0.79333333, height, 0.79333333, Blocks.field_150339_S.func_149691_a(0, 0), red, green, blue);
        GL11.glTranslatef((float)0.5f, (float)0.3f, (float)0.5f);
    }

    private void drawSpike(Tessellator tessellator, double x0, int y0, double z0, double x1, double y1, double z1, IIcon icon, float r, float g, float b) {
        double topX = (x0 + x1) / 2.0;
        double topZ = (z0 + z1) / 2.0;
        double topU = icon.func_94214_a(8.0);
        double topV = icon.func_94207_b(0.0);
        double leftU = icon.func_94214_a(0.0);
        double leftV = icon.func_94207_b(16.0);
        double rightU = icon.func_94214_a(16.0);
        double rightV = icon.func_94207_b(16.0);
        tessellator.func_78371_b(4);
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x1, (double)y0, z0, rightU, rightV);
        tessellator.func_78374_a(x0, (double)y0, z0, leftU, leftV);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x1, (double)y0, z1, rightU, rightV);
        tessellator.func_78374_a(x1, (double)y0, z0, leftU, leftV);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x0, (double)y0, z1, rightU, rightV);
        tessellator.func_78374_a(x1, (double)y0, z1, leftU, leftV);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x0, (double)y0, z0, rightU, rightV);
        tessellator.func_78374_a(x0, (double)y0, z1, leftU, leftV);
        tessellator.func_78381_a();
    }

    private void drawSpikeWithQuads(Tessellator tessellator, double x0, int y0, double z0, double x1, double y1, double z1, IIcon icon, float r, float g, float b) {
        double topX = (x0 + x1) / 2.0;
        double topZ = (z0 + z1) / 2.0;
        double topU = icon.func_94214_a(8.0);
        double topV = icon.func_94207_b(0.0);
        double leftU = icon.func_94214_a(0.0);
        double leftV = icon.func_94207_b(16.0);
        double rightU = icon.func_94214_a(16.0);
        double rightV = icon.func_94207_b(16.0);
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x1, (double)y0, z0, rightU, rightV);
        tessellator.func_78374_a(x0, (double)y0, z0, leftU, leftV);
        tessellator.func_78386_a(0.6f * r, 0.6f * g, 0.6f * b);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x1, (double)y0, z1, rightU, rightV);
        tessellator.func_78374_a(x1, (double)y0, z0, leftU, leftV);
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x0, (double)y0, z1, rightU, rightV);
        tessellator.func_78374_a(x1, (double)y0, z1, leftU, leftV);
        tessellator.func_78386_a(0.6f * r, 0.6f * g, 0.6f * b);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(topX, y1, topZ, topU, topV);
        tessellator.func_78374_a(x0, (double)y0, z0, rightU, rightV);
        tessellator.func_78374_a(x0, (double)y0, z1, leftU, leftV);
    }

    private void renderWithYOffset(Block block, int metadata, RenderBlocks renderer, double yOff, double x, double y, double z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 0, metadata), 1.0f, 0, false, true);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 1, metadata), 1.0f, 1, false, true);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 2, metadata), 1.0f, 2, false, true);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 3, metadata), 1.0f, 3, false, true);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 4, metadata), 1.0f, 4, false, true);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderFace(renderer, block, x, y + yOff, z, renderer.func_147787_a(block, 5, metadata), 1.0f, 5, false, true);
    }

    private boolean renderCollapsingBlock(IBlockAccess world, RenderBlocks renderer, Block block, int x, int y, int z, int blockMetadata) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 8) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            double offset = (Math.random() - 0.5) / 5.0;
            renderer.func_147782_a(0.0, offset, 0.0, 1.0, offset + 0.5, 1.0);
            this.renderWithYOffset(block, metadata, renderer, offset, x, y, z);
        } else {
            renderer.func_147784_q(block, x, y, z);
        }
        return true;
    }

    public void renderFace(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon, float opacity, int face, boolean inward, boolean halfBlock) {
        Tessellator tessellator = Tessellator.field_78398_a;
        double d3 = par8Icon.func_94214_a(0.0);
        double d4 = par8Icon.func_94214_a(16.0);
        double d5 = par8Icon.func_94207_b(halfBlock ? (double)(face == 0 || face == 1 ? 0 : 8) : 0.0);
        double d6 = par8Icon.func_94207_b(16.0);
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        if (face == 1) {
            d11 = par2 + renderer.field_147861_i;
            d12 = par2 + renderer.field_147859_h;
            d13 = par4 + renderer.field_147857_k;
            d14 = par6 + renderer.field_147851_l;
            d15 = par6 + renderer.field_147853_m;
        } else if (face == 2) {
            d11 = par2 + renderer.field_147859_h;
            d12 = par2 + renderer.field_147861_i;
            d13 = par4 + renderer.field_147855_j;
            d14 = par4 + renderer.field_147857_k;
            d15 = par6 + renderer.field_147851_l;
        } else if (face == 3) {
            d11 = par2 + renderer.field_147861_i;
            d12 = par2 + renderer.field_147859_h;
            d13 = par4 + renderer.field_147855_j;
            d14 = par4 + renderer.field_147857_k;
            d15 = par6 + renderer.field_147853_m;
        } else if (face == 4) {
            d11 = par2 + renderer.field_147859_h;
            d12 = par4 + renderer.field_147855_j;
            d13 = par4 + renderer.field_147857_k;
            d14 = par6 + renderer.field_147851_l;
            d15 = par6 + renderer.field_147853_m;
        } else if (face == 5) {
            d11 = par2 + renderer.field_147861_i;
            d12 = par4 + renderer.field_147855_j;
            d13 = par4 + renderer.field_147857_k;
            d14 = par6 + renderer.field_147853_m;
            d15 = par6 + renderer.field_147851_l;
        }
        float downlight = 0.5f;
        float uplight = 1.0f;
        float zlight = 0.8f;
        float xlight = 0.6f;
        if (par8Icon.func_94215_i().equals("grass_top")) {
            int color = Blocks.field_150349_c.func_149741_i(0);
            float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(color & 0xFF) / 255.0f;
            tessellator.func_78369_a(f1, f2, f3, opacity);
        } else if (face == 0) {
            tessellator.func_78369_a(downlight, downlight, downlight, opacity);
        } else if (face == 1) {
            tessellator.func_78369_a(uplight, uplight, uplight, opacity);
        } else if (face == 2 || face == 3) {
            tessellator.func_78369_a(zlight, zlight, zlight, opacity);
        } else if (face == 4 || face == 5) {
            tessellator.func_78369_a(xlight, xlight, xlight, opacity);
        }
        if (!inward) {
            if (face == 0 || face == 1) {
                tessellator.func_78374_a(d11, d13, d15, d3, d6);
                tessellator.func_78374_a(d11, d13, d14, d3, d5);
                tessellator.func_78374_a(d12, d13, d14, d4, d5);
                tessellator.func_78374_a(d12, d13, d15, d4, d6);
            } else if (face == 2 || face == 3) {
                tessellator.func_78374_a(d11, d14, d15, d4, d5);
                tessellator.func_78374_a(d12, d14, d15, d3, d5);
                tessellator.func_78374_a(d12, d13, d15, d3, d6);
                tessellator.func_78374_a(d11, d13, d15, d4, d6);
            } else {
                tessellator.func_78374_a(d11, d13, d15, d4, d5);
                tessellator.func_78374_a(d11, d13, d14, d3, d5);
                tessellator.func_78374_a(d11, d12, d14, d3, d6);
                tessellator.func_78374_a(d11, d12, d15, d4, d6);
            }
        } else if (face == 0 || face == 1) {
            tessellator.func_78374_a(d12, d13, d15, d3, d6);
            tessellator.func_78374_a(d12, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d13, d14, d4, d5);
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
        } else if (face == 2 || face == 3) {
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
            tessellator.func_78374_a(d12, d13, d15, d3, d6);
            tessellator.func_78374_a(d12, d14, d15, d3, d5);
            tessellator.func_78374_a(d11, d14, d15, d4, d5);
        } else {
            tessellator.func_78374_a(d11, d12, d15, d4, d6);
            tessellator.func_78374_a(d11, d12, d14, d3, d6);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d13, d15, d4, d5);
        }
    }
}

