/*
 * Decompiled with CFR 0.152.
 */
package torchLevers.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import torchLevers.TorchLevers;

public class TorchLeverBlock
extends BlockLever {
    protected int torchType;
    protected static Map redstoneUpdateInfoCache = new HashMap();

    public TorchLeverBlock(int type) {
        this.torchType = type;
        this.func_149675_a(true);
        this.func_149711_c(0.5f).func_149672_a(field_149766_f);
        this.func_149647_a(TorchLevers.torchLeversTab);
        if (this.torchType == 0) {
            this.func_149715_a(0.9375f);
        } else if (this.torchType == 1) {
            this.func_149715_a(0.5f);
        } else {
            this.func_149647_a(null);
        }
    }

    public int func_149738_a(World par1World) {
        return 2;
    }

    public int func_149645_b() {
        return TorchLevers.torchRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        if (this.torchType == 0) {
            this.field_149761_L = Blocks.field_150478_aa.func_149733_h(0);
        } else if (this.torchType == 1) {
            this.field_149761_L = Blocks.field_150429_aA.func_149733_h(0);
        } else if (this.torchType == 2) {
            this.field_149761_L = Blocks.field_150437_az.func_149733_h(0);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 7;
        float var8 = 0.15f;
        if (meta == 1) {
            this.func_149676_a(0.0f, 0.2f, 0.5f - var8, var8 * 2.0f, 0.8f, 0.5f + var8);
        } else if (meta == 2) {
            this.func_149676_a(1.0f - var8 * 2.0f, 0.2f, 0.5f - var8, 1.0f, 0.8f, 0.5f + var8);
        } else if (meta == 3) {
            this.func_149676_a(0.5f - var8, 0.2f, 0.0f, 0.5f + var8, 0.8f, var8 * 2.0f);
        } else if (meta == 4) {
            this.func_149676_a(0.5f - var8, 0.2f, 1.0f - var8 * 2.0f, 0.5f + var8, 0.8f, 1.0f);
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int par5) {
        switch (par5) {
            case 2: {
                return world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true);
            }
            case 3: {
                return world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true);
            }
            case 4: {
                return world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true);
            }
            case 5: {
                return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random par5Random) {
        if (this.torchType == 0) {
            int meta = world.func_72805_g(x, y, z);
            double xpos = (float)x + 0.5f;
            double ypos = (float)y + 0.7f;
            double zpos = (float)z + 0.5f;
            double heightOffset = 0.22f;
            double directionOffset = 0.27f;
            if (meta == 1) {
                world.func_72869_a("smoke", xpos - directionOffset, ypos + heightOffset, zpos, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", xpos - directionOffset, ypos + heightOffset, zpos, 0.0, 0.0, 0.0);
            } else if (meta == 2) {
                world.func_72869_a("smoke", xpos + directionOffset, ypos + heightOffset, zpos, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", xpos + directionOffset, ypos + heightOffset, zpos, 0.0, 0.0, 0.0);
            } else if (meta == 3) {
                world.func_72869_a("smoke", xpos, ypos + heightOffset, zpos - directionOffset, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", xpos, ypos + heightOffset, zpos - directionOffset, 0.0, 0.0, 0.0);
            } else if (meta == 4) {
                world.func_72869_a("smoke", xpos, ypos + heightOffset, zpos + directionOffset, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", xpos, ypos + heightOffset, zpos + directionOffset, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("smoke", xpos, ypos - (double)0.07f, zpos, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", xpos, ypos - (double)0.07f, zpos, 0.0, 0.0, 0.0);
            }
        } else if (this.torchType == 1) {
            int l = world.func_72805_g(x, y, z);
            double d0 = (double)((float)x + 0.5f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)y + 0.7f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)z + 0.5f) + (double)(par5Random.nextFloat() - 0.5f) * 0.2;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a("reddust", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("reddust", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("reddust", d0, d1 - (double)0.07f, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World par1World, int par2, int par3, int par4) {
        if (this.torchType == 0) {
            return new ItemStack(TorchLevers.torchLever);
        }
        return new ItemStack(TorchLevers.redstoneTorchLever);
    }

    public boolean func_149667_c(Block block) {
        if (this.torchType == 0) {
            return block == TorchLevers.torchLever;
        }
        return block == TorchLevers.redstoneTorchLever || block == TorchLevers.redstoneTorchLeverOff;
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        int i1 = par1IBlockAccess.func_72805_g(par2, par3, par4);
        if ((i1 & 8) == 0) {
            return this.torchType == 1 && par5 == 0 ? this.func_149709_b(par1IBlockAccess, par2, par3, par4, par5) : 0;
        }
        int j1 = i1 & 7;
        return j1 == 1 && par5 == 5 ? 15 : (j1 == 4 && par5 == 2 ? 15 : (j1 == 3 && par5 == 3 ? 15 : (j1 == 2 && par5 == 4 ? 15 : (this.torchType == 1 && par5 == 0 ? this.func_149709_b(par1IBlockAccess, par2, par3, par4, par5) : 0))));
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block block) {
        super.func_149695_a(par1World, par2, par3, par4, block);
        if (this.torchType != 0 && !par1World.func_147437_c(par2, par3, par4) && (par1World.func_72805_g(par2, par3, par4) & 8) == 0) {
            boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4);
            if (this.torchType == 1 && flag || this.torchType == 2 && !flag) {
                par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World));
            }
        }
    }

    protected boolean checkForBurnout(World par1World, int par2, int par3, int par4, boolean par5) {
        if (!redstoneUpdateInfoCache.containsKey(par1World)) {
            redstoneUpdateInfoCache.put(par1World, new ArrayList());
        }
        List list = (List)redstoneUpdateInfoCache.get(par1World);
        if (par5) {
            list.add(new RedstoneUpdateInfo(par2, par3, par4, par1World.func_82737_E()));
        }
        int l = 0;
        for (int i1 = 0; i1 < list.size(); ++i1) {
            RedstoneUpdateInfo redstoneupdateinfo = (RedstoneUpdateInfo)list.get(i1);
            if (redstoneupdateinfo.x != par2 || redstoneupdateinfo.y != par3 || redstoneupdateinfo.z != par4 || ++l < 8) continue;
            return true;
        }
        return false;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.torchType == 0) {
            return;
        }
        boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4);
        List list = (List)redstoneUpdateInfoCache.get(par1World);
        while (list != null && !list.isEmpty() && par1World.func_82737_E() - ((RedstoneUpdateInfo)list.get((int)0)).updateTime > 60L) {
            list.remove(0);
        }
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (this.torchType == 1 && (meta & 8) == 0) {
            if (flag) {
                par1World.func_147465_d(par2, par3, par4, TorchLevers.redstoneTorchLeverOff, meta, 3);
                if (this.checkForBurnout(par1World, par2, par3, par4, true)) {
                    par1World.func_72908_a((double)((float)par2 + 0.5f), (double)((float)par3 + 0.5f), (double)((float)par4 + 0.5f), "random.fizz", 0.5f, 2.6f + (par1World.field_73012_v.nextFloat() - par1World.field_73012_v.nextFloat()) * 0.8f);
                    for (int l = 0; l < 5; ++l) {
                        double d0 = (double)par2 + par5Random.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)par3 + par5Random.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)par4 + par5Random.nextDouble() * 0.6 + 0.2;
                        par1World.func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if ((meta & 8) == 0 && !flag && !this.checkForBurnout(par1World, par2, par3, par4, false)) {
            par1World.func_147465_d(par2, par3, par4, TorchLevers.redstoneTorchLever, meta, 3);
        }
    }

    protected boolean isIndirectlyPowered(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        return l == 5 && par1World.func_94574_k(par2, par3 - 1, par4, 0) ? true : (l == 3 && par1World.func_94574_k(par2, par3, par4 - 1, 2) ? true : (l == 4 && par1World.func_94574_k(par2, par3, par4 + 1, 3) ? true : (l == 1 && par1World.func_94574_k(par2 - 1, par3, par4, 4) ? true : l == 2 && par1World.func_94574_k(par2 + 1, par3, par4, 5))));
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        int pow;
        if (this.torchType != 1) {
            return (par1IBlockAccess.func_72805_g(par2, par3, par4) & 8) > 0 ? 15 : 0;
        }
        int i1 = par1IBlockAccess.func_72805_g(par2, par3, par4) & 7;
        int n = i1 == 3 && par5 == 3 ? 0 : (i1 == 4 && par5 == 2 ? 0 : (i1 == 1 && par5 == 5 ? 0 : (pow = i1 == 2 && par5 == 4 ? 0 : 15)));
        return pow != 0 ? pow : ((par1IBlockAccess.func_72805_g(par2, par3, par4) & 8) > 0 ? 15 : 0);
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (this.torchType == 1) {
            par1World.func_147459_d(par2, par3 - 1, par4, (Block)this);
            par1World.func_147459_d(par2, par3 + 1, par4, (Block)this);
            par1World.func_147459_d(par2 - 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2 + 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2, par3, par4 - 1, (Block)this);
            par1World.func_147459_d(par2, par3, par4 + 1, (Block)this);
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        if (this.torchType == 2) {
            return Item.func_150898_a((Block)TorchLevers.redstoneTorchLever);
        }
        return Item.func_150898_a((Block)TorchLevers.torchLever);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        if (this.torchType == 1) {
            par1World.func_147459_d(par2, par3 - 1, par4, (Block)this);
            par1World.func_147459_d(par2, par3 + 1, par4, (Block)this);
            par1World.func_147459_d(par2 - 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2 + 1, par3, par4, (Block)this);
            par1World.func_147459_d(par2, par3, par4 - 1, (Block)this);
            par1World.func_147459_d(par2, par3, par4 + 1, (Block)this);
        }
    }

    protected static class RedstoneUpdateInfo {
        int x;
        int y;
        int z;
        long updateTime;

        public RedstoneUpdateInfo(int par1, int par2, int par3, long par4) {
            this.x = par1;
            this.y = par2;
            this.z = par3;
            this.updateTime = par4;
        }
    }
}

