/*
 * Decompiled with CFR 0.152.
 */
package torchLevers.graphics;

import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import torchLevers.graphics.IconShifted;
import torchLevers.graphics.StripIcon;

public class CommonRenderMethods {
    public static void renderCamoBlock(int x, int y, int z, int side, double top, double bottom, double left, double right, double width, RenderBlocks renderer, IBlockAccess world, Tessellator tess) {
        Block wall = null;
        IIcon wallFace = null;
        if (side == 0) {
            wall = world.func_147439_a(x - 1, y, z);
        }
        if (side == 1) {
            wall = world.func_147439_a(x + 1, y, z);
        }
        if (side == 2) {
            wall = world.func_147439_a(x, y, z - 1);
        }
        if (side == 3) {
            wall = world.func_147439_a(x, y, z + 1);
        }
        if (wall != null) {
            if (side == 0) {
                wallFace = wall.func_149673_e(world, x - 1, y, z, 5);
                renderer.func_147782_a(0.0, bottom, 1.0 - right, width, top, 1.0 - left);
            }
            if (side == 1) {
                wallFace = wall.func_149673_e(world, x + 1, y, z, 4);
                renderer.func_147782_a(1.0 - width, bottom, left, 1.0, top, right);
            }
            if (side == 2) {
                wallFace = wall.func_149673_e(world, x, y, z - 1, 3);
                renderer.func_147782_a(left, bottom, 0.0, right, top, width);
            }
            if (side == 3) {
                wallFace = wall.func_149673_e(world, x, y, z + 1, 2);
                renderer.func_147782_a(1.0 - right, bottom, 1.0 - width, 1.0 - left, top, 1.0);
            }
            if (wallFace != null) {
                int color = wall.func_149720_d(renderer.field_147845_a, x, y, z);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                IIcon topIcon = CommonRenderMethods.getIconForFace(0, 1.0 - top, wallFace);
                IIcon bottomIcon = CommonRenderMethods.getIconForFace(1, 1.0 - bottom, wallFace);
                IIcon leftIcon = CommonRenderMethods.getIconForFace(2, left, wallFace);
                IIcon rightIcon = CommonRenderMethods.getIconForFace(3, right, wallFace);
                if (side == 0) {
                    renderer.field_147867_u = 2;
                    renderer.field_147865_v = 1;
                    wallFace = left >= 8.0 ? new IconShifted(wallFace, (float)(2.0 * (8.0 - right * 16.0) - 16.0 * (left - right)), 0.0f) : new IconShifted(wallFace, (float)(2.0 * (8.0 - left * 16.0) + 16.0 * (left - right)), 0.0f);
                } else if (side == 1) {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 2;
                } else if (side == 3) {
                    renderer.field_147867_u = 3;
                    renderer.field_147865_v = 3;
                    wallFace = left >= 8.0 ? new IconShifted(wallFace, (float)(2.0 * (8.0 - right * 16.0) - 16.0 * (left - right)), 0.0f) : new IconShifted(wallFace, (float)(2.0 * (8.0 - left * 16.0) + 16.0 * (left - right)), 0.0f);
                }
                CommonRenderMethods.renderWithColor(wall, x, y, z, red, green, blue, side, renderer, world, tess, wallFace, topIcon, bottomIcon, leftIcon, rightIcon, left, top, right, bottom);
                renderer.field_147867_u = 0;
                renderer.field_147865_v = 0;
            }
        }
    }

    private static void renderWithColor(Block wall, int par2, int par3, int par4, float par5, float par6, float par7, int side, RenderBlocks renderer, IBlockAccess world, Tessellator tess, IIcon wallFace, IIcon topIcon, IIcon bottomIcon, IIcon leftIcon, IIcon rightIcon, double left, double top, double right, double bottom) {
        float g;
        renderer.field_147863_w = false;
        int l = wall.func_149677_c(world, par2, par3, par4);
        float colorLight = 1.0f;
        if (Minecraft.func_71379_u()) {
            int leftX = 0;
            int leftZ = 0;
            if (side == 0) {
                leftZ = -1;
            }
            if (side == 1) {
                leftZ = 1;
            }
            if (side == 2) {
                leftX = 1;
            }
            if (side == 3) {
                leftX = -1;
            }
            float cardinalOccusion = wall.func_149685_I();
            cardinalOccusion += wall.func_149685_I();
            cardinalOccusion += wall.func_149685_I();
            cardinalOccusion += wall.func_149685_I();
            float tertiaryOccusion = wall.func_149685_I();
            tertiaryOccusion += wall.func_149685_I();
            tertiaryOccusion += wall.func_149685_I();
            tertiaryOccusion += wall.func_149685_I();
            colorLight = 1.0f - (1.0f - (cardinalOccusion /= 4.0f)) / 1.881f - (1.0f - (tertiaryOccusion /= 4.0f)) / 4.7975f;
            int bTL = wall.func_149677_c(world, par2 + leftX, par3 + 1, par4 + leftZ);
            int bT = wall.func_149677_c(world, par2, par3 + 1, par4);
            int bTR = wall.func_149677_c(world, par2 - leftX, par3 + 1, par4 - leftZ);
            int bL = wall.func_149677_c(world, par2 + leftX, par3, par4 + leftZ);
            int bR = wall.func_149677_c(world, par2 - leftX, par3, par4 - leftZ);
            int bBL = wall.func_149677_c(world, par2 + leftX, par3 - 1, par4 + leftZ);
            int bB = wall.func_149677_c(world, par2, par3 - 1, par4);
            int bBR = wall.func_149677_c(world, par2 - leftX, par3 - 1, par4 - leftZ);
            int p = renderer.func_147778_a(bL, bTL, bT, l) / 4;
            p += renderer.func_147778_a(bR, bTR, bT, l) / 4;
            p += renderer.func_147778_a(bL, bBL, bB, l) / 4;
            p += renderer.func_147778_a(bR, bBR, bB, l) / 4;
            l = p;
        }
        float b = g = 0.8f * colorLight;
        float r = g;
        if (side == 0 || side == 1) {
            b = g = 0.6f * colorLight;
            r = g;
        }
        if (wall != Blocks.field_150349_c) {
            r *= par5;
            b *= par6;
            g *= par7;
        }
        tess.func_78380_c(l);
        colorLight = 0.1f;
        tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
        renderer.func_147768_a(wall, (double)par2, (double)par3, (double)par4, bottomIcon);
        colorLight = -0.1f;
        tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
        renderer.func_147806_b(wall, (double)par2, (double)par3, (double)par4, topIcon);
        if (RenderBlocks.field_147843_b && wallFace.func_94215_i().equals("grass_side")) {
            IIcon overlayBottom = CommonRenderMethods.getIconForFace(1, 1.0 - bottom, BlockGrass.func_149990_e());
            IIcon overlayTop = CommonRenderMethods.getIconForFace(0, 1.0 - top, BlockGrass.func_149990_e());
            colorLight = 0.1f;
            tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
            renderer.func_147768_a(wall, (double)par2, (double)par3, (double)par4, overlayBottom);
            colorLight = -0.1f;
            tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
            renderer.func_147806_b(wall, (double)par2, (double)par3, (double)par4, overlayTop);
        }
        IIcon icon = wallFace;
        colorLight = 0.0f;
        if (side == 0) {
            icon = rightIcon;
            colorLight = 0.05f;
        }
        if (side == 1) {
            icon = leftIcon;
            colorLight = -0.05f;
        }
        if (side != 2) {
            tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
            renderer.func_147761_c(wall, (double)par2, (double)par3, (double)par4, icon);
            if (RenderBlocks.field_147843_b && icon.func_94215_i().equals("grass_side")) {
                Object overlay = BlockGrass.func_149990_e();
                overlay = side == 0 ? CommonRenderMethods.getIconForFace(3, right, overlay) : (side == 1 ? CommonRenderMethods.getIconForFace(2, left, overlay) : (left >= 8.0 ? new IconShifted((IIcon)overlay, (float)(2.0 * (8.0 - right * 16.0) - 16.0 * (left - right)), 0.0f) : new IconShifted((IIcon)overlay, (float)(2.0 * (8.0 - left * 16.0) + 16.0 * (left - right)), 0.0f)));
                tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
                renderer.func_147761_c(wall, (double)par2, (double)par3, (double)par4, overlay);
            }
        }
        icon = wallFace;
        colorLight = 0.0f;
        if (side == 0) {
            icon = leftIcon;
            colorLight = -0.05f;
        }
        if (side == 1) {
            icon = rightIcon;
            colorLight = 0.05f;
        }
        if (side != 3) {
            tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
            renderer.func_147734_d(wall, (double)par2, (double)par3, (double)par4, icon);
            if (RenderBlocks.field_147843_b && icon.func_94215_i().equals("grass_side")) {
                IIcon overlay = BlockGrass.func_149990_e();
                if (side == 0) {
                    overlay = CommonRenderMethods.getIconForFace(2, left, overlay);
                } else if (side == 1) {
                    overlay = CommonRenderMethods.getIconForFace(3, right, overlay);
                }
                tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
                renderer.func_147734_d(wall, (double)par2, (double)par3, (double)par4, overlay);
            }
        }
        icon = wallFace;
        colorLight = 0.0f;
        if (side == 2) {
            icon = leftIcon;
            colorLight = -0.05f;
        }
        if (side == 3) {
            icon = rightIcon;
            colorLight = 0.05f;
        }
        if (side != 0) {
            tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
            renderer.func_147798_e(wall, (double)par2, (double)par3, (double)par4, icon);
            if (RenderBlocks.field_147843_b && icon.func_94215_i().equals("grass_side")) {
                IIcon overlay = BlockGrass.func_149990_e();
                if (side == 2) {
                    overlay = CommonRenderMethods.getIconForFace(2, left, overlay);
                } else if (side == 3) {
                    overlay = CommonRenderMethods.getIconForFace(3, right, overlay);
                }
                tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
                renderer.func_147798_e(wall, (double)par2, (double)par3, (double)par4, overlay);
            }
        }
        icon = wallFace;
        colorLight = 0.0f;
        if (side == 2) {
            icon = rightIcon;
            colorLight = 0.05f;
        }
        if (side == 3) {
            icon = leftIcon;
            colorLight = -0.05f;
        }
        if (side != 1) {
            tess.func_78386_a(r + colorLight, b + colorLight, g + colorLight);
            renderer.func_147764_f(wall, (double)par2, (double)par3, (double)par4, icon);
            if (RenderBlocks.field_147843_b && icon.func_94215_i().equals("grass_side")) {
                Object overlay = BlockGrass.func_149990_e();
                overlay = side == 2 ? CommonRenderMethods.getIconForFace(3, right, overlay) : (side == 3 ? CommonRenderMethods.getIconForFace(2, left, overlay) : (left >= 8.0 ? new IconShifted((IIcon)overlay, (float)(2.0 * (8.0 - right * 16.0) - 16.0 * (left - right)), 0.0f) : new IconShifted((IIcon)overlay, (float)(2.0 * (8.0 - left * 16.0) + 16.0 * (left - right)), 0.0f)));
                tess.func_78386_a(r * par5 + colorLight, b * par6 + colorLight, g * par7 + colorLight);
                renderer.func_147764_f(wall, (double)par2, (double)par3, (double)par4, overlay);
            }
        }
    }

    private static IIcon getIconForFace(int face, double value, IIcon base_icon) {
        if (face == 0) {
            return new StripIcon(base_icon, true, value * 16.0 - 0.01);
        }
        if (face == 1) {
            return new StripIcon(base_icon, true, value * 16.0 + 0.01);
        }
        if (face == 2) {
            return new StripIcon(base_icon, false, value * 16.0 - 0.01);
        }
        if (face == 3) {
            return new StripIcon(base_icon, false, value * 16.0 + 0.01);
        }
        return base_icon;
    }
}

