/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zotmc.tomahawk.CommonProxy;
import zotmc.tomahawk.EntityTomahawk;
import zotmc.tomahawk.OnlySilverHandler;

@Mod(modid="axetomahawk", name="Tomahawk", version="1.0.0.1-1.7.2")
public class Tomahawk {
    public static final String MODID = "axetomahawk";
    public static final String NAME = "Tomahawk";
    public static final String PACKAGE_NAME = "zotmc.tomahawk";
    @SidedProxy(clientSide="zotmc.tomahawk.ClientProxy", serverSide="zotmc.tomahawk.CommonProxy")
    public static CommonProxy proxy;
    private Random rand = new Random();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        EntityRegistry.registerModEntity(EntityTomahawk.class, (String)"tomahawk", (int)0, (Object)this, (int)64, (int)1, (boolean)true);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerRenderer();
        if (Loader.isModLoaded((String)"onlysilver")) {
            OnlySilverHandler.registerWeaponFunction();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item;
        if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (item = event.entityPlayer.func_70694_bm()) != null && item.func_77973_b() instanceof ItemAxe) {
            EntityPlayer player = event.entityPlayer;
            World world = player.field_70170_p;
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                boolean useBlock;
                int x = event.x;
                int y = event.y;
                int z = event.z;
                Block block = world.func_147439_a(x, y, z);
                boolean isAir = block.isAir((IBlockAccess)world, x, y, z);
                boolean bl = useBlock = !player.func_70093_af();
                if (!useBlock) {
                    useBlock = player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, x, y, z, player);
                }
                if (useBlock && event.useBlock != Event.Result.DENY && block.func_149727_a(world, x, y, z, player, event.face, 0.5f, 0.5f, 0.5f)) {
                    event.useBlock = Event.Result.DENY;
                    return;
                }
            }
            EntityTomahawk tomahawk = new EntityTomahawk(world, player, item);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70062_b(0, null);
            } else {
                tomahawk.canBePickedUp = false;
            }
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.2f) + 0.5f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)tomahawk);
            }
            player.func_71038_i();
        }
    }

    public static void onCritical(Entity attacker, Entity victim) {
        if (attacker.field_70170_p instanceof WorldServer) {
            ((WorldServer)attacker.field_70170_p).func_73039_n().func_151248_b(attacker, (Packet)new S0BPacketAnimation(victim, 4));
        }
    }

    public static void onEnchantmentCritical(Entity attacker, Entity victim) {
        if (attacker.field_70170_p instanceof WorldServer) {
            ((WorldServer)attacker.field_70170_p).func_73039_n().func_151248_b(attacker, (Packet)new S0BPacketAnimation(victim, 5));
        }
    }

    public static Field findField(Class<?> clz, String ... names) {
        Field f = null;
        for (String s : ObfuscationReflectionHelper.remapFieldNames((String)clz.getName(), (String[])names)) {
            try {
                f = clz.getDeclaredField(s);
                f.setAccessible(true);
                break;
            }
            catch (Exception ignored) {
            }
        }
        return (Field)Preconditions.checkNotNull(f);
    }

    public static MethodFinder findMethod(Class<?> clz, String ... names) {
        return new MethodFinder(clz, names);
    }

    private static String[] remapMethodNames(String className, String ... methodNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[methodNames.length];
        int i = 0;
        for (String mName : methodNames) {
            mappedNames[i++] = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, mName, null);
        }
        return mappedNames;
    }

    public static class MethodFinder {
        private final Class<?> clz;
        private final String[] names;

        private MethodFinder(Class<?> clz, String[] names) {
            this.clz = clz;
            this.names = names;
        }

        public Method withArgs(Class<?> ... parameterTypes) {
            Method m = null;
            for (String s : Tomahawk.remapMethodNames(this.clz.getName(), this.names)) {
                try {
                    m = this.clz.getDeclaredMethod(s, parameterTypes);
                    m.setAccessible(true);
                    break;
                }
                catch (Exception ignored) {
                }
            }
            return (Method)Preconditions.checkNotNull(m);
        }
    }
}

