/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zotmc.tomahawk.AbstractTomahawk;
import zotmc.tomahawk.Enchs;
import zotmc.tomahawk.Tomahawk;

public class EntityTomahawk
extends AbstractTomahawk {
    private static final Random RAND = new Random();
    final float deltaYaw;
    private float damageAttr;
    private int knockbackStr;
    public boolean canBePickedUp;

    public EntityTomahawk(World world) {
        super(world);
        this.deltaYaw = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 8.0f : 0.0f;
        this.canBePickedUp = true;
    }

    public EntityTomahawk(World world, EntityPlayer thrower, ItemStack item) {
        super(world, thrower);
        this.deltaYaw = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 8.0f : 0.0f;
        this.canBePickedUp = true;
        this.setItem(item);
        this.damageAttr = (float)thrower.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (thrower.func_70051_ag()) {
            this.knockbackStr = 1;
            thrower.func_70031_b(false);
        }
        if (!(!(thrower.field_70143_R > 0.0f) || thrower.field_70122_E || thrower.func_70617_f_() || thrower.func_70090_H() || thrower.func_70644_a(Potion.field_76440_q) || thrower.field_70154_o != null)) {
            this.setIsCritical(true);
        }
        thrower.func_71020_j(0.3f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(2, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(3, (Object)0);
        this.func_70096_w().func_82709_a(10, 5);
        this.func_70096_w().func_75682_a(16, (Object)0);
    }

    public void setRotation(float value) {
        this.func_70096_w().func_75692_b(2, (Object)Float.valueOf(value));
    }

    public float getRotation() {
        return this.func_70096_w().func_111145_d(2);
    }

    public void setAfterHit(boolean value) {
        this.func_70096_w().func_75692_b(3, (Object)(value ? (byte)1 : 0));
    }

    public boolean getAfterHit() {
        return (this.func_70096_w().func_75683_a(3) & 1) != 0;
    }

    public void setItem(ItemStack value) {
        this.func_70096_w().func_75692_b(10, (Object)value);
        this.func_70096_w().func_82708_h(10);
    }

    public ItemStack getItem() {
        return this.func_70096_w().func_82710_f(10);
    }

    public void setIsCritical(boolean value) {
        this.func_70096_w().func_75692_b(16, (Object)(value ? (byte)1 : 0));
    }

    public boolean getIsCritical() {
        return (this.func_70096_w().func_75683_a(16) & 1) != 0;
    }

    @Override
    public int getLifespan() {
        if (this.canBePickedUp) {
            ItemStack item = this.getItem();
            return item.func_77973_b().getEntityLifespan(item, this.field_70170_p);
        }
        return super.getLifespan();
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74776_a("rotation", this.getRotation());
        tags.func_74757_a("afterHit", this.getAfterHit());
        tags.func_74782_a("item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        tags.func_74776_a("damageAttr", this.damageAttr);
        tags.func_74777_a("knockbackStr", (short)this.knockbackStr);
        tags.func_74757_a("canBePickedUp", this.canBePickedUp);
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.setRotation(tags.func_74760_g("rotation"));
        this.setAfterHit(tags.func_74767_n("afterHit"));
        this.setItem(ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("item")));
        this.damageAttr = tags.func_74760_g("damageAttr");
        this.knockbackStr = tags.func_74765_d("knockbackStr");
        this.canBePickedUp = tags.func_74767_n("canBePickedUp");
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70193_a) {
            boolean afterHit = this.getAfterHit();
            float rotation = this.getRotation() + (float)(afterHit ? 32 : 72);
            if (rotation >= 180.0f) {
                rotation -= 360.0f;
            }
            this.setRotation(rotation);
            if (!afterHit) {
                if ((Integer)this.field_70195_i.get() % 7 == 6) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                if (this.getIsCritical()) {
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                    }
                }
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && (this.field_70193_a || this.getAfterHit()) && this.field_70191_b <= 0) {
            boolean flag = this.canBePickedUp || !this.canBePickedUp && player.field_71075_bZ.field_75098_d;
            ItemStack item = this.getItem();
            if (this.canBePickedUp && !player.field_71071_by.func_70441_a(item)) {
                flag = false;
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, item.field_77994_a);
                this.func_70106_y();
            }
        }
    }

    @Override
    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.getAfterHit() && mop.field_72308_g != null && mop.field_72308_g.func_70075_an() && !mop.field_72308_g.func_85031_j((Entity)this)) {
            ItemStack item = this.getItem();
            float damage = this.damageAttr;
            float enchCrit = 0.0f;
            int knock = this.knockbackStr;
            if (mop.field_72308_g instanceof EntityLivingBase) {
                enchCrit = Enchs.getEnchantmentModifierLiving(item, (EntityLivingBase)mop.field_72308_g);
                knock += EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)item);
            }
            if (damage > 0.0f || enchCrit > 0.0f) {
                EntityLivingBase thrower;
                boolean attacked;
                boolean critical;
                boolean bl = critical = this.getIsCritical() && mop.field_72308_g instanceof EntityLivingBase;
                if (critical && damage > 0.0f) {
                    damage *= 1.5f;
                }
                damage += enchCrit;
                boolean setFire = false;
                int fire = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)item);
                if (fire > 0 && mop.field_72308_g instanceof EntityLivingBase && !mop.field_72308_g.func_70027_ad()) {
                    setFire = true;
                    mop.field_72308_g.func_70015_d(1);
                }
                if (attacked = mop.field_72308_g.func_70097_a((thrower = this.func_85052_h()) != null ? DamageSource.func_76356_a((Entity)this, (Entity)thrower) : DamageSource.func_76356_a((Entity)this, (Entity)this), damage)) {
                    IEntityMultiPart dragon;
                    if (knock > 0) {
                        float hv = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                        mop.field_72308_g.func_70024_g((double)((float)this.field_70159_w / hv * (float)knock * 0.5f), 0.1, (double)((float)this.field_70179_y / hv * (float)knock * 0.5f));
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                    }
                    if (critical) {
                        Tomahawk.onCritical((Entity)this, mop.field_72308_g);
                    }
                    if (enchCrit > 0.0f) {
                        Tomahawk.onEnchantmentCritical((Entity)this, mop.field_72308_g);
                    }
                    try {
                        Enchs.applyEnchantmentDamageIterator(thrower, item, mop.field_72308_g);
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    Entity entity = mop.field_72308_g;
                    if (mop.field_72308_g instanceof EntityDragonPart && (dragon = ((EntityDragonPart)mop.field_72308_g).field_70259_a) != null && dragon instanceof EntityLivingBase) {
                        entity = (Entity)dragon;
                    }
                    if (item != null && entity instanceof EntityLivingBase) {
                        if (thrower instanceof EntityPlayer) {
                            item.func_77961_a((EntityLivingBase)entity, (EntityPlayer)thrower);
                        } else {
                            item.func_96631_a(2, this.field_70146_Z);
                        }
                        if (item.field_77994_a <= 0) {
                            this.func_70106_y();
                        }
                    }
                    if (mop.field_72308_g instanceof EntityLivingBase && fire > 0) {
                        mop.field_72308_g.func_70015_d(fire * 4);
                    }
                } else if (setFire) {
                    mop.field_72308_g.func_70066_B();
                }
            }
            double nX = this.field_70165_t - mop.field_72307_f.field_72450_a;
            double nY = this.field_70163_u - mop.field_72307_f.field_72448_b;
            double nZ = this.field_70161_v - mop.field_72307_f.field_72449_c;
            double n = Math.sqrt(nX * nX + nY * nY + nZ * nZ);
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            double r = 2.0 * (this.field_70159_w * (nX /= n) + this.field_70181_x * (nY /= n) + this.field_70179_y * (nZ /= n));
            this.field_70159_w = 0.25 * (this.field_70159_w - r * nX);
            this.field_70181_x = 0.25 * (this.field_70181_x - r * nY);
            this.field_70179_y = 0.25 * (this.field_70179_y - r * nZ);
            this.field_70181_x += 0.1;
            this.setAfterHit(true);
        } else {
            super.func_70184_a(mop);
        }
    }
}

