/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zotmc.tomahawk.FieldAccess;
import zotmc.tomahawk.Tomahawk;

public abstract class AbstractTomahawk
extends EntityThrowable {
    private static final Field X = AbstractTomahawk.findField("field_145788_c");
    private static final Field Y = AbstractTomahawk.findField("field_145786_d");
    private static final Field Z = AbstractTomahawk.findField("field_145787_e");
    private static final Field TICKS_IN_GROUND = AbstractTomahawk.findField("ticksInGround", "field_70194_h");
    private static final Field TICKS_IN_AIR = AbstractTomahawk.findField("ticksInAir", "field_70195_i");
    private static final Field GROUND = AbstractTomahawk.findField("field_145785_f");
    protected final FieldAccess<Integer> x = FieldAccess.of(X, (Object)this);
    protected final FieldAccess<Integer> y = FieldAccess.of(Y, (Object)this);
    protected final FieldAccess<Integer> z = FieldAccess.of(Z, (Object)this);
    protected final FieldAccess<Integer> field_70194_h = FieldAccess.of(TICKS_IN_GROUND, (Object)this);
    protected final FieldAccess<Integer> field_70195_i = FieldAccess.of(TICKS_IN_AIR, (Object)this);
    protected final FieldAccess<Block> ground = FieldAccess.of(GROUND, (Object)this);

    private static Field findField(String ... names) {
        return Tomahawk.findField(EntityThrowable.class, names);
    }

    public AbstractTomahawk(World world) {
        super(world);
    }

    public AbstractTomahawk(World world, EntityPlayer thrower) {
        super(world, (EntityLivingBase)thrower);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected float getDragFactor() {
        return 0.015f;
    }

    protected float func_70185_h() {
        return 0.09f;
    }

    protected int getLifespan() {
        return 1200;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70030_z();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.field_70193_a) {
            if (this.field_70170_p.func_147439_a(this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue()) == this.ground.get()) {
                this.field_70194_h.set(this.field_70194_h.get() + 1);
                if (this.field_70194_h.get().intValue() == this.getLifespan()) {
                    this.func_70106_y();
                }
                return;
            }
            this.field_70193_a = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70194_h.set(0);
            this.field_70195_i.set(0);
        } else {
            this.field_70195_i.set(this.field_70195_i.get() + 1);
        }
        Vec3 pos = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 pos1 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition mop = this.field_70170_p.func_72933_a(pos, pos1);
        pos = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        pos1 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (mop != null) {
            pos1 = this.field_70170_p.func_82732_R().func_72345_a(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity nearest = null;
            List onTrack = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double min = 0.0;
            EntityLivingBase thrower = this.func_85052_h();
            for (int i = 0; i < onTrack.size(); ++i) {
                double d;
                float f;
                AxisAlignedBB aabb;
                MovingObjectPosition intersect;
                Entity candidate = (Entity)onTrack.get(i);
                if (!candidate.func_70067_L() || candidate == thrower && this.field_70195_i.get() < 5 || (intersect = (aabb = candidate.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(pos, pos1)) == null || !((d = pos.func_72438_d(intersect.field_72307_f)) < min) && min != 0.0) continue;
                nearest = candidate;
                min = d;
            }
            if (nearest != null) {
                mop = new MovingObjectPosition(nearest);
            }
        }
        if (mop != null) {
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == Blocks.field_150427_aO) {
                this.func_70063_aa();
            } else {
                this.func_70184_a(mop);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float hv = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, hv) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float v = MathHelper.func_76133_a((double)((double)(hv * hv) + this.field_70181_x * this.field_70181_x));
        float r = MathHelper.func_76131_a((float)(1.0f - this.getDragFactor() / v), (float)0.0f, (float)1.0f);
        float g = this.func_70185_h();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float tail = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)tail, this.field_70163_u - this.field_70181_x * (double)tail, this.field_70161_v - this.field_70179_y * (double)tail, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            r *= 0.8f;
        }
        this.field_70159_w *= (double)r;
        this.field_70181_x *= (double)r;
        this.field_70179_y *= (double)r;
        this.field_70181_x -= (double)g;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.x.set(mop.field_72311_b);
            this.y.set(mop.field_72312_c);
            this.z.set(mop.field_72309_d);
            this.ground.set(this.field_70170_p.func_147439_a(this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue()));
            this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
            this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
            this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
            float v = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)v * 0.05;
            this.field_70163_u -= this.field_70181_x / (double)v * 0.05;
            this.field_70161_v -= this.field_70179_y / (double)v * 0.05;
            this.func_85030_a("random.bowhit", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70193_a = true;
            if (this.ground.get().func_149688_o() != Material.field_151579_a) {
                this.ground.get().func_149670_a(this.field_70170_p, this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue(), (Entity)this);
            }
        }
    }
}

