/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.timecontrol;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import grim3212.mc.core.Grim3212Core;
import grim3212.mc.core.GrimModule;
import grim3212.mc.core.util.VersionChecker;
import grim3212.mc.timecontrol.ItemTFRemote;
import grim3212.mc.timecontrol.ItemTRemote;
import grim3212.mc.timecontrol.ItemTSRemote;
import grim3212.mc.timecontrol.ItemTSSRemote;
import grim3212.mc.timecontrol.MatrixEventHandler;
import java.io.File;
import java.util.EnumSet;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="timecontrol", name="Time Control", version="V0.1 - 1.6.2", dependencies="required-after:grim3212core")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class TimeControl
extends GrimModule {
    @Mod.Instance(value="timecontrol")
    public static TimeControl instance;
    public static final String modID = "timecontrol";
    public static final String modName = "Time Control";
    public static final String modVersion = "V0.1 - 1.6.2";
    public static final String modURL = "http://grim3212.wikispaces.com/Time+Control";
    private static VersionChecker versionChecker;
    public static boolean canVersionCheck;
    public static boolean allowVersionCheckLocal;
    public static Item TRemote;
    public static Item TFRemote;
    public static Item TSRemote;
    public static Item TSSRemote;
    public int TRemoteID;
    public int TFRemoteID;
    public int TSRemoteID;
    public int TSSRemoteID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata data = event.getModMetadata();
        data.autogenerated = false;
        data.version = modVersion;
        data.name = modName;
        data.description = "Allows you to control time.";
        data.authorList.add("Grim3212");
        data.authorList.add("dude0367");
        data.url = modURL;
        data.credits = "Thanks to dude0367 for the original mod.";
        data.logoFile = "assets/grim3212-logo-texture/grimLogo.png";
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "/GrimsMods/" + this.getModID() + ".cfg"));
        try {
            config.load();
            this.TRemoteID = config.getItem("Time Control Remote ID", 9072).getInt();
            this.TFRemoteID = config.getItem("Fast-Motion Remote ID", 9073).getInt();
            this.TSRemoteID = config.getItem("Slow-Motion Remote ID", 9074).getInt();
            this.TSSRemoteID = config.getItem("Matrix Remote ID", 9075).getInt();
            allowVersionCheckLocal = config.get("general", "Allow Version Checking For Time Control", true).getBoolean(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Time Control has had a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.CLIENT);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (Grim3212Core.doUpdateCheck) {
            versionChecker = new VersionChecker(modName, modVersion, this.versionUrl, modURL);
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(1, 4);
        }
        MinecraftForge.EVENT_BUS.register((Object)new MatrixEventHandler());
        TRemote = new ItemTRemote(this.TRemoteID).func_77655_b("tremote").func_77637_a(Grim3212Core.tabsGrimItems);
        TFRemote = new ItemTFRemote(this.TFRemoteID).func_77655_b("tfremote").func_77637_a(Grim3212Core.tabsGrimItems);
        TSRemote = new ItemTSRemote(this.TSRemoteID).func_77655_b("tsremote").func_77637_a(Grim3212Core.tabsGrimItems);
        TSSRemote = new ItemTSSRemote(this.TSSRemoteID).func_77655_b("tmremote").func_77637_a(Grim3212Core.tabsGrimItems);
        GameRegistry.registerItem((Item)TRemote, (String)"timeControlRemote");
        LanguageRegistry.addName((Object)TRemote, (String)"Time Control Remote");
        GameRegistry.registerItem((Item)TFRemote, (String)"fastMotionRemote");
        LanguageRegistry.addName((Object)TFRemote, (String)"Fast-Motion Remote");
        GameRegistry.registerItem((Item)TSRemote, (String)"slowMotionRemote");
        LanguageRegistry.addName((Object)TSRemote, (String)"Slow-Motion Remote");
        GameRegistry.registerItem((Item)TSSRemote, (String)"matrixRemote");
        LanguageRegistry.addName((Object)TSSRemote, (String)"Matrix Remote");
        GameRegistry.addRecipe((ItemStack)new ItemStack(TRemote, 1), (Object[])new Object[]{"d#d", "#X#", "d#d", Character.valueOf('X'), Block.field_72034_aR, Character.valueOf('#'), Item.field_77717_p, Character.valueOf('d'), Item.field_77702_n});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSRemote, 1), (Object[])new Object[]{" s ", "srs", " s ", Character.valueOf('s'), Item.field_77768_aD, Character.valueOf('r'), TRemote});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TFRemote, 1), (Object[])new Object[]{" s ", "srs", " s ", Character.valueOf('s'), Item.field_77747_aY, Character.valueOf('r'), TRemote});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TSSRemote, 1), (Object[])new Object[]{" s ", "srs", " s ", Character.valueOf('s'), Item.field_77702_n, Character.valueOf('r'), TRemote});
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (FMLClientHandler.instance().getClient().field_71462_r == null && Grim3212Core.doUpdateCheck && canVersionCheck && allowVersionCheckLocal && !versionChecker.isCurrentVersionBySubStringAsFloatNewer(1, 4)) {
            for (String msg : versionChecker.getInGameMessage()) {
                FMLClientHandler.instance().getClient().field_71456_v.func_73827_b().func_73765_a(msg);
            }
            canVersionCheck = false;
        }
    }

    public String getModID() {
        return modID;
    }

    static {
        canVersionCheck = true;
    }
}

