/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common;

import com.thetorine.thirstmod.common.ExhaustionController;
import com.thetorine.thirstmod.common.PoisonController;
import com.thetorine.thirstmod.common.ThirstMod;
import com.thetorine.thirstmod.common.network.PacketSaveStats;
import com.thetorine.thirstmod.common.utils.DamageThirst;
import com.thetorine.thirstmod.common.utils.ThirstUtils;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;

public class ThirstStats {
    public EntityPlayer player;
    public int level;
    public float saturation;
    public float exhaustion;
    public int timer;
    public int movementSpeed;
    private DamageSource thirst = new DamageThirst("thirst");
    private PoisonController poisonCon = new PoisonController();
    private ExhaustionController exhauster = new ExhaustionController(this);

    public ThirstStats(EntityPlayer player) {
        this.player = player;
        this.level = 20;
        this.saturation = 4.0f;
        this.exhaustion = 0.0f;
        this.timer = 0;
        this.readData(player);
    }

    public void onTick(EntityPlayer player) {
        int difSet;
        int n = difSet = ThirstMod.CONFIG.PEACEFUL_ON ? 1 : this.getDiffilculty();
        if (this.exhaustion > 4.0f) {
            this.exhaustion = 0.0f;
            if (this.saturation > 0.0f) {
                this.saturation -= 1.0f;
            } else if (difSet > 0) {
                this.level = Math.max(this.level - 1, 0);
                if (this.level < 10 && this.level != 0) {
                    this.saturation += 1.0f;
                }
            }
        }
        if (this.level <= 0) {
            ++this.timer;
            if (this.timer > 200 && (player.func_110143_aJ() > 10.0f || difSet >= 3 || player.func_110143_aJ() > 1.0f && difSet >= 2)) {
                player.func_70097_a(this.thirst, 1.0f);
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 1));
                this.timer = 0;
            }
        }
        if (!(this.level >= 7 && ThirstMod.CONFIG.HEALTH_REGEN_OFF || difSet <= 0)) {
            FoodStats foodStats = player.func_71024_bL();
            Field field = FoodStats.class.getDeclaredFields()[3];
            field.setAccessible(true);
            try {
                field.set(foodStats, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.level <= 6) {
            player.func_70031_b(false);
        }
        this.poisonCon.onTick(player);
        this.exhauster.exhaustPlayer(player);
        this.writeData(player);
        ThirstMod.PACKETHANDLER.sendTo(new PacketSaveStats(this.level, this.saturation, this.poisonCon.isPoisoned()), (EntityPlayerMP)player);
    }

    public void readData(EntityPlayer player) {
        if (player != null) {
            NBTTagCompound oldnbt = player.getEntityData();
            NBTTagCompound nbt = oldnbt.func_74775_l("ThirstMod");
            if (nbt.func_74764_b("level")) {
                this.level = nbt.func_74762_e("level");
                this.exhaustion = nbt.func_74760_g("exhaustion");
                this.saturation = nbt.func_74760_g("saturation");
                this.timer = nbt.func_74762_e("timer");
                this.poisonCon.setPoisonedTo(nbt.func_74767_n("poisoned"));
                this.poisonCon.setPoisonTime(nbt.func_74762_e("poisonTime"));
            } else {
                this.setDefaults();
            }
            ThirstUtils.print("Successfully loaded stats: " + this);
        } else {
            ThirstUtils.print("SERIOUS ERROR IN readData/ThirstStats. Player could not be found!!");
        }
    }

    public void writeData(EntityPlayer player) {
        if (player != null) {
            NBTTagCompound oldNBT = player.getEntityData();
            NBTTagCompound nbt = oldNBT.func_74775_l("ThirstMod");
            if (!oldNBT.func_74764_b("ThirstMod")) {
                oldNBT.func_74782_a("ThirstMod", (NBTBase)nbt);
            }
            nbt.func_74768_a("level", this.level);
            nbt.func_74776_a("exhaustion", this.exhaustion);
            nbt.func_74776_a("saturation", this.saturation);
            nbt.func_74768_a("timer", this.timer);
            nbt.func_74757_a("poisoned", this.poisonCon.isPoisoned());
            nbt.func_74768_a("poisonTime", this.poisonCon.poisonTimeRemain());
        } else {
            ThirstUtils.print("SERIOUS ERROR IN writeData/ThirstStats. A NULL player detected!! Crash imminent!");
        }
    }

    public void setDefaults() {
        this.level = 20;
        this.exhaustion = 0.0f;
        this.saturation = 5.0f;
        this.timer = 0;
        this.getPoison().setPoisonedTo(false);
        this.getPoison().setPoisonTime(0);
    }

    public PoisonController getPoison() {
        return this.poisonCon;
    }

    public void addExhaustion(float par1) {
        this.exhaustion = Math.min(this.exhaustion + par1, 40.0f);
    }

    public void addStats(int par1, float par2) {
        this.level = Math.min(par1 + this.level, 20);
        this.saturation = Math.min(this.saturation + (float)par1 * par2 * 2.0f, (float)this.level);
    }

    public String toString() {
        return String.format("%s, Level = %d, Saturation = %f", this.player.getDisplayName(), this.level, Float.valueOf(this.saturation));
    }

    public int getDiffilculty() {
        switch (this.player.field_70170_p.field_73013_u) {
            case EASY: {
                return 1;
            }
            case NORMAL: {
                return 2;
            }
            case HARD: {
                return 3;
            }
            case PEACEFUL: {
                return 0;
            }
        }
        return 0;
    }
}

