/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common;

import com.thetorine.thirstmod.common.PlayerHandler;
import com.thetorine.thirstmod.common.ThirstMod;
import com.thetorine.thirstmod.common.ThirstStats;
import com.thetorine.thirstmod.common.network.PacketConfigs;
import com.thetorine.thirstmod.common.utils.ThirstUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ThirstEvent {
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ThirstMod.INSTANCE.onTickInGame();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ThirstMod.INSTANCE.onServerTick(event.player);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PlayerHandler.addPlayer(player.getDisplayName(), new PlayerHandler(player, new ThirstStats(player)));
            ThirstMod.PACKETHANDLER.sendTo(new PacketConfigs(), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent attack) {
        if (PlayerHandler.getPlayer(attack.entityPlayer.getDisplayName()) != null && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PlayerHandler.getPlayer(attack.entityPlayer.getDisplayName()).addExhaustion(0.5f);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent hurt) {
        if (hurt.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)hurt.entityLiving;
            PlayerHandler.getPlayer(player.getDisplayName()).addExhaustion(0.4f);
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && event.harvester != null && PlayerHandler.getPlayer(event.harvester.getDisplayName()) != null) {
            PlayerHandler.getPlayer(event.harvester.getDisplayName()).addExhaustion(0.03f);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            if (event.craftMatrix.func_70301_a(i) == null) continue;
            if (event.craftMatrix.func_70301_a(i).func_77977_a() == ThirstMod.ccFilter.func_77658_a() && event.craftMatrix.func_70301_a(i).func_77960_j() != 4) {
                ItemStack ccFilter = new ItemStack(ThirstMod.ccFilter);
                ccFilter.func_77972_a(event.craftMatrix.func_70301_a(i).func_77960_j() + 1, (EntityLivingBase)event.player);
                event.player.field_71071_by.func_70441_a(ccFilter);
            }
            if (event.craftMatrix.func_70301_a(i).func_77977_a() != ThirstMod.filter.func_77658_a()) continue;
            if (event.craftMatrix.func_70301_a(i).func_77960_j() != 4) {
                ItemStack Filter = new ItemStack(ThirstMod.filter);
                Filter.func_77972_a(event.craftMatrix.func_70301_a(i).func_77960_j() + 1, (EntityLivingBase)event.player);
                event.player.field_71071_by.func_70441_a(Filter);
                continue;
            }
            event.player.field_71071_by.func_70441_a(new ItemStack(ThirstMod.dFilter, 1));
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            World world = event.entityPlayer.field_70170_p;
            long sleepTime = 24000L - world.func_72820_D();
            int thirstInterval = 2500;
            int thirstLoss = Math.min(Math.max(Math.round((float)sleepTime / (float)thirstInterval), 0), 20);
            ThirstUtils.print(thirstLoss);
            if (PlayerHandler.getPlayer((String)event.entityPlayer.getDisplayName()).stats.level - thirstLoss <= 6) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("You are too thirsty to sleep!"));
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            } else {
                PlayerHandler.getPlayer((String)event.entityPlayer.getDisplayName()).stats.addStats(-thirstLoss, 0.0f);
            }
        }
    }
}

