/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common;

import com.thetorine.thirstmod.common.PlayerHandler;
import com.thetorine.thirstmod.common.ThirstMod;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public class PoisonController {
    private int poisonTimer;
    private int healthPoison;
    private boolean poisonPlayer = false;
    private boolean preloadedPoison = false;
    private boolean isPoisoned = false;
    private boolean setPoison = false;
    private float poisonID;
    public boolean drankPoisonStoper = false;
    private boolean addedPotion = false;

    public void onTick(EntityPlayer player) {
        if (this.shouldPoison()) {
            if (!this.preloadedPoison) {
                Random random = new Random();
                this.poisonID = random.nextFloat();
                this.preloadedPoison = true;
            }
            if (this.drankPoisonStoper) {
                this.poisonTimer = 0;
                this.isPoisoned = false;
                this.poisonPlayer = false;
            }
            this.addPoisonType(this.poisonID, player);
        }
        if (!this.setPoison) {
            this.setPoison = true;
        }
    }

    public void startPoison() {
        if (ThirstMod.CONFIG.POISON_ON) {
            this.preloadedPoison = false;
            this.poisonPlayer = true;
            this.drankPoisonStoper = false;
            this.addedPotion = false;
        }
    }

    private void addPoisonType(float f, EntityPlayer player) {
        if (f < 0.3f) {
            this.increaseExhaust(player);
        } else if (f > 0.3f && f < 0.75f) {
            this.potionEffects(player);
        } else if (f > 0.75f) {
            this.damageHealth(player);
        }
    }

    public void increaseExhaust(EntityPlayer player) {
        if (this.shouldPoison()) {
            ++this.poisonTimer;
            PlayerHandler.getPlayer(player.getDisplayName()).addExhaustion(0.06111111f);
            this.isPoisoned = true;
            if (this.poisonTimer > 360) {
                this.poisonTimer = 0;
                this.isPoisoned = false;
                this.poisonPlayer = false;
            }
        }
    }

    public void potionEffects(EntityPlayer player) {
        if (this.shouldPoison()) {
            ++this.poisonTimer;
            this.isPoisoned = true;
            if (!this.addedPotion) {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 680, 1));
                player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 680, 1));
                this.addedPotion = true;
            }
            if (this.poisonTimer > 680) {
                this.poisonTimer = 0;
                this.isPoisoned = false;
                this.poisonPlayer = false;
            }
        }
    }

    public void damageHealth(EntityPlayer player) {
        if (this.shouldPoison()) {
            ++this.poisonTimer;
            ++this.healthPoison;
            this.isPoisoned = true;
            if (this.healthPoison > 40) {
                player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                this.healthPoison = 0;
            }
            if (!this.addedPotion) {
                player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                this.addedPotion = true;
            }
            if (this.poisonTimer > 360) {
                this.poisonTimer = 0;
                this.isPoisoned = false;
                this.poisonPlayer = false;
            }
        }
    }

    public void startPoison(Random random, float f) {
        if (random.nextFloat() < f) {
            this.startPoison();
        }
    }

    public boolean shouldPoison() {
        return this.poisonPlayer;
    }

    public boolean isPoisoned() {
        return this.isPoisoned;
    }

    public int poisonTimeRemain() {
        if (this.poisonTimer > 0) {
            return this.poisonTimer;
        }
        return 0;
    }

    public void setPoisonedTo(boolean what) {
        this.poisonPlayer = what;
    }

    public void setPoisonTime(int what) {
        this.poisonTimer = what;
    }
}

