/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common.network;

import com.thetorine.thirstmod.common.PlayerHandler;
import com.thetorine.thirstmod.common.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSendStat
extends AbstractPacket {
    private int replenish;
    private float saturation;
    private float amountPoison;
    private boolean poison;

    public PacketSendStat() {
    }

    public PacketSendStat(int replenish, float saturation, boolean poison, float amountPoison) {
        this.replenish = replenish;
        this.saturation = saturation;
        this.poison = poison;
        this.amountPoison = amountPoison;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.replenish);
        buffer.writeFloat(this.saturation);
        buffer.writeBoolean(this.poison);
        buffer.writeFloat(this.amountPoison);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.replenish = buffer.readInt();
        this.saturation = buffer.readFloat();
        this.poison = buffer.readBoolean();
        this.amountPoison = buffer.readFloat();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        PlayerHandler.getPlayer(player.getDisplayName()).getStats().addStats(this.replenish, this.saturation);
        if (this.poison) {
            PlayerHandler.getPlayer(player.getDisplayName()).getStats().getPoison().startPoison(new Random(), this.amountPoison);
        }
    }
}

