/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common.utils;

import com.thetorine.thirstmod.common.utils.ThirstUtils;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHelper {
    private Configuration config = new Configuration(new File(ThirstUtils.getDir(), "/config/ThirstMod.txt"));
    public boolean POISON_ON = this.setupConfig();
    public boolean PEACEFUL_ON;
    public boolean METER_ON_LEFT;
    public boolean OLD_TEXTURES;
    public int MAX_STACK_SIZE;
    public boolean LIGHT_BLUE_COLOR;
    public boolean PERMIT_MOD_ON;
    public boolean HEALTH_REGEN_OFF;
    public boolean BETA_EXHAUSTION;
    public float NIGHT_RATE;
    public float IN_WATER_RATE;
    public float DESERT_RATE;
    public float WALKING_RATE;
    public float RUNNING_RATE;
    public float JUMP_RATE;
    public boolean WANT_MILK;
    public boolean WANT_CHOC_MILK;
    public boolean WANT_FILTERED_BUCKET;

    private boolean setupConfig() {
        this.config.load();
        this.POISON_ON = Boolean.parseBoolean(this.get("Poisoning On", "General", true, "Allows you to turn the poison off or on.").getString());
        this.PEACEFUL_ON = Boolean.parseBoolean(this.get("Peaceful On", "General", false, "Allows the thirst bar to dehydrate on peaceful mode.").getString());
        this.METER_ON_LEFT = Boolean.parseBoolean(this.get("Meter on leftside", "General", false, "Moves the ThirstBar to be above the health bar.").getString());
        this.OLD_TEXTURES = Boolean.parseBoolean(this.get("Old Meter Textures", "General", false).getString());
        this.MAX_STACK_SIZE = Integer.parseInt(this.get("Max Stack Size", "General", 10, "Max stack size of the built in drinks.").getString());
        this.LIGHT_BLUE_COLOR = Boolean.parseBoolean(this.get("Medievor Colours", "General", false, "Sets the color of the thirst bar to light blue.").getString());
        this.PERMIT_MOD_ON = Boolean.parseBoolean(this.get("Permit Mod Off", "General", true, "Server only function, if on allows the players to turn the mod off by pressing 'L'.").getString());
        this.HEALTH_REGEN_OFF = Boolean.parseBoolean(this.get("Health Regeneration On", "General", true, "Allows you too completely turn off health regeneration.").getString());
        this.BETA_EXHAUSTION = Boolean.parseBoolean(this.get("Beta Exhaustion System", "General", false, "Use at your own risk. Riddled with Bugs.").getString());
        this.config.addCustomCategoryComment("Exhaustion Rates", "Yes the values may be a little long. Don't worry it's fine.");
        this.NIGHT_RATE = Float.parseFloat(this.get("Night", "Exhaustion Rates", Float.valueOf(0.9f), "How fast the player is exhausted at night. 1 is daytime speed.").getString());
        this.DESERT_RATE = Float.parseFloat(this.get("Desert", "Exhaustion Rates", Float.valueOf(2.0f), "How fast the player is exhausted in the desert biome. 2 is 2x times faster.").getString());
        this.IN_WATER_RATE = Float.parseFloat(this.get("Water", "Exhaustion Rates", Float.valueOf(0.03f), "How fast the player is exhausted when swimming.").getString());
        this.WALKING_RATE = Float.parseFloat(this.get("Walking", "Exhaustion Rates", Float.valueOf(0.01f), "How fast the player is exhausted when walking.").getString());
        this.RUNNING_RATE = Float.parseFloat(this.get("Running", "Exhaustion Rates", Float.valueOf(0.099999994f), "How fast the player is exhausted when sprinting.").getString());
        this.JUMP_RATE = Float.parseFloat(this.get("Jumping", "Exhaustion Rates", Float.valueOf(0.03f), "How fast the player is exhausted when jumping. Sprint Jump is this multiplied by 2").getString());
        this.WANT_MILK = Boolean.parseBoolean(this.get("Milk", "Drinks", true).getString());
        this.WANT_CHOC_MILK = Boolean.parseBoolean(this.get("Chocolate Milk", "Drinks", true).getString());
        this.WANT_FILTERED_BUCKET = Boolean.parseBoolean(this.get("Fresh Bucket", "Drinks", true).getString());
        this.config.save();
        return this.POISON_ON;
    }

    public Property get(String key, String category, Object defaultValue) {
        if (defaultValue instanceof Integer) {
            return this.config.get(category, key, ((Integer)defaultValue).intValue());
        }
        if (defaultValue instanceof Boolean) {
            return this.config.get(category, key, ((Boolean)defaultValue).booleanValue());
        }
        return null;
    }

    public Property get(String key, String category, Object defaultValue, String comment) {
        if (defaultValue instanceof Integer) {
            return this.config.get(category, key, ((Integer)defaultValue).intValue(), comment);
        }
        if (defaultValue instanceof Boolean) {
            return this.config.get(category, key, ((Boolean)defaultValue).booleanValue(), comment);
        }
        if (defaultValue instanceof Float) {
            return this.config.get(category, key, (double)((Float)defaultValue).floatValue(), comment);
        }
        return null;
    }
}

