/*
 * Decompiled with CFR 0.152.
 */
package tektor.minecraft.talldoors.entities.drawbridge;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import tektor.minecraft.talldoors.TallDoorsBase;
import tektor.minecraft.talldoors.entities.FakeEntity;
import tektor.minecraft.talldoors.entities.drawbridge.DrawbridgeMachine;
import tektor.minecraft.talldoors.items.Connector;

public class DrawbridgeBase
extends Entity {
    public double rotation = 0.0;
    public double lon = 7.0;
    public double width2 = 4.0;
    public double height2 = 0.125;
    public int orientation;
    boolean up;
    boolean active;
    public DrawbridgeMachine machine;
    double mX;
    double mY;
    double mZ;
    FakeEntity[] boundEnt;
    int[] places;
    private boolean first;

    public DrawbridgeBase(World par1World) {
        super(par1World);
        this.func_70105_a(7.0f, 0.125f);
        this.field_70158_ak = true;
        this.up = false;
        this.active = false;
        this.first = false;
        this.mX = 0.0;
        this.mY = 0.0;
        this.mZ = 0.0;
    }

    public void setPars(int width3, int depth3) {
        this.width2 = width3;
        this.lon = depth3;
        this.makeFakeOnGround(width3, depth3);
        this.field_70180_af.func_75692_b(22, (Object)((int)this.lon));
        this.field_70180_af.func_75692_b(23, (Object)((int)this.width2));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void makeFakeOnGround(int width3, int depth3) {
        int newW;
        int newD;
        int offD;
        int newW2;
        int firstDepth;
        int firstWidth;
        int i;
        int off;
        this.boundEnt = new FakeEntity[(depth3 / 16 + 2) * (width3 / 16 + 2)];
        this.places = new int[(depth3 / 16 + 2) * (width3 / 16 + 2) * 3];
        int workWidth = width3;
        int workDepth = depth3;
        int k = 0;
        int inChunkX = this.field_70165_t < 0.0 ? (int)(this.field_70165_t % 16.0) + 16 : (int)(this.field_70165_t % 16.0);
        int inChunkZ = this.field_70161_v < 0.0 ? (int)(this.field_70161_v % 16.0) + 16 : (int)(this.field_70161_v % 16.0);
        if (this.orientation == 0) {
            int firstX = Math.min(16 - inChunkX, workWidth);
            int firstZ = Math.min(16 - inChunkZ, workDepth);
            int i2 = 0;
            this.boundEnt[i2] = new FakeEntity(this.field_70170_p);
            this.boundEnt[i2].setWidthDepth(firstX, firstZ);
            this.boundEnt[i2].setOrientation(this.orientation);
            this.boundEnt[i2].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i2]);
            this.places[k] = (int)this.boundEnt[i2].field_70165_t;
            this.places[++k] = (int)this.boundEnt[i2].field_70163_u;
            this.places[++k] = (int)this.boundEnt[i2].field_70161_v;
            ++k;
            ++i2;
            workWidth -= firstX;
            workDepth -= firstZ;
            off = firstX;
            while (workWidth != 0) {
                this.boundEnt[i2] = new FakeEntity(this.field_70170_p);
                int newX = Math.min(16, workWidth);
                this.boundEnt[i2].setOrientation(this.orientation);
                this.boundEnt[i2].setWidthDepth(newX, firstZ);
                this.boundEnt[i2].func_70107_b(this.field_70165_t + (double)off, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i2]);
                workWidth -= newX;
                off += newX;
                this.places[k] = (int)this.boundEnt[i2].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i2].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i2].field_70161_v;
                ++k;
                ++i2;
            }
            int offZ = firstZ;
            while (workDepth != 0) {
                workWidth = width3;
                int newZ = Math.min(16, workDepth);
                off = firstX;
                this.boundEnt[i2] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i2].setWidthDepth(firstX, newZ);
                this.boundEnt[i2].setOrientation(this.orientation);
                this.boundEnt[i2].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + (double)offZ);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i2]);
                this.places[k] = (int)this.boundEnt[i2].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i2].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i2].field_70161_v;
                ++k;
                ++i2;
                workWidth -= firstX;
                while (workWidth != 0) {
                    this.boundEnt[i2] = new FakeEntity(this.field_70170_p);
                    int newX = Math.min(16, workWidth);
                    this.boundEnt[i2].setOrientation(this.orientation);
                    this.boundEnt[i2].setWidthDepth(newX, newZ);
                    this.boundEnt[i2].func_70107_b(this.field_70165_t + (double)off, this.field_70163_u, this.field_70161_v + (double)offZ);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i2]);
                    workWidth -= newX;
                    off += newX;
                    this.places[k] = (int)this.boundEnt[i2].field_70165_t;
                    this.places[++k] = (int)this.boundEnt[i2].field_70163_u;
                    this.places[++k] = (int)this.boundEnt[i2].field_70161_v;
                    ++k;
                    ++i2;
                }
                workDepth -= newZ;
                offZ += newZ;
            }
        } else if (this.orientation == 1) {
            i = 0;
            firstWidth = Math.min(16 - inChunkZ, workWidth);
            firstDepth = Math.min(inChunkX + 1, workDepth);
            this.boundEnt[i] = new FakeEntity(this.field_70170_p);
            this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
            this.boundEnt[i].setOrientation(this.orientation);
            this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
            this.places[k] = (int)this.boundEnt[i].field_70165_t;
            this.places[++k] = (int)this.boundEnt[i].field_70163_u;
            this.places[++k] = (int)this.boundEnt[i].field_70161_v;
            ++k;
            ++i;
            workWidth -= firstWidth;
            workDepth -= firstDepth;
            off = firstWidth;
            while (workWidth != 0) {
                newW2 = Math.min(16, workWidth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(newW2, firstDepth);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + (double)off);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off += newW2;
                workWidth -= newW2;
            }
            offD = firstDepth;
            while (workDepth != 0) {
                newD = Math.min(16, workDepth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(firstWidth, newD);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t - (double)offD, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off = firstWidth;
                for (workWidth = width3 - firstWidth; workWidth != 0; workWidth -= newW) {
                    newW = Math.min(16, workWidth);
                    this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                    this.boundEnt[i].setWidthDepth(newW, newD);
                    this.boundEnt[i].setOrientation(this.orientation);
                    this.boundEnt[i].func_70107_b(this.field_70165_t - (double)offD, this.field_70163_u, this.field_70161_v + (double)off);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                    this.places[k] = (int)this.boundEnt[i].field_70165_t;
                    this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                    this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                    ++k;
                    ++i;
                    off += newW;
                }
                offD += newD;
                workDepth -= newD;
            }
        } else if (this.orientation == 2) {
            i = 0;
            firstWidth = Math.min(inChunkX + 1, workWidth);
            firstDepth = Math.min(inChunkZ + 1, workDepth);
            this.boundEnt[i] = new FakeEntity(this.field_70170_p);
            this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
            this.boundEnt[i].setOrientation(this.orientation);
            this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
            this.places[k] = (int)this.boundEnt[i].field_70165_t;
            this.places[++k] = (int)this.boundEnt[i].field_70163_u;
            this.places[++k] = (int)this.boundEnt[i].field_70161_v;
            ++k;
            ++i;
            workWidth -= firstWidth;
            workDepth -= firstDepth;
            off = firstWidth;
            while (workWidth != 0) {
                newW2 = Math.min(16, workWidth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(newW2, firstDepth);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t - (double)off, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off += newW2;
                workWidth -= newW2;
            }
            offD = firstDepth;
            while (workDepth != 0) {
                newD = Math.min(16, workDepth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(firstWidth, newD);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v - (double)offD);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off = firstWidth;
                for (workWidth = width3 - firstWidth; workWidth != 0; workWidth -= newW) {
                    newW = Math.min(16, workWidth);
                    this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                    this.boundEnt[i].setWidthDepth(newW, newD);
                    this.boundEnt[i].setOrientation(this.orientation);
                    this.boundEnt[i].func_70107_b(this.field_70165_t - (double)off, this.field_70163_u, this.field_70161_v - (double)offD);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                    this.places[k] = (int)this.boundEnt[i].field_70165_t;
                    this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                    this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                    ++k;
                    ++i;
                    off += newW;
                }
                offD += newD;
                workDepth -= newD;
            }
        } else if (this.orientation == 3) {
            i = 0;
            firstWidth = Math.min(inChunkZ + 1, workWidth);
            firstDepth = Math.min(16 - inChunkX, workDepth);
            this.boundEnt[i] = new FakeEntity(this.field_70170_p);
            this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
            this.boundEnt[i].setOrientation(this.orientation);
            this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
            this.places[k] = (int)this.boundEnt[i].field_70165_t;
            this.places[++k] = (int)this.boundEnt[i].field_70163_u;
            this.places[++k] = (int)this.boundEnt[i].field_70161_v;
            ++k;
            ++i;
            workWidth -= firstWidth;
            workDepth -= firstDepth;
            off = firstWidth;
            while (workWidth != 0) {
                newW2 = Math.min(16, workWidth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(newW2, firstDepth);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v - (double)off);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off += newW2;
                workWidth -= newW2;
            }
            offD = firstDepth;
            while (workDepth != 0) {
                newD = Math.min(16, workDepth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(firstWidth, newD);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].func_70107_b(this.field_70165_t + (double)offD, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                this.places[k] = (int)this.boundEnt[i].field_70165_t;
                this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                ++k;
                ++i;
                off = firstWidth;
                for (workWidth = width3 - firstWidth; workWidth != 0; workWidth -= newW) {
                    newW = Math.min(16, workWidth);
                    this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                    this.boundEnt[i].setWidthDepth(newW, newD);
                    this.boundEnt[i].setOrientation(this.orientation);
                    this.boundEnt[i].func_70107_b(this.field_70165_t + (double)offD, this.field_70163_u, this.field_70161_v - (double)off);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                    this.places[k] = (int)this.boundEnt[i].field_70165_t;
                    this.places[++k] = (int)this.boundEnt[i].field_70163_u;
                    this.places[++k] = (int)this.boundEnt[i].field_70161_v;
                    ++k;
                    ++i;
                    off += newW;
                }
                offD += newD;
                workDepth -= newD;
            }
        }
        for (FakeEntity ent : this.boundEnt) {
            if (ent == null) continue;
            ent.master = this;
        }
    }

    public void makeFakeStanding(int width3, int depth3) {
        block5: {
            int inChunkZ;
            int workDepth;
            int workWidth;
            block7: {
                int inChunkX;
                block6: {
                    block4: {
                        this.boundEnt = new FakeEntity[(depth3 / 16 + 2) * (width3 / 16 + 2)];
                        workWidth = width3;
                        workDepth = depth3;
                        inChunkX = this.field_70165_t < 0.0 ? (int)(this.field_70165_t % 16.0) + 16 : (int)(this.field_70165_t % 16.0);
                        inChunkZ = this.field_70161_v < 0.0 ? (int)(this.field_70161_v % 16.0) + 16 : (int)(this.field_70161_v % 16.0);
                        if (this.orientation != 0) break block4;
                        int firstX = Math.min(16 - inChunkX, workWidth);
                        int firstZ = workDepth;
                        int i = 0;
                        this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                        this.boundEnt[i].setWidthDepth(firstX, firstZ);
                        this.boundEnt[i].setUpActive(true, false);
                        this.boundEnt[i].setOrientation(this.orientation);
                        this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                        ++i;
                        workWidth -= firstX;
                        int off = firstX;
                        while (workWidth != 0) {
                            this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                            int newX = Math.min(16, workWidth);
                            this.boundEnt[i].setOrientation(this.orientation);
                            this.boundEnt[i].setWidthDepth(newX, firstZ);
                            this.boundEnt[i].setUpActive(true, false);
                            this.boundEnt[i].func_70107_b(this.field_70165_t + (double)off, this.field_70163_u, this.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                            workWidth -= newX;
                            off += newX;
                            ++i;
                        }
                        break block5;
                    }
                    if (this.orientation != 1) break block6;
                    int i = 0;
                    int firstWidth = Math.min(16 - inChunkZ, workWidth);
                    int firstDepth = workDepth;
                    this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                    this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
                    this.boundEnt[i].setOrientation(this.orientation);
                    this.boundEnt[i].setUpActive(true, false);
                    this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                    ++i;
                    workWidth -= firstWidth;
                    int off = firstWidth;
                    while (workWidth != 0) {
                        int newW = Math.min(16, workWidth);
                        this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                        this.boundEnt[i].setWidthDepth(newW, firstDepth);
                        this.boundEnt[i].setOrientation(this.orientation);
                        this.boundEnt[i].setUpActive(true, false);
                        this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + (double)off);
                        this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                        ++i;
                        off += newW;
                        workWidth -= newW;
                    }
                    break block5;
                }
                if (this.orientation != 2) break block7;
                int i = 0;
                int firstWidth = Math.min(inChunkX + 1, workWidth);
                int firstDepth = workDepth;
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].setUpActive(true, false);
                this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                ++i;
                workWidth -= firstWidth;
                int off = firstWidth;
                while (workWidth != 0) {
                    int newW = Math.min(16, workWidth);
                    this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                    this.boundEnt[i].setWidthDepth(newW, firstDepth);
                    this.boundEnt[i].setOrientation(this.orientation);
                    this.boundEnt[i].setUpActive(true, false);
                    this.boundEnt[i].func_70107_b(this.field_70165_t - (double)off, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                    ++i;
                    off += newW;
                    workWidth -= newW;
                }
                break block5;
            }
            if (this.orientation != 3) break block5;
            int i = 0;
            int firstWidth = Math.min(inChunkZ + 1, workWidth);
            int firstDepth = workDepth;
            this.boundEnt[i] = new FakeEntity(this.field_70170_p);
            this.boundEnt[i].setWidthDepth(firstWidth, firstDepth);
            this.boundEnt[i].setOrientation(this.orientation);
            this.boundEnt[i].setUpActive(true, false);
            this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
            ++i;
            workWidth -= firstWidth;
            workDepth -= firstDepth;
            int off = firstWidth;
            while (workWidth != 0) {
                int newW = Math.min(16, workWidth);
                this.boundEnt[i] = new FakeEntity(this.field_70170_p);
                this.boundEnt[i].setWidthDepth(newW, firstDepth);
                this.boundEnt[i].setOrientation(this.orientation);
                this.boundEnt[i].setUpActive(true, false);
                this.boundEnt[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v - (double)off);
                this.field_70170_p.func_72838_d((Entity)this.boundEnt[i]);
                ++i;
                off += newW;
                workWidth -= newW;
            }
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.orientation = this.field_70180_af.func_75679_c(28);
            this.rotation = Double.parseDouble(this.field_70180_af.func_75681_e(29));
            this.up = this.field_70180_af.func_75679_c(20) == 1;
            this.active = this.field_70180_af.func_75679_c(21) == 1;
            this.mX = this.field_70180_af.func_75679_c(25);
            this.mY = this.field_70180_af.func_75679_c(26);
            this.mZ = this.field_70180_af.func_75679_c(27);
            this.lon = this.field_70180_af.func_75679_c(22);
            this.width2 = this.field_70180_af.func_75679_c(23);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.up && this.active) {
                if (this.rotation < 90.0) {
                    this.rotation += 0.4;
                    this.field_70180_af.func_75692_b(29, (Object)("" + this.rotation));
                } else {
                    this.active = false;
                    this.field_70180_af.func_75692_b(21, (Object)0);
                }
            } else if (!this.up && this.active) {
                if (this.rotation > 0.0) {
                    this.rotation -= 0.4;
                    this.field_70180_af.func_75692_b(29, (Object)("" + this.rotation));
                } else {
                    this.active = false;
                    this.field_70180_af.func_75692_b(21, (Object)0);
                }
            } else if (!this.up && !this.active && this.first && this.boundEnt != null) {
                for (FakeEntity ent : this.boundEnt) {
                    if (ent == null) continue;
                    ent.func_70106_y();
                }
                this.makeFakeOnGround((int)this.width2, (int)this.lon);
                this.first = false;
            }
        }
        if (this.machine == null) {
            List list = this.field_70170_p.func_72872_a(DrawbridgeMachine.class, AxisAlignedBB.func_72330_a((double)(this.mX - 1.0), (double)(this.mY - 1.0), (double)(this.mZ - 1.0), (double)(this.mX + 1.0), (double)(this.mY + 1.0), (double)(this.mZ + 1.0)));
            DrawbridgeMachine drawbridgeMachine = this.machine = list.isEmpty() ? null : (DrawbridgeMachine)((Object)list.get(0));
        }
        if (this.boundEnt == null) {
            this.boundEnt = new FakeEntity[1];
        }
        if (this.boundEnt != null && this.boundEnt[0] == null && this.places != null) {
            HashSet set = new HashSet();
            for (int i = 0; i < this.places.length; i += 3) {
                set.addAll(this.field_70170_p.func_72872_a(FakeEntity.class, AxisAlignedBB.func_72330_a((double)(this.places[i] - 1), (double)(this.places[i + 1] - 1), (double)(this.places[i + 2] - 1), (double)(this.places[i] + 1), (double)(this.places[i + 1] + 1), (double)(this.places[i + 2] + 1))));
            }
            this.boundEnt = new FakeEntity[((int)(this.lon / 16.0) + 1) * ((int)(this.width2 / 16.0) + 1)];
            for (FakeEntity ent : this.boundEnt = set.toArray(new FakeEntity[0])) {
                if (ent == null) continue;
                ent.master = this;
            }
        }
        this.setBoundsAt(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)"0");
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.height2 = nbt.func_74769_h("height");
        this.rotation = nbt.func_74769_h("rotation");
        this.field_70180_af.func_75692_b(29, (Object)("" + this.rotation));
        this.width2 = nbt.func_74769_h("width");
        this.lon = nbt.func_74769_h("lon");
        this.field_70180_af.func_75692_b(22, (Object)((int)this.lon));
        this.field_70180_af.func_75692_b(23, (Object)((int)this.width2));
        this.setOrientation(nbt.func_74762_e("orientation"));
        List list = this.field_70170_p.func_72872_a(DrawbridgeMachine.class, AxisAlignedBB.func_72330_a((double)(nbt.func_74769_h("mX") - 1.0), (double)(nbt.func_74769_h("mY") - 1.0), (double)(nbt.func_74769_h("mZ") - 1.0), (double)(nbt.func_74769_h("mx") + 1.0), (double)(nbt.func_74769_h("mY") + 1.0), (double)(nbt.func_74769_h("mZ") + 1.0)));
        this.machine = list.isEmpty() ? null : (DrawbridgeMachine)((Object)list.get(0));
        this.places = nbt.func_74759_k("places");
        this.mX = nbt.func_74769_h("mX");
        this.mY = nbt.func_74769_h("mY");
        this.mZ = nbt.func_74769_h("mZ");
        this.field_70180_af.func_75692_b(25, (Object)((int)this.mX));
        this.field_70180_af.func_75692_b(26, (Object)((int)this.mY));
        this.field_70180_af.func_75692_b(27, (Object)((int)this.mZ));
        this.active = nbt.func_74767_n("active");
        this.up = nbt.func_74767_n("up");
        if (this.active) {
            this.field_70180_af.func_75692_b(21, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(21, (Object)0);
        }
        if (this.up) {
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("height", this.height2);
        nbt.func_74780_a("rotation", this.rotation);
        nbt.func_74780_a("width", this.width2);
        nbt.func_74780_a("lon", this.lon);
        nbt.func_74768_a("orientation", this.orientation);
        if (this.machine != null) {
            nbt.func_74780_a("mX", this.machine.field_70165_t);
            nbt.func_74780_a("mY", this.machine.field_70163_u);
            nbt.func_74780_a("mZ", this.machine.field_70161_v);
        }
        nbt.func_74757_a("up", this.up);
        nbt.func_74757_a("active", this.active);
        nbt.func_74783_a("places", this.places);
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return this.field_70121_D;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void setOrientation(int var24) {
        this.orientation = var24;
        this.field_70180_af.func_75692_b(28, (Object)var24);
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70107_b(double par1, double par3, double par5) {
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        this.setBoundsAt(par1, par3, par5);
    }

    public void setBoundsAt(double par1, double par3, double par5) {
        double f1 = this.height2;
        if (!this.active && !this.up) {
            if (this.orientation == 0) {
                this.field_70121_D.func_72324_b(par1, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5, par1 + this.width2, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + this.lon);
            } else if (this.orientation == 1) {
                this.field_70121_D.func_72328_c(AxisAlignedBB.func_72330_a((double)(par1 - this.lon + 1.0), (double)(par3 - (double)this.field_70129_M + (double)this.field_70139_V), (double)par5, (double)(par1 + 1.0), (double)(par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1), (double)(par5 + this.width2)));
            } else if (this.orientation == 2) {
                this.field_70121_D.func_72324_b(par1 - this.width2 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - this.lon + 1.0, par1 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + 1.0);
            } else if (this.orientation == 3) {
                this.field_70121_D.func_72324_b(par1, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - this.width2 + 1.0, par1 + this.lon, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + 1.0);
            }
        } else {
            f1 = (float)this.lon;
            if (this.orientation == 0) {
                this.field_70121_D.func_72324_b(par1, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5, par1 + this.width2, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + 0.125);
            } else if (this.orientation == 1) {
                this.field_70121_D.func_72324_b(par1 - 0.125 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5, par1 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + this.width2);
            } else if (this.orientation == 2) {
                this.field_70121_D.func_72324_b(par1 - this.width2 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - 0.125 + 1.0, par1 + 1.0, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + 1.0);
            } else if (this.orientation == 3) {
                this.field_70121_D.func_72324_b(par1, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - this.width2 + 1.0, par1 + 0.125, par3 - (double)this.field_70129_M + (double)this.field_70139_V + f1, par5 + 1.0);
            }
        }
    }

    public void activate() {
        if (!this.up) {
            this.up = true;
            this.active = true;
            for (FakeEntity ent : this.boundEnt) {
                if (ent == null) continue;
                ent.func_70106_y();
            }
            this.makeFakeStanding((int)this.width2, (int)this.lon);
            this.field_70180_af.func_75692_b(21, (Object)1);
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.up = false;
            this.active = true;
            this.first = true;
            this.field_70180_af.func_75692_b(21, (Object)1);
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    public int func_82329_d() {
        return 64;
    }

    public int func_82330_g() {
        return 2;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b().equals(TallDoorsBase.connector)) {
                ((Connector)player.field_71071_by.func_70448_g().func_77973_b()).base = this;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b().equals(TallDoorsBase.destructionHammer)) {
                this.func_110128_b((Entity)player);
                player.field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        } else if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b().equals(TallDoorsBase.destructionHammer)) {
            player.func_71038_i();
        }
        return true;
    }

    public void setMachinePos(double posX, double posY, double posZ) {
        this.mX = posX;
        this.field_70180_af.func_75692_b(25, (Object)((int)this.mX));
        this.mY = posY;
        this.field_70180_af.func_75692_b(26, (Object)((int)this.mY));
        this.mZ = posZ;
        this.field_70180_af.func_75692_b(27, (Object)((int)this.mZ));
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public void func_110128_b(Entity par1Entity) {
        if (par1Entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)par1Entity;
            this.func_70106_y();
            for (FakeEntity ent : this.boundEnt) {
                if (ent == null) continue;
                ent.func_70106_y();
            }
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        ItemStack drop = new ItemStack(TallDoorsBase.drawbridge, 1, 0);
        drop.field_77990_d = new NBTTagCompound();
        drop.field_77990_d.func_74768_a("width", (int)this.width2);
        drop.field_77990_d.func_74768_a("depth", (int)this.lon);
        this.func_70099_a(drop, 0.0f);
    }
}

