/*
 * Decompiled with CFR 0.152.
 */
package tektor.minecraft.talldoors;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tektor.minecraft.talldoors.TallDoorsCommonProxy;
import tektor.minecraft.talldoors.blocks.DrawbridgeWorkbench;
import tektor.minecraft.talldoors.blocks.KeyRedstoneLock;
import tektor.minecraft.talldoors.blocks.MosaicBlock;
import tektor.minecraft.talldoors.blocks.MosaicGlass;
import tektor.minecraft.talldoors.doorworkshop.DoorModule;
import tektor.minecraft.talldoors.doorworkshop.DoorPartRegistry;
import tektor.minecraft.talldoors.doorworkshop.ModularDoorPlacer;
import tektor.minecraft.talldoors.doorworkshop.blocks.DoorWorkshop;
import tektor.minecraft.talldoors.doorworkshop.blocks.ModuleAssembler;
import tektor.minecraft.talldoors.doorworkshop.doorparttypes.DoubleHorizontalBalkPartType;
import tektor.minecraft.talldoors.doorworkshop.doorparttypes.HorizontalBalkPartType;
import tektor.minecraft.talldoors.doorworkshop.doorparttypes.NullPartType;
import tektor.minecraft.talldoors.doorworkshop.doorparttypes.PlainDoorPartType;
import tektor.minecraft.talldoors.doorworkshop.entity.DoorBase;
import tektor.minecraft.talldoors.doorworkshop.entity.DoorModuleWorkbenchTileEntity;
import tektor.minecraft.talldoors.doorworkshop.entity.ModuleAssemblerTileEntity;
import tektor.minecraft.talldoors.doorworkshop.entity.doorparts.DoubleHorizontalBalkPartEntity;
import tektor.minecraft.talldoors.doorworkshop.entity.doorparts.HorizontalBalkPartEntity;
import tektor.minecraft.talldoors.doorworkshop.entity.doorparts.NullPartEntity;
import tektor.minecraft.talldoors.doorworkshop.entity.doorparts.PlainDoorPartEntity;
import tektor.minecraft.talldoors.entities.FakeEntity;
import tektor.minecraft.talldoors.entities.FenceGate1;
import tektor.minecraft.talldoors.entities.doors_width2.DarkMetalEntranceDoor1;
import tektor.minecraft.talldoors.entities.doors_width2.DarkMetalEntranceDoor2;
import tektor.minecraft.talldoors.entities.doors_width2.DarkMetalEntranceDoor3;
import tektor.minecraft.talldoors.entities.doors_width2.EntranceDoor1;
import tektor.minecraft.talldoors.entities.doors_width2.EntranceDoor2;
import tektor.minecraft.talldoors.entities.doors_width2.EntranceDoor3;
import tektor.minecraft.talldoors.entities.doors_width2.MetalEntranceDoor1;
import tektor.minecraft.talldoors.entities.doors_width2.MetalEntranceDoor2;
import tektor.minecraft.talldoors.entities.doors_width2.MetalEntranceDoor3;
import tektor.minecraft.talldoors.entities.drawbridge.DrawbridgeBase;
import tektor.minecraft.talldoors.entities.drawbridge.DrawbridgeMachine;
import tektor.minecraft.talldoors.entities.drawbridge.EntityConnector;
import tektor.minecraft.talldoors.entities.tileentities.DrawbridgeWorkbenchTileEntity;
import tektor.minecraft.talldoors.entities.tileentities.KeyRedstoneLockTileEntity;
import tektor.minecraft.talldoors.entities.tileentities.MosaicGlassTileEntity;
import tektor.minecraft.talldoors.entities.tileentities.MosaicTileEntity;
import tektor.minecraft.talldoors.entities.trapdoors.TrapDoor;
import tektor.minecraft.talldoors.entities.workbenches.KeyMaker;
import tektor.minecraft.talldoors.gui.TallDoorsGuiHandler;
import tektor.minecraft.talldoors.items.Connector;
import tektor.minecraft.talldoors.items.DestructionHammer;
import tektor.minecraft.talldoors.items.DoorPlacer;
import tektor.minecraft.talldoors.items.DrawbridgePlacer;
import tektor.minecraft.talldoors.items.DrawbridgeWorkbenchItemBlock;
import tektor.minecraft.talldoors.items.Key;
import tektor.minecraft.talldoors.items.KeyMakerPlacer;
import tektor.minecraft.talldoors.items.MosaicTool;
import tektor.minecraft.talldoors.items.PermanentMosaicTool;
import tektor.minecraft.talldoors.items.TrapDoorsPlacer;
import tektor.minecraft.talldoors.packet.PacketPipeline;
import tektor.minecraft.talldoors.services.MosaicIconRegistry;

@Mod(modid="TallDoors", name="TallDoors", version="0.4.1")
public class TallDoorsBase {
    @Mod.Instance(value="TallDoors")
    public static TallDoorsBase instance;
    @SidedProxy(clientSide="tektor.minecraft.talldoors.client.TallDoorsClientProxy", serverSide="tektor.minecraft.talldoors.TallDoorsCommonProxy")
    public static TallDoorsCommonProxy proxy;
    public static final PacketPipeline packetPipeline;
    public static CreativeTabs tabTallDoors;
    public static Item doorPlacer;
    public static Item drawbridge;
    public static Item connector;
    public static Item destructionHammer;
    public static Item key;
    public static Item mosaicTool;
    public static Item keyMakerPlacer;
    public static Item trapDoor;
    public static Item mosaicTool2;
    public static Item modularDoorPlacer;
    public static Item doorModule;
    public static Block drawbridgeWorkbench;
    public static Block keyRedstoneLock;
    public static Block mosaic;
    public static Block mosaicGlass;
    public static Block doorWorkshop;
    public static Block doorAssembly;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File jarName = null;
        ArrayList<String> results = new ArrayList<String>();
        try {
            jarName = event.getSourceFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ZipFile zf = new ZipFile(jarName.getAbsoluteFile());
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                String[] a;
                ZipEntry ze = e.nextElement();
                if (!ze.getName().contains("assets/talldoors/textures/blocks/mosaic/") || (a = ze.getName().split("assets/talldoors/textures/blocks/mosaic/")).length <= 1 || !a[1].contains(".png")) continue;
                results.add(a[1]);
            }
            zf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MosaicIconRegistry.mosaicsIntern = results;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.initializeIDs();
        this.registerItems();
        this.registerBlocks();
        this.registerEntities();
        this.registerRecipes();
        this.registerDoorParts();
        proxy.registerRenderers();
        this.registerTileEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new TallDoorsGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        DoorPartRegistry.initialize();
    }

    @Mod.EventHandler
    public void initialise(FMLInitializationEvent evt) {
        packetPipeline.initalise();
    }

    @Mod.EventHandler
    public void postInitialise(FMLPostInitializationEvent evt) {
        packetPipeline.postInitialise();
    }

    private void initializeIDs() {
        doorPlacer = new DoorPlacer();
        connector = new Connector();
        drawbridge = new DrawbridgePlacer();
        destructionHammer = new DestructionHammer();
        key = new Key();
        mosaicTool = new MosaicTool();
        keyMakerPlacer = new KeyMakerPlacer();
        trapDoor = new TrapDoorsPlacer();
        mosaicTool2 = new PermanentMosaicTool();
        modularDoorPlacer = new ModularDoorPlacer();
        drawbridgeWorkbench = new DrawbridgeWorkbench();
        keyRedstoneLock = new KeyRedstoneLock();
        mosaic = new MosaicBlock();
        mosaicGlass = new MosaicGlass();
        doorWorkshop = new DoorWorkshop();
        doorAssembly = new ModuleAssembler();
        doorModule = new DoorModule();
    }

    private void registerDoorParts() {
        DoorPartRegistry.registerDoorPart("plain", new PlainDoorPartType());
        DoorPartRegistry.registerDoorPart("horizontal", new HorizontalBalkPartType());
        DoorPartRegistry.registerDoorPart("double_horizontal", new DoubleHorizontalBalkPartType());
        DoorPartRegistry.registerDoorPart("empty", new NullPartType());
    }

    private void registerBlocks() {
        GameRegistry.registerBlock((Block)drawbridgeWorkbench, DrawbridgeWorkbenchItemBlock.class, (String)"drawbridgeWorkbench");
        GameRegistry.registerBlock((Block)keyRedstoneLock, (String)"keyRedstoneLock");
        GameRegistry.registerBlock((Block)mosaic, (String)"mosaic");
        GameRegistry.registerBlock((Block)mosaicGlass, (String)"mosaicGlass");
        GameRegistry.registerBlock((Block)doorWorkshop, (String)"Door Workshop");
        GameRegistry.registerBlock((Block)doorAssembly, (String)"Door Assembly");
    }

    private void registerItems() {
        GameRegistry.registerItem((Item)doorPlacer, (String)"doorplacer");
        GameRegistry.registerItem((Item)connector, (String)"connector");
        GameRegistry.registerItem((Item)drawbridge, (String)"drawbridge");
        GameRegistry.registerItem((Item)destructionHammer, (String)"destructionHammer");
        GameRegistry.registerItem((Item)key, (String)"key");
        GameRegistry.registerItem((Item)mosaicTool, (String)"mosaicTool");
        GameRegistry.registerItem((Item)keyMakerPlacer, (String)"keyMakerPlacer");
        GameRegistry.registerItem((Item)trapDoor, (String)"trapDoorPlacer");
        GameRegistry.registerItem((Item)modularDoorPlacer, (String)"modularDoorPlacer");
        GameRegistry.registerItem((Item)doorModule, (String)"doorModule");
        LanguageRegistry.addName((Object)mosaicTool, (String)"Mosaic Tool");
        LanguageRegistry.addName((Object)mosaicTool2, (String)"Permanent Mosaic Tool");
    }

    private void registerEntities() {
        EntityRegistry.registerGlobalEntityID(EntranceDoor1.class, (String)"EntranceDoor1", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntranceDoor1.class, (String)"EntranceDoor1", (int)0, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntranceDoor2.class, (String)"EntranceDoor2", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntranceDoor2.class, (String)"EntranceDoor2", (int)1, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntranceDoor3.class, (String)"EntranceDoor3", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntranceDoor3.class, (String)"EntranceDoor3", (int)2, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(FenceGate1.class, (String)"FenceGate1", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(FenceGate1.class, (String)"FenceGate1", (int)3, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntityConnector.class, (String)"EntityConnector", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityConnector.class, (String)"EntityConnector", (int)4, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(MetalEntranceDoor1.class, (String)"MetalEntranceDoor1", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(MetalEntranceDoor1.class, (String)"MetalEntranceDoor1", (int)5, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DarkMetalEntranceDoor1.class, (String)"DarkMetalEntranceDoor1", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DarkMetalEntranceDoor1.class, (String)"DarkMetalEntranceDoor1", (int)6, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DrawbridgeBase.class, (String)"DrawbridgeBase", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DrawbridgeBase.class, (String)"DrawbridgeBase", (int)7, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DrawbridgeMachine.class, (String)"DrawbridgeMachine", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DrawbridgeMachine.class, (String)"DrawbridgeMachine", (int)8, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DarkMetalEntranceDoor2.class, (String)"DarkMetalEntranceDoor2", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DarkMetalEntranceDoor2.class, (String)"DarkMetalEntranceDoor2", (int)9, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DarkMetalEntranceDoor3.class, (String)"DarkMetalEntranceDoor3", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DarkMetalEntranceDoor3.class, (String)"DarkMetalEntranceDoor3", (int)10, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(MetalEntranceDoor2.class, (String)"MetalEntranceDoor2", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(MetalEntranceDoor2.class, (String)"MetalEntranceDoor2", (int)11, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(MetalEntranceDoor3.class, (String)"MetalEntranceDoor3", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(MetalEntranceDoor3.class, (String)"MetalEntranceDoor3", (int)12, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(FakeEntity.class, (String)"FakeEntity", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(FakeEntity.class, (String)"FakeEntity", (int)13, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(KeyMaker.class, (String)"KeyMaker", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(KeyMaker.class, (String)"KeyMaker", (int)14, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(TrapDoor.class, (String)"TrapDoor", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(TrapDoor.class, (String)"TrapDoor", (int)15, (Object)instance, (int)120, (int)5, (boolean)true);
        EntityRegistry.registerGlobalEntityID(DoorBase.class, (String)"DoorBase", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(DoorBase.class, (String)"DoorBase", (int)16, (Object)instance, (int)128, (int)5, (boolean)true);
        this.registerDoorPartEntities();
    }

    private void registerDoorPartEntities() {
        EntityRegistry.registerModEntity(PlainDoorPartEntity.class, (String)"PlainDoorPartEntity", (int)17, (Object)instance, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(HorizontalBalkPartEntity.class, (String)"HorizontalDoorPartEntity", (int)18, (Object)instance, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(DoubleHorizontalBalkPartEntity.class, (String)"DoubleHorizontalBalkPartEntity", (int)19, (Object)instance, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(NullPartEntity.class, (String)"NullPartEntity", (int)20, (Object)instance, (int)128, (int)5, (boolean)true);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(DrawbridgeWorkbenchTileEntity.class, (String)"Drawbridge_Workbench");
        GameRegistry.registerTileEntity(MosaicTileEntity.class, (String)"Mosaic");
        GameRegistry.registerTileEntity(MosaicGlassTileEntity.class, (String)"Mosaic Glass");
        GameRegistry.registerTileEntity(KeyRedstoneLockTileEntity.class, (String)"keylock");
        GameRegistry.registerTileEntity(DoorModuleWorkbenchTileEntity.class, (String)"doorWorkshop");
        GameRegistry.registerTileEntity(ModuleAssemblerTileEntity.class, (String)"doorAssembly");
    }

    private void registerRecipes() {
        ItemStack door = new ItemStack(Items.field_151135_aq, 1, 0);
        new ItemStack(Blocks.field_150415_aT, 1, 0);
        ItemStack fenceGate = new ItemStack(Blocks.field_150396_be, 1);
        ItemStack wood = new ItemStack(Blocks.field_150344_f, 1);
        ItemStack wood2 = new ItemStack(Blocks.field_150364_r, 1);
        ItemStack cobble = new ItemStack(Blocks.field_150347_e, 1);
        ItemStack sand = new ItemStack(Blocks.field_150354_m, 1);
        ItemStack iron = new ItemStack(Items.field_151042_j, 1);
        ItemStack string = new ItemStack(Items.field_151007_F, 1);
        ItemStack stick = new ItemStack(Items.field_151055_y, 1);
        ItemStack redstone = new ItemStack(Items.field_151137_ax, 1);
        ItemStack glass = new ItemStack(Blocks.field_150359_w, 1);
        ItemStack glow = new ItemStack(Items.field_151114_aO, 1);
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(mosaicTool, 1, 0), (Object[])new Object[]{"Y Y", "YXY", "X X", Character.valueOf('X'), wood, Character.valueOf('Y'), iron});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(mosaicTool2, 1, 0), (Object[])new Object[]{"Y Y", "YZY", "X X", Character.valueOf('X'), wood, Character.valueOf('Y'), iron, Character.valueOf('Z'), wood2});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(mosaic, 1, 0), (Object[])new Object[]{"YXY", "XYX", "YXY", Character.valueOf('X'), cobble, Character.valueOf('Y'), sand});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(mosaicGlass, 8, 0), (Object[])new Object[]{"YXY", "XYX", "YXY", Character.valueOf('X'), glow, Character.valueOf('Y'), glass});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(keyMakerPlacer, 1, 0), (Object[])new Object[]{"XYX", "XYX", "X X", Character.valueOf('X'), wood, Character.valueOf('Y'), iron});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(keyRedstoneLock, 1, 0), (Object[])new Object[]{"XYX", "XZX", "XYX", Character.valueOf('X'), wood, Character.valueOf('Y'), iron, Character.valueOf('Z'), redstone});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(destructionHammer, 1, 0), (Object[])new Object[]{"YYY", "YXY", " X ", Character.valueOf('X'), stick, Character.valueOf('Y'), iron});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(drawbridgeWorkbench, 1, 0), (Object[])new Object[]{"YYY", "XXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), cobble});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(drawbridgeWorkbench, 1, 1), (Object[])new Object[]{"ZYZ", "XXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), cobble, Character.valueOf('Z'), redstone});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorWorkshop, 1, 0), (Object[])new Object[]{"ZYZ", "XXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), cobble, Character.valueOf('Z'), iron});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorAssembly, 1, 0), (Object[])new Object[]{"ZYZ", "ZXZ", "ZXZ", Character.valueOf('X'), wood, Character.valueOf('Y'), cobble, Character.valueOf('Z'), iron});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(connector, 1, 0), (Object[])new Object[]{" X ", "XYX", " X ", Character.valueOf('X'), string, Character.valueOf('Y'), cobble});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 10), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 11), (Object[])new Object[]{"XXX", "XXX", "YXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 12), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 10)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 13), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 11)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 14), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 12)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 15), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), cobble, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 13)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 8), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), iron, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 9), (Object[])new Object[]{"XXX", "XXX", "YXX", Character.valueOf('X'), iron, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 16), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), iron, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 8)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 17), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), iron, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 9)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 18), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), iron, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 16)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 19), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), iron, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 17)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 0), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 1), (Object[])new Object[]{"XXX", "XXX", "YXX", Character.valueOf('X'), wood, Character.valueOf('Y'), door});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 2), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 3), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 4), (Object[])new Object[]{"XXX", "XXY", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 2)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 5), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), new ItemStack(doorPlacer, 1, 3)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 6), (Object[])new Object[]{"XXX", "YXX", "XXX", Character.valueOf('X'), wood, Character.valueOf('Y'), fenceGate});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(doorPlacer, 1, 7), (Object[])new Object[]{"XXX", "XXX", "YXX", Character.valueOf('X'), wood, Character.valueOf('Y'), fenceGate});
    }

    static {
        packetPipeline = new PacketPipeline();
        tabTallDoors = new CreativeTabs("tallDoors"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return modularDoorPlacer;
            }
        };
    }
}

