/*
 * Decompiled with CFR 0.152.
 */
package sync.common.tileentity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sync.common.Sync;
import sync.common.shell.ShellHandler;
import sync.common.tileentity.TileEntityDualVertical;

public class TileEntityShellStorage
extends TileEntityDualVertical {
    public boolean occupied = false;
    public boolean syncing = false;
    public boolean hasPower = true;
    public EntityPlayer playerInstance = null;
    public String prevPlayerName = "";
    public int occupationTime = 0;

    @Override
    public void func_145845_h() {
        if (this.resync && this.field_145850_b.field_72995_K && !this.playerName.equalsIgnoreCase("") && !this.prevPlayerName.equals(this.playerName) && this.syncing) {
            this.playerInstance = TileEntityShellStorage.createPlayer(this.field_145850_b, this.playerName);
            this.prevPlayerName = this.playerName;
            if (this.playerNBT.func_74764_b("Inventory")) {
                this.playerInstance.func_70020_e(this.playerNBT);
            }
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        if (this.top && this.pair != null) {
            TileEntityShellStorage ss = (TileEntityShellStorage)this.pair;
            this.occupied = ss.occupied;
            this.syncing = ss.syncing;
            this.hasPower = ss.hasPower;
            this.playerInstance = ss.playerInstance;
            this.prevPlayerName = ss.prevPlayerName;
            this.occupationTime = ss.occupationTime;
        }
        super.func_145845_h();
        if (!this.top && this.occupied && !this.field_145850_b.field_72995_K && !this.syncing) {
            EntityPlayer player = this.field_145850_b.func_72924_a(this.playerName);
            if (player != null) {
                double d3 = player.field_70165_t - ((double)this.field_145851_c + 0.5);
                double d4 = player.field_70121_D.field_72338_b - (double)this.field_145848_d;
                double d5 = player.field_70161_v - ((double)this.field_145849_e + 0.5);
                double dist = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                if (dist > 0.75) {
                    this.occupied = false;
                    this.playerName = "";
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
            } else {
                this.occupied = false;
                this.playerName = "";
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
        if (this.syncing && this.occupationTime > 0) {
            --this.occupationTime;
            if (this.occupationTime == 0) {
                if (this.vacating) {
                    if (!this.field_145850_b.field_72995_K && !this.top) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                        ShellHandler.removeShell(this.playerName, this);
                    }
                    this.vacating = false;
                    this.occupied = false;
                    this.syncing = false;
                    this.playerName = "";
                    this.prevPlayerName = "";
                    this.playerNBT = new NBTTagCompound();
                } else if (!this.field_145850_b.field_72995_K && this.occupied && this.isPowered() && !this.playerName.equalsIgnoreCase("") && !this.top && !ShellHandler.isShellAlreadyRegistered(this)) {
                    ShellHandler.addShell(this.playerName, this, true);
                    this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && !this.top) {
            if (!this.isPowered() && ShellHandler.isShellAlreadyRegistered(this)) {
                ShellHandler.removeShell(this.playerName, this);
                this.hasPower = false;
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (this.playerNBT.func_74764_b("Inventory") && this.isPowered() && !this.playerName.equalsIgnoreCase("") && !ShellHandler.isShellAlreadyRegistered(this)) {
                ShellHandler.addShell(this.playerName, this, true);
                this.hasPower = true;
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
            if (this.powerAmount() >= (float)Sync.config.getInt("shellStoragePowerRequirement") && !this.hasPower) {
                this.hasPower = true;
                ShellHandler.addShell(this.playerName, this, true);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.powerAmount() < (float)Sync.config.getInt("shellStoragePowerRequirement") && this.hasPower) {
                this.hasPower = false;
                ShellHandler.removeShell(this.playerName, this);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.powReceived = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer createPlayer(World world, String playerName) {
        return new EntityOtherPlayerMP(world, new GameProfile("SyncClientDummyPlayer", playerName));
    }

    public boolean isPowered() {
        if (this.top && this.pair != null) {
            return ((TileEntityShellStorage)this.pair).isPowered();
        }
        return (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) && this.hasPower;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("occupied", this.occupied);
        tag.func_74757_a("syncing", this.canSavePlayer <= 0 && this.syncing);
        tag.func_74757_a("hasPower", this.hasPower);
        tag.func_74768_a("occupationTime", this.occupationTime);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.occupied = tag.func_74767_n("occupied");
        this.syncing = tag.func_74767_n("syncing");
        this.hasPower = tag.func_74767_n("hasPower");
        this.occupationTime = tag.func_74762_e("occupationTime");
        this.resync = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.syncing = false;
        this.playerInstance = null;
        this.vacating = false;
        this.occupied = false;
        this.occupationTime = 0;
        this.prevPlayerName = "";
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (Sync.config.getInt("shellStoragePowerRequirement") == 0) {
            return 0;
        }
        int pow = maxReceive;
        if (pow > Sync.config.getInt("shellStoragePowerRequirement")) {
            pow = Sync.config.getInt("shellStoragePowerRequirement");
        }
        if (!simulate) {
            this.powReceived = (int)((float)this.powReceived + (float)pow * (float)Sync.config.getInt("ratioRF"));
        }
        return pow;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.top;
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }
}

