/*
 * Decompiled with CFR 0.152.
 */
package sync.common.core;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import sync.common.Sync;
import sync.common.shell.ShellHandler;
import sync.common.tileentity.TileEntityDualVertical;

public class ChunkLoadHandler
implements ForgeChunkManager.LoadingCallback {
    public static final HashMap<TileEntityDualVertical, ForgeChunkManager.Ticket> shellTickets = new HashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket == null) continue;
            TileEntity te = world.func_147438_o(ticket.getModData().func_74762_e("shellX"), ticket.getModData().func_74762_e("shellY"), ticket.getModData().func_74762_e("shellZ"));
            if (te instanceof TileEntityDualVertical) {
                TileEntityDualVertical dv = (TileEntityDualVertical)te;
                ForgeChunkManager.Ticket ticket1 = shellTickets.get((Object)dv);
                if (ticket1 != null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket1);
                }
                shellTickets.put(dv, ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(dv.field_145851_c >> 4, dv.field_145849_e >> 4));
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public static void removeShellAsChunkloader(TileEntityDualVertical dv) {
        ForgeChunkManager.Ticket ticket = shellTickets.get((Object)dv);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        shellTickets.remove((Object)dv);
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(dv.getPlayerName());
        if (player != null) {
            ShellHandler.updatePlayerOfShellRemoval((EntityPlayer)player, dv);
        }
    }

    public static void addShellAsChunkloader(TileEntityDualVertical dv) {
        ChunkCoordIntPair chunkCoordIntPair;
        if (dv != null && !ChunkLoadHandler.isAlreadyChunkLoaded(chunkCoordIntPair = new ChunkCoordIntPair(dv.field_145851_c >> 4, dv.field_145849_e >> 4), dv.func_145831_w().field_73011_w.field_76574_g)) {
            ForgeChunkManager.Ticket ticket = shellTickets.get((Object)dv);
            if (ticket == null) {
                ticket = ForgeChunkManager.requestTicket((Object)Sync.instance, (World)dv.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            if (ticket != null) {
                ticket.getModData().func_74768_a("shellX", dv.field_145851_c);
                ticket.getModData().func_74768_a("shellY", dv.field_145848_d);
                ticket.getModData().func_74768_a("shellZ", dv.field_145849_e);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkCoordIntPair);
                if (Sync.config.getInt("allowChunkLoading") == 0) {
                    try {
                        LinkedHashSet requestedChunks = (LinkedHashSet)ObfuscationReflectionHelper.getPrivateValue(ForgeChunkManager.Ticket.class, (Object)ticket, (String[])new String[]{"requestedChunks"});
                        requestedChunks.clear();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            shellTickets.put(dv, ticket);
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(dv.getPlayerName());
            if (player != null) {
                ShellHandler.updatePlayerOfShells((EntityPlayer)player, null, true);
            }
        }
    }

    public static boolean isAlreadyChunkLoaded(TileEntityDualVertical dualVertical) {
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(dualVertical.field_145851_c >> 4, dualVertical.field_145849_e >> 4);
        return shellTickets.containsKey((Object)dualVertical) || ChunkLoadHandler.isAlreadyChunkLoaded(chunkCoordIntPair, dualVertical.func_145831_w().field_73011_w.field_76574_g);
    }

    public static boolean isAlreadyChunkLoaded(ChunkCoordIntPair chunkCoordIntPair, int dimID) {
        for (Map.Entry<TileEntityDualVertical, ForgeChunkManager.Ticket> set : shellTickets.entrySet()) {
            ImmutableSet loadedChunks;
            if (set == null || set.getValue() == null || (loadedChunks = set.getValue().getChunkList()) == null || set.getValue().world.field_73011_w.field_76574_g != dimID) continue;
            for (Object obj : loadedChunks) {
                ChunkCoordIntPair theChunks = (ChunkCoordIntPair)obj;
                if (!theChunks.equals((Object)chunkCoordIntPair)) continue;
                return true;
            }
        }
        return false;
    }
}

