/*
 * Decompiled with CFR 0.152.
 */
package com.twinklez.soi.core.entity;

import com.twinklez.soi.core.interfaces.IEntityHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;

public class SOIEntityRegistry {
    private static int startEntityId = -1;
    private static int startVehicleType = -1;
    private static final int[] occupiedVehicleType = new int[]{1, 10, 11, 12, 50, 51, 60, 61, 62, 63, 64, 65, 70, 72, 73, 75, 90};
    public Map<Class<? extends Entity>, Integer> classToTypeMap = new HashMap<Class<? extends Entity>, Integer>();
    public Map<Integer, Class<? extends Entity>> typeToClassMap = new HashMap<Integer, Class<? extends Entity>>();
    private static List<IEntityHandler> entityHandlers = new ArrayList<IEntityHandler>();

    public void addEntity(Class<? extends Entity> entityClass) {
        this.addEntity(entityClass, SOIEntityRegistry.getUniqueEntityId());
    }

    @Deprecated
    public void addEntity(Class<? extends Entity> entityClass, int entityId) {
        EntityRegistry.registerModEntity(entityClass, (String)entityClass.getSimpleName(), (int)entityId, (Object)entityId, (int)entityId, (int)entityId, (boolean)false);
    }

    @Deprecated
    public void addEntityWithTracking(Class<? extends Entity> entityClass, int distance, int updateFrequency, boolean tracking) {
        this.addEntityWithTracking(entityClass, SOIEntityRegistry.getUniqueVehicleType(), distance, updateFrequency, tracking);
    }

    @Deprecated
    public void addEntityWithTracking(Class<? extends Entity> entityClass, int type, int distance, int updateFrequency, boolean tracking) {
    }

    @Deprecated
    public Entity spawnEntity(int type, World worldClient, double x, double y, double z) {
        Class<? extends Entity> entityClass = this.typeToClassMap.get(type);
        if (entityClass != null) {
            try {
                return entityClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldClient, x, y, z);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, "Make sure " + entityClass + "constructor is public", e);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, "Make sure " + entityClass + "constructor has the arguments World.class, double, double,double", e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, "Missing constructor (World.class,double,double,double) in " + entityClass, e);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Deprecated
    public int getTypeByEntity(Class<? extends Entity> entityClass) {
        return this.classToTypeMap.get(entityClass);
    }

    @Deprecated
    public int getTypeByEntity(String entityName) {
        try {
            return this.classToTypeMap.get(Class.forName(entityName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public Class<? extends Entity> getEntityByName(int type) {
        return this.typeToClassMap.get(type);
    }

    @Deprecated
    public static void addEntityHandling(IEntityHandler handlerEntity) {
        entityHandlers.add(handlerEntity);
    }

    @Deprecated
    public static int getUniqueEntityId() {
        do {
            if (++startEntityId <= 255) continue;
            Logger.getLogger("Minecraft").log(Level.WARNING, "Entity Id is greater than 255: " + startEntityId);
        } while (EntityList.func_75617_a((int)startEntityId) != null);
        return startEntityId;
    }

    @Deprecated
    public static int getUniqueVehicleType() {
        do {
            if (++startVehicleType <= 255) continue;
            Logger.getLogger("Minecraft").log(Level.WARNING, "Vehicle type is greater than 255: " + startVehicleType);
        } while (Arrays.binarySearch(occupiedVehicleType, startVehicleType) > -1);
        return startVehicleType;
    }
}

