/*
 * Decompiled with CFR 0.152.
 */
package streak.common.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import streak.common.Streak;
import streak.common.core.LocationInfo;
import streak.common.entity.EntityStreak;

public class TickHandlerClient {
    public float renderTick;
    public WorldClient worldInstance;
    public HashMap<String, ArrayList<LocationInfo>> playerLoc = new HashMap();
    public HashMap<String, EntityStreak> streaks = new HashMap();

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTick = event.renderTickTime;
            for (Map.Entry<String, EntityStreak> e : this.streaks.entrySet()) {
                if (e.getValue().parent == null) continue;
                EntityStreak streak = e.getValue();
                this.updatePos(streak, streak.parent);
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.worldInstance != world) {
                this.worldInstance = world;
                this.streaks.clear();
            }
            Iterator<Map.Entry<String, EntityStreak>> ite = this.streaks.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, EntityStreak> e = ite.next();
                if (e.getValue().field_70170_p.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g && world.func_72820_D() - e.getValue().lastUpdate <= 10L) continue;
                e.getValue().func_70106_y();
                ite.remove();
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityStreak hat = this.streaks.get(player.func_70005_c_());
            if (hat == null || hat.field_70128_L) {
                if (player.func_70005_c_().equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                    for (Map.Entry<String, EntityStreak> e : this.streaks.entrySet()) {
                        e.getValue().func_70106_y();
                    }
                }
                hat = new EntityStreak((World)world, (EntityLivingBase)player);
                this.streaks.put(player.func_70005_c_(), hat);
                world.func_72838_d((Entity)hat);
            }
            ArrayList<LocationInfo> loc = this.getPlayerLocationInfo(player);
            LocationInfo oldest = loc.get(0);
            loc.remove(0);
            loc.add(oldest);
            oldest.update(player);
            LocationInfo newest = loc.get(loc.size() - 2);
            double distX = newest.posX - oldest.posX;
            double distZ = newest.posZ - oldest.posZ;
            oldest.startU = newest.startU + Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
            while (oldest.startU > 1.0) {
                oldest.startU -= 1.0;
            }
        }
    }

    public ArrayList<LocationInfo> getPlayerLocationInfo(EntityPlayer player) {
        ArrayList<LocationInfo> loc = this.playerLoc.get(player.func_70005_c_());
        if (loc == null) {
            loc = new ArrayList();
            this.playerLoc.put(player.func_70005_c_(), loc);
        }
        int time = Streak.config.getInt("streakTime");
        if (loc.size() < time) {
            for (int i = 0; i < time - loc.size(); ++i) {
                loc.add(0, new LocationInfo(player));
            }
        } else if (loc.size() > time) {
            loc.remove(0);
        }
        return loc;
    }

    public void updatePos(EntityStreak streak, EntityLivingBase parent) {
        streak.field_70142_S = streak.parent.field_70142_S;
        streak.field_70137_T = streak.parent.field_70137_T;
        streak.field_70136_U = streak.parent.field_70136_U;
        streak.field_70169_q = streak.parent.field_70169_q;
        streak.field_70167_r = streak.parent.field_70167_r;
        streak.field_70166_s = streak.parent.field_70166_s;
        streak.field_70165_t = streak.parent.field_70165_t;
        streak.field_70163_u = streak.parent.field_70163_u;
        streak.field_70161_v = streak.parent.field_70161_v;
    }
}

