/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.waila;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.BlockCableCamouflages;
import vswe.stevesfactory.blocks.BlockCableCluster;
import vswe.stevesfactory.blocks.BlockCableOutput;
import vswe.stevesfactory.blocks.ClusterRegistry;
import vswe.stevesfactory.blocks.TileEntityCamouflage;
import vswe.stevesfactory.blocks.TileEntityCluster;
import vswe.stevesfactory.blocks.TileEntityOutput;

public class Provider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityCamouflage camouflage;
        TileEntity te = accessor.getTileEntity();
        if (te != null && !this.isShiftDown() && (camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e)) != null) {
            Block block;
            int id = camouflage.getId(accessor.getPosition().field_72310_e);
            int meta = camouflage.getMeta(accessor.getPosition().field_72310_e);
            if (id != 0 && (block = Block.func_149729_e((int)id)) != null) {
                return new ItemStack(block, 1, block.func_149692_a(meta));
            }
        }
        return new ItemStack(accessor.getBlock(), 1, accessor.getBlock().func_149692_a(accessor.getMetadata()));
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        if (itemStack != null && itemStack.func_77973_b() == accessor.getStack().func_77973_b() && (te = accessor.getTileEntity()) != null) {
            if (te instanceof TileEntityCluster) {
                TileEntityCluster cluster = (TileEntityCluster)te;
                for (byte type : cluster.getTypes()) {
                    currenttip.add(ClusterRegistry.getRegistryList().get(type).getItemStack().func_82833_r());
                }
            } else if (te instanceof TileEntityOutput) {
                TileEntityOutput emitter = (TileEntityOutput)te;
                if (this.isShiftDown()) {
                    for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                        currenttip.add(this.getEmitterSide(emitter, i, true));
                    }
                } else {
                    currenttip.add(this.getEmitterSide(emitter, accessor.getPosition().field_72310_e, false));
                }
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    private String getEmitterSide(TileEntityOutput emitter, int side, boolean full) {
        String str = (emitter.hasStrongSignalAtSide(side) ? Localization.STRONG_POWER.toString() : Localization.WEAK_POWER.toString()) + ": " + emitter.getStrengthFromSide(side) + " ";
        if (full) {
            str = (Object)((Object)Localization.getForgeDirectionLocalization(side)) + " " + str;
        }
        return str;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider instance = new Provider();
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCableCluster.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCableOutput.class);
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockCableCluster.class);
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockCableCamouflages.class);
    }
}

