/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.nbt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class NBTNode {
    private static final int END_TAG = 0;
    private static final int BYTE_TAG = 1;
    private static final int SHORT_TAG = 2;
    private static final int INT_TAG = 3;
    private static final int LONG_TAG = 4;
    private static final int FLOAT_TAG = 5;
    private static final int DOUBLE_TAG = 6;
    private static final int BYTE_ARRAY_TAG = 7;
    private static final int STRING_TAG = 8;
    private static final int LIST_TAG = 9;
    private static final int COMPOUND_TAG = 10;
    private static final int INT_ARRAY_TAG = 11;
    private NBTBase tag;
    private List<NBTNode> nodes;
    private boolean open;
    private int cachedLine;
    private int cachedDepth;
    private String value;

    public NBTNode(NBTBase tag) {
        this.tag = tag;
        this.open = true;
    }

    public void updatePosition() {
        this.updatePosition(0, -1);
    }

    private int updatePosition(int line, int depth) {
        this.cachedLine = line++;
        this.cachedDepth = depth;
        if (depth >= 0) {
            // empty if block
        }
        if (this.open && this.nodes != null) {
            for (NBTNode node : this.nodes) {
                line = node.updatePosition(line, depth + 1);
            }
        }
        return line;
    }

    public List<NBTNode> getNodes() {
        return this.nodes;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getCachedLine() {
        return this.cachedLine;
    }

    public int getCachedDepth() {
        return this.cachedDepth;
    }

    public void setCachedDepth(int cachedDepth) {
        this.cachedDepth = cachedDepth;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        if (this.tag == null) {
            return "Element";
        }
        String name = NBTBase.func_150283_g((int)this.tag.func_74732_a());
        if (name.equals("UNKNOWN")) {
            return "Node";
        }
        return name;
    }

    public static NBTNode generateNodes(NBTTagCompound compound) {
        NBTNode node = NBTNode.generateNodesFromTag(compound);
        node.updatePosition();
        return node;
    }

    private static NBTNode generateNodesFromTag(NBTTagCompound compound) {
        Object obj;
        NBTBase tag;
        NBTNode node = new NBTNode((NBTBase)compound);
        node.nodes = new ArrayList<NBTNode>();
        Iterator i$ = compound.func_150296_c().iterator();
        while (i$.hasNext() && (tag = (NBTBase)(obj = i$.next())).func_74732_a() != 0) {
            node.nodes.add(NBTNode.createElementNode(tag));
        }
        return node;
    }

    private static NBTNode generateNodesFromList(NBTTagList compound) {
        NBTNode node = new NBTNode((NBTBase)compound);
        node.nodes = new ArrayList<NBTNode>();
        for (int i = 0; i < compound.func_74745_c(); ++i) {
            node.nodes.add(NBTNode.createElementNode((NBTBase)compound.func_150305_b(i)));
        }
        return node;
    }

    private static NBTNode generateNodesFromArray(NBTTagByteArray compound) {
        NBTNode node = new NBTNode((NBTBase)compound);
        node.nodes = new ArrayList<NBTNode>();
        for (byte b : compound.func_150292_c()) {
            NBTNode child = new NBTNode(null);
            child.value = String.valueOf(b);
            node.nodes.add(child);
        }
        return node;
    }

    private static NBTNode generateNodesFromArray(NBTTagIntArray compound) {
        NBTNode node = new NBTNode((NBTBase)compound);
        node.nodes = new ArrayList<NBTNode>();
        for (int n : compound.func_150302_c()) {
            NBTNode child = new NBTNode(null);
            child.value = String.valueOf(n);
            node.nodes.add(child);
        }
        return node;
    }

    private static NBTNode createElementNode(NBTBase tag) {
        switch (tag.func_74732_a()) {
            case 10: {
                return NBTNode.generateNodesFromTag((NBTTagCompound)tag);
            }
            case 9: {
                return NBTNode.generateNodesFromList((NBTTagList)tag);
            }
            case 7: {
                return NBTNode.generateNodesFromArray((NBTTagByteArray)tag);
            }
            case 11: {
                return NBTNode.generateNodesFromArray((NBTTagIntArray)tag);
            }
        }
        NBTNode node = new NBTNode(tag);
        node.value = tag.toString() + " [type = " + tag.func_74732_a() + "]";
        return node;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }
}

