/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.components.ScrollController;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.components.TextBoxNumberList;
import vswe.stevesfactory.components.Variable;
import vswe.stevesfactory.interfaces.GuiManager;

public class ContainerFilter {
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_FILTER_Y = 5;
    private static final int CHECK_BOX_FILTER_SPACING = 12;
    private static final int CHECK_BOX_FILTER_INVERT_Y = 55;
    private static final int TEXT_BOX_Y_OFFSET = -2;
    private static final int RADIO_BUTTON_SPACING = 15;
    private static final int CHECK_BOX_POSITION_Y = 5;
    private static final int CHECK_BOX_POSITION_SPACING = 20;
    private static final int TEXT_BOX_POSITION_X_1 = 25;
    private static final int TEXT_BOX_POSITION_X_2 = 50;
    private static final int CHECK_BOX_POSITION_INVERT_X = 80;
    private static final int CHECK_BOX_DISTANCE_Y = 5;
    private static final int CHECK_BOX_DISTANCE_SPACING = 30;
    private static final int DISTANCE_SECOND_LINE = 14;
    private static final int TEXT_BOX_DISTANCE_X_1 = 15;
    private static final int TEXT_BOX_DISTANCE_X_2 = 40;
    private static final int CHECK_BOX_DISTANCE_INVERT_X = 65;
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 5;
    private static final int CHECK_BOX_SELECTION_Y = 40;
    private static final int RADIO_BUTTON_SPACING_X = 60;
    private static final int RADIO_BUTTON_Y_VARIABLE = 2;
    private static final int CHECK_BOX_INVERT_VARIABLE_Y = 12;
    public CheckBoxList checkBoxes = new CheckBoxList();
    public TextBoxNumberList textBoxes;
    public RadioButtonList radioButtonsSelection;
    public ScrollController<Variable> scrollControllerVariable;
    public List<Integer> filterVariableSelection = new ArrayList<Integer>();
    public RadioButtonList radioButtonVariable;
    private CheckBox invertFilterMatch;
    private CheckBox[] useSubFilter;
    private CheckBox[] useRange;
    TextBoxPage[] lowerRange;
    TextBoxPage[] higherRange;
    private CheckBox[] invertRange;
    private CheckBox variableInvert;
    public ComponentMenuContainer currentMenu;

    public ContainerFilter() {
        ComponentMenuContainer.Page[] subFilterPages = new ComponentMenuContainer.Page[]{ComponentMenuContainer.Page.POSITION, ComponentMenuContainer.Page.DISTANCE, ComponentMenuContainer.Page.SELECTION, ComponentMenuContainer.Page.VARIABLE};
        Localization[] subFilterLabels = new Localization[]{Localization.FILTER_POSITION_LABEL, Localization.FILTER_DISTANCE_LABEL, Localization.FILTER_SELECTION_LABEL, Localization.FILTER_VARIABLE_LABEL};
        this.useSubFilter = new CheckBox[subFilterLabels.length];
        for (int i = 0; i < subFilterPages.length; ++i) {
            this.useSubFilter[i] = new CheckBoxPage(subFilterLabels[i], ComponentMenuContainer.Page.FILTER, 5, 5 + 12 * i);
            this.checkBoxes.addCheckBox(this.useSubFilter[i]);
        }
        this.invertFilterMatch = new CheckBoxPage(Localization.INVERT, ComponentMenuContainer.Page.FILTER, 5, 55);
        this.checkBoxes.addCheckBox(this.invertFilterMatch);
        this.useRange = new CheckBox[5];
        this.lowerRange = new TextBoxPage[this.useRange.length];
        this.higherRange = new TextBoxPage[this.useRange.length];
        this.invertRange = new CheckBox[this.useRange.length];
        this.textBoxes = new TextBoxNumberList();
        Localization[] xyz = new Localization[]{Localization.X, Localization.Y, Localization.Z};
        for (int i = 0; i < xyz.length; ++i) {
            int y = 5 + 20 * i;
            this.useRange[i] = new CheckBoxPage(xyz[i], ComponentMenuContainer.Page.POSITION, 5, y);
            this.checkBoxes.addCheckBox(this.useRange[i]);
            this.lowerRange[i] = new TextBoxPage(ComponentMenuContainer.Page.POSITION, 25, y + -2, true, -128);
            this.textBoxes.addTextBox(this.lowerRange[i]);
            this.higherRange[i] = new TextBoxPage(ComponentMenuContainer.Page.POSITION, 50, y + -2, true, 128);
            this.textBoxes.addTextBox(this.higherRange[i]);
            this.invertRange[i] = new CheckBoxPage(Localization.INVERT, ComponentMenuContainer.Page.POSITION, 80, y);
            this.checkBoxes.addCheckBox(this.invertRange[i]);
        }
        Localization[] distance = new Localization[]{Localization.CABLE_DISTANCE, Localization.DISTANCE};
        for (int i = 0; i < distance.length; ++i) {
            int y = 5 + 30 * i;
            CheckBoxPage checkBoxPage = new CheckBoxPage(distance[i], ComponentMenuContainer.Page.DISTANCE, 5, y);
            this.useRange[i + 3] = checkBoxPage;
            this.checkBoxes.addCheckBox(checkBoxPage);
            TextBoxPage textBoxPage = new TextBoxPage(ComponentMenuContainer.Page.DISTANCE, 15, (y += 14) + -2, false, 0);
            this.lowerRange[i + 3] = textBoxPage;
            this.textBoxes.addTextBox(textBoxPage);
            TextBoxPage textBoxPage2 = new TextBoxPage(ComponentMenuContainer.Page.DISTANCE, 40, y + -2, false, 128);
            this.higherRange[i + 3] = textBoxPage2;
            this.textBoxes.addTextBox(textBoxPage2);
            CheckBoxPage checkBoxPage2 = new CheckBoxPage(Localization.INVERT, ComponentMenuContainer.Page.DISTANCE, 65, y);
            this.invertRange[i + 3] = checkBoxPage2;
            this.checkBoxes.addCheckBox(checkBoxPage2);
        }
        this.radioButtonsSelection = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                this.setSelectedOption(selectedOption);
            }
        };
        Localization[] selection = new Localization[]{Localization.ONLY_SELECTED, Localization.HIDE_SELECTED};
        for (int i = 0; i < selection.length; ++i) {
            this.radioButtonsSelection.add(new RadioButton(5, 5 + 15 * i, selection[i]));
        }
        this.scrollControllerVariable = new ScrollController<Variable>(false){

            @Override
            protected List<Variable> updateSearch(String search, boolean all) {
                if (ContainerFilter.this.currentMenu == null) {
                    return new ArrayList<Variable>();
                }
                return new ArrayList<Variable>(ContainerFilter.this.currentMenu.getFilterVariables());
            }

            @Override
            protected void onClick(Variable variable, int button) {
                if (ContainerFilter.this.filterVariableSelection.contains(variable.getId())) {
                    ContainerFilter.this.filterVariableSelection.remove((Object)variable.getId());
                } else {
                    ContainerFilter.this.filterVariableSelection.add(variable.getId());
                }
            }

            @Override
            protected void draw(GuiManager gui, Variable variable, int x, int y, boolean hover) {
                ContainerFilter.this.currentMenu.drawContainer(gui, variable, ContainerFilter.this.filterVariableSelection, x, y, hover);
            }

            @Override
            protected List<String> getMouseOver(Variable variable) {
                return ContainerFilter.this.currentMenu.getMouseOverForContainer(variable, ContainerFilter.this.filterVariableSelection);
            }
        };
        this.radioButtonVariable = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                this.setSelectedOption(selectedOption);
            }
        };
        Localization[] varOptions = new Localization[]{Localization.USE_UNUSED, Localization.USE_FILTER};
        for (int i = 0; i < varOptions.length; ++i) {
            this.radioButtonVariable.add(new RadioButton(5 + 60 * i, 2, varOptions[i]));
        }
        this.variableInvert = new CheckBoxPage(Localization.INVERT, ComponentMenuContainer.Page.VARIABLE, 5, 12){

            @Override
            public boolean isVisible() {
                return super.isVisible() && ContainerFilter.this.isVariableListVisible();
            }
        };
        this.checkBoxes.addCheckBox(this.variableInvert);
    }

    public boolean isVariableListVisible() {
        return this.radioButtonVariable.getSelectedOption() == 1;
    }

    public boolean matches(TileEntityManager manager, List<Integer> selectedInventories, ConnectionBlock block) {
        boolean filterMatch = true;
        block13: for (int i = 0; i < this.useSubFilter.length; ++i) {
            if (!filterMatch || !this.useSubFilter[i].getValue()) continue;
            int rangeStart = 0;
            int rangeEnd = 2;
            switch (i) {
                case 1: {
                    rangeStart = 3;
                    rangeEnd = 4;
                }
                case 0: {
                    for (int j = rangeStart; j <= rangeEnd; ++j) {
                        boolean isRangeValid;
                        if (!this.useRange[j].getValue()) continue;
                        int value = 0;
                        switch (j) {
                            case 0: {
                                value = block.getTileEntity().field_145851_c - manager.field_145851_c;
                                break;
                            }
                            case 1: {
                                value = block.getTileEntity().field_145848_d - manager.field_145848_d;
                                break;
                            }
                            case 2: {
                                value = block.getTileEntity().field_145849_e - manager.field_145849_e;
                                break;
                            }
                            case 3: {
                                value = block.getCableDistance();
                                break;
                            }
                            case 4: {
                                value = block.getDistance(manager);
                            }
                        }
                        boolean bl = isRangeValid = this.lowerRange[j].getNumber() <= value && value <= this.higherRange[j].getNumber();
                        if (isRangeValid != this.invertRange[j].getValue()) continue;
                        filterMatch = false;
                        continue block13;
                    }
                    continue block13;
                }
                case 2: {
                    boolean onlySelected = this.radioButtonsSelection.getSelectedOption() == 0;
                    boolean selected = selectedInventories.contains(block.getId());
                    if (selected == onlySelected) continue block13;
                    filterMatch = false;
                    continue block13;
                }
                case 3: {
                    if (this.radioButtonVariable.getSelectedOption() == 0) {
                        for (Variable variable : manager.getVariables()) {
                            if (!block.isPartOfVariable(variable)) continue;
                            filterMatch = false;
                            continue block13;
                        }
                        continue block13;
                    }
                    boolean variableMatch = false;
                    for (Variable variable : manager.getVariables()) {
                        if (!this.filterVariableSelection.contains(variable.getId()) || !block.isPartOfVariable(variable)) continue;
                        variableMatch = true;
                        break;
                    }
                    if (variableMatch != this.variableInvert.getValue()) continue block13;
                    filterMatch = false;
                }
            }
        }
        return filterMatch != this.invertFilterMatch.getValue();
    }

    public void clear() {
        for (CheckBox checkBox : this.useSubFilter) {
            checkBox.setValue(false);
        }
        this.invertFilterMatch.setValue(false);
        for (CheckBox checkBox : this.useRange) {
            checkBox.setValue(false);
        }
        for (CheckBox checkBox : this.invertRange) {
            checkBox.setValue(false);
        }
        for (TextBoxPage textBoxPage : this.lowerRange) {
            textBoxPage.resetDefault();
        }
        for (TextBoxPage textBoxPage : this.higherRange) {
            textBoxPage.resetDefault();
        }
        this.radioButtonsSelection.setSelectedOption(0);
        this.radioButtonVariable.setSelectedOption(0);
        this.filterVariableSelection.clear();
        this.variableInvert.setValue(false);
    }

    class TextBoxPage
    extends TextBoxNumber {
        private ComponentMenuContainer.Page page;
        private boolean negative;
        private int defaultNumber;

        public TextBoxPage(ComponentMenuContainer.Page page, int x, int y, boolean negative, int defaultNumber) {
            super(x, y, 3, false);
            this.page = page;
            this.negative = negative;
            this.defaultNumber = defaultNumber;
            this.resetDefault();
        }

        @Override
        public boolean isVisible() {
            return this.page == ContainerFilter.this.currentMenu.getCurrentPage();
        }

        @Override
        public int getMaxNumber() {
            return 128;
        }

        @Override
        public float getTextSize() {
            return this.negative ? 0.7f : super.getTextSize();
        }

        @Override
        public int getTextY() {
            return this.negative ? 4 : super.getTextY();
        }

        @Override
        public int getMinNumber() {
            return this.negative ? -128 : super.getMinNumber();
        }

        private void resetDefault() {
            this.setNumber(this.defaultNumber);
        }
    }

    private class CheckBoxPage
    extends CheckBox {
        private boolean checked;
        private ComponentMenuContainer.Page page;

        public CheckBoxPage(Localization name, ComponentMenuContainer.Page page, int x, int y) {
            super(name, x, y);
            this.page = page;
        }

        @Override
        public void setValue(boolean val) {
            this.checked = val;
        }

        @Override
        public boolean getValue() {
            return this.checked;
        }

        @Override
        public void onUpdate() {
        }

        @Override
        public boolean isVisible() {
            return ContainerFilter.this.currentMenu.getCurrentPage() == this.page;
        }
    }
}

