/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;

public class TileEntityBreaker
extends TileEntityClusterElement
implements IInventory,
IPacketBlock {
    private static final String FAKE_PLAYER_NAME = "[SFM_PLAYER]";
    private static final String FAKE_PLAYER_ID = "[SFM_PLAYER_ID]";
    private List<ItemStack> inventory;
    private List<ItemStack> inventoryCache;
    private boolean broken;
    private int placeDirection;
    private boolean blocked;
    private static final int[] ROTATION_SIDE_MAPPING = new int[]{0, 0, 0, 2, 3, 1};
    private static final String NBT_DIRECTION = "Direction";
    private boolean missingPlaceDirection;
    private static final int UPDATE_BUFFER_DISTANCE = 5;
    private boolean hasUpdatedData;

    private List<ItemStack> getInventory() {
        if (this.inventory == null) {
            ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[this.func_145832_p() % ForgeDirection.VALID_DIRECTIONS.length];
            int x = this.field_145851_c + direction.offsetX;
            int y = this.field_145848_d + direction.offsetY;
            int z = this.field_145849_e + direction.offsetZ;
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (this.canBreakBlock(block, x, y, z)) {
                this.inventory = block.getDrops(this.field_145850_b, x, y, z, this.field_145850_b.func_72805_g(x, y, z), 0);
            }
            if (this.inventory == null) {
                this.inventory = new ArrayList<ItemStack>();
            }
            this.inventoryCache = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.inventory) {
                this.inventoryCache.add(itemStack.func_77946_l());
            }
        }
        return this.inventory;
    }

    private ItemStack placeItem(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() != null && itemstack.field_77994_a > 0) {
            ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[this.func_145832_p() % ForgeDirection.VALID_DIRECTIONS.length];
            ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[this.placeDirection].getOpposite();
            float hitX = 0.5f + (float)direction.offsetX * 0.5f;
            float hitY = 0.5f + (float)direction.offsetY * 0.5f;
            float hitZ = 0.5f + (float)direction.offsetZ * 0.5f;
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(FAKE_PLAYER_ID, FAKE_PLAYER_NAME));
            int rotationSide = ROTATION_SIDE_MAPPING[direction.ordinal()];
            player.field_70127_C = player.field_70177_z = (float)(rotationSide * 90);
            player.field_70125_A = direction == ForgeDirection.UP ? 90.0f : (direction == ForgeDirection.DOWN ? -90.0f : 0.0f);
            player.field_70126_B = player.field_70125_A;
            player.field_70169_q = player.field_70165_t = (double)(this.field_145851_c + side.offsetX) + 0.5 + (double)direction.offsetX * 0.4;
            player.field_70167_r = player.field_70163_u = (double)(this.field_145848_d + side.offsetY) + 0.5 + (double)direction.offsetY * 0.4;
            player.field_70166_s = player.field_70161_v = (double)(this.field_145849_e + side.offsetZ) + 0.5 + (double)direction.offsetZ * 0.4;
            player.eyeHeight = 0.0f;
            player.field_70129_M = 1.82f;
            player.field_71134_c.setBlockReachDistance(1.0);
            this.blocked = true;
            try {
                player.field_71071_by.field_70461_c = 0;
                player.field_71071_by.func_70299_a(0, itemstack);
                ItemStack result = itemstack.func_77957_a(this.field_145850_b, (EntityPlayer)player);
                if (result == null || !result.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack)) {
                    itemstack = result;
                } else {
                    int x = this.field_145851_c + side.offsetX - direction.offsetX;
                    int y = this.field_145848_d + side.offsetY - direction.offsetY;
                    int z = this.field_145849_e + side.offsetZ - direction.offsetZ;
                    player.field_71134_c.func_73078_a((EntityPlayer)player, this.field_145850_b, itemstack, x, y, z, direction.ordinal(), hitX, hitY, hitZ);
                    ItemStack playerItem = player.field_71071_by.func_70301_a(0);
                    if (playerItem == null || !playerItem.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)playerItem, (ItemStack)itemstack)) {
                        itemstack = null;
                    }
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.blocked = false;
        }
        return itemstack;
    }

    public void func_145845_h() {
        if (this.missingPlaceDirection) {
            this.setPlaceDirection(this.func_145832_p());
            this.missingPlaceDirection = false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.keepClientDataUpdated();
        }
        if (this.inventory != null) {
            ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[this.func_145832_p() % ForgeDirection.VALID_DIRECTIONS.length];
            for (ItemStack itemStack : this.getInventoryForDrop()) {
                if ((itemStack = this.placeItem(itemStack)) == null || itemStack.field_77994_a <= 0) continue;
                double x = (double)this.field_145851_c + 0.5 + (double)direction.offsetX * 0.75;
                double y = (double)this.field_145848_d + 0.5 + (double)direction.offsetY * 0.75;
                double z = (double)this.field_145849_e + 0.5 + (double)direction.offsetZ * 0.75;
                if (direction.offsetY == 0) {
                    y -= 0.1;
                }
                EntityItem entityitem = new EntityItem(this.field_145850_b, x, y, z, itemStack);
                entityitem.field_70159_w = (double)direction.offsetX * 0.1;
                entityitem.field_70181_x = (double)direction.offsetY * 0.1;
                entityitem.field_70179_y = (double)direction.offsetZ * 0.1;
                entityitem.field_145804_b = 40;
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
        }
        this.inventory = null;
        this.inventoryCache = null;
        this.broken = false;
    }

    private List<ItemStack> getInventoryForDrop() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.inventory) {
            if (itemStack == null) continue;
            ItemStack newStack = itemStack.func_77946_l();
            if (!this.broken) {
                for (int i = 0; i < this.inventoryCache.size(); ++i) {
                    ItemStack copyStack = this.inventoryCache.get(i);
                    if (copyStack == null || !newStack.func_77969_a(copyStack) || !ItemStack.func_77970_a((ItemStack)newStack, (ItemStack)copyStack)) continue;
                    int max = Math.min(copyStack.field_77994_a, newStack.field_77994_a);
                    copyStack.field_77994_a -= max;
                    if (copyStack.field_77994_a == 0) {
                        this.inventoryCache.set(0, null);
                    }
                    newStack.field_77994_a -= max;
                    if (newStack.field_77994_a != 0) continue;
                    newStack = null;
                    break;
                }
            }
            if (newStack == null) continue;
            ret.add(newStack);
        }
        return ret;
    }

    public int func_70302_i_() {
        return this.getInventory().size() + 1;
    }

    public ItemStack func_70301_a(int id) {
        if (id < this.getInventory().size()) {
            return this.getInventory().get(id);
        }
        return null;
    }

    public ItemStack func_70298_a(int id, int count) {
        ItemStack item = this.func_70301_a(id);
        if (item != null) {
            if (item.field_77994_a <= count) {
                this.getInventory().set(id, null);
                return item;
            }
            ItemStack ret = item.func_77979_a(count);
            if (item.field_77994_a == 0) {
                this.getInventory().set(id, null);
            }
            return ret;
        }
        return null;
    }

    public void func_70299_a(int id, ItemStack itemstack) {
        if (id < this.getInventory().size()) {
            this.getInventory().set(id, itemstack);
        } else {
            this.getInventory().add(itemstack);
            this.inventoryCache.add(null);
        }
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public String func_145825_b() {
        return ModBlocks.blockCableBreaker.func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.inventory != null && !this.broken) {
            boolean match = true;
            for (int i = 0; i < this.inventory.size(); ++i) {
                ItemStack itemStack = this.inventory.get(i);
                ItemStack itemStackCopy = this.inventoryCache.get(i);
                if (itemStackCopy == null || itemStack != null && Item.func_150891_b((Item)itemStack.func_77973_b()) == Item.func_150891_b((Item)itemStackCopy.func_77973_b()) && itemStack.func_77960_j() == itemStackCopy.func_77960_j() && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStackCopy) && itemStack.field_77994_a >= itemStackCopy.field_77994_a) continue;
                match = false;
                break;
            }
            if (!match) {
                ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[this.func_145832_p() % ForgeDirection.VALID_DIRECTIONS.length];
                int x = this.field_145851_c + direction.offsetX;
                int y = this.field_145848_d + direction.offsetY;
                int z = this.field_145849_e + direction.offsetZ;
                Block block = this.field_145850_b.func_147439_a(x, y, z);
                if (this.canBreakBlock(block, x, y, z)) {
                    this.broken = true;
                    int meta = this.field_145850_b.func_72805_g(x, y, z);
                    block.func_149749_a(this.field_145850_b, x, y, z, block, meta);
                    this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }
    }

    private boolean canBreakBlock(Block block, int x, int y, int z) {
        return block != null && Block.func_149682_b((Block)block) != Block.func_149682_b((Block)Blocks.field_150357_h) && block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f;
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_BLOCK_PLACED_BY, ClusterMethodRegistration.ON_BLOCK_ACTIVATED);
    }

    @Override
    protected void readContentFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b(NBT_DIRECTION)) {
            this.setPlaceDirection(tagCompound.func_74771_c(NBT_DIRECTION));
        } else if (this.field_145850_b != null) {
            this.setPlaceDirection(this.func_145832_p());
        } else {
            this.missingPlaceDirection = true;
        }
    }

    @Override
    protected void writeContentToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74774_a(NBT_DIRECTION, (byte)this.placeDirection);
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        if (this.isPartOfCluster()) {
            return;
        }
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasUpdatedData = false;
        } else if (!this.hasUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasUpdatedData = true;
            PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            dw.writeData(this.placeDirection, DataBitHelper.PLACE_DIRECTION);
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 0);
        } else {
            this.placeDirection = dr.readData(DataBitHelper.PLACE_DIRECTION);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 0;
    }

    public int getPlaceDirection() {
        return this.placeDirection;
    }

    public void setPlaceDirection(int placeDirection) {
        if (this.placeDirection != placeDirection) {
            this.placeDirection = placeDirection;
            if (!this.isPartOfCluster() && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                PacketHandler.sendBlockPacket(this, null, 0);
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

