/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.network;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.network.DataBitHelper;

public class DataReader {
    private InputStream stream;
    private int byteBuffer;
    private int bitCountBuffer;
    private boolean idRead;
    private int idBits;
    private boolean invRead;
    private int invBits;

    DataReader(byte[] data) {
        this.stream = new ByteArrayInputStream(data);
    }

    DataReader(InputStream stream) {
        this.stream = stream;
    }

    public int readByte() {
        return this.readData(8);
    }

    public boolean readBoolean() {
        return this.readData(DataBitHelper.BOOLEAN) != 0;
    }

    public int readData(DataBitHelper bitCount) {
        return this.readData(bitCount.getBitCount());
    }

    public int readData(int bitCount) {
        int data = 0;
        int readBits = 0;
        while (true) {
            int bitsLeft;
            if (this.bitCountBuffer >= (bitsLeft = bitCount - readBits)) {
                data |= (this.byteBuffer & (int)Math.pow(2.0, bitsLeft) - 1) << readBits;
                this.byteBuffer >>>= bitsLeft;
                this.bitCountBuffer -= bitsLeft;
                readBits += bitsLeft;
                break;
            }
            data |= this.byteBuffer << readBits;
            readBits += this.bitCountBuffer;
            try {
                this.byteBuffer = this.stream.read();
            }
            catch (IOException ignored) {
                this.byteBuffer = 0;
            }
            this.bitCountBuffer = 8;
        }
        return data;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readString(DataBitHelper bits) {
        int length = this.readData(bits);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.readByte();
        }
        return new String(bytes);
    }

    public NBTTagCompound readNBT() {
        if (this.readBoolean()) {
            byte[] bytes = new byte[this.readData(DataBitHelper.NBT_LENGTH)];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)this.readByte();
            }
            try {
                return CompressedStreamTools.func_74792_a((byte[])bytes);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public int readComponentId() {
        if (!this.idRead) {
            this.idBits = this.readBoolean() ? this.readData(DataBitHelper.BIT_COUNT) : DataBitHelper.FLOW_CONTROL_COUNT.getBitCount();
            this.idRead = true;
        }
        return this.readData(this.idBits);
    }

    public int readInventoryId() {
        if (!this.invRead) {
            this.invBits = this.readBoolean() ? this.readData(DataBitHelper.BIT_COUNT) : DataBitHelper.MENU_INVENTORY_SELECTION.getBitCount();
            this.invRead = true;
        }
        return this.readData(this.invBits);
    }
}

