/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuItem;
import vswe.stevesfactory.components.CraftingDummy;
import vswe.stevesfactory.components.CraftingSetting;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.GuiManager;

public class ComponentMenuCrafting
extends ComponentMenuItem {
    private ItemStack resultItem;
    private CraftingDummy dummy = new CraftingDummy(this);

    public ComponentMenuCrafting(FlowComponent parent) {
        super(parent, CraftingSetting.class);
        this.scrollControllerSelected.setItemsPerRow(3);
        this.scrollControllerSelected.setVisibleRows(3);
        this.scrollControllerSelected.setItemUpperLimit(2);
    }

    @Override
    public String getName() {
        return Localization.CRAFTING_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        if (!this.isEditing() && !this.isSearching() && this.resultItem != null) {
            this.drawResultObject(gui, this.resultItem, this.getResultX(), this.getResultY());
            gui.drawItemAmount(this.resultItem, this.getResultX(), this.getResultY());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        if (!this.isEditing() && !this.isSearching() && this.resultItem != null && CollisionHelper.inBounds(this.getResultX(), this.getResultY(), 16, 16, mX, mY)) {
            gui.drawMouseOver(this.getResultObjectMouseOver(this.resultItem), mX, mY);
        }
    }

    private int getResultX() {
        return 65;
    }

    private int getResultY() {
        return this.scrollControllerSelected.getScrollingStartY() + 20;
    }

    @Override
    protected int getSettingCount() {
        return 9;
    }

    @Override
    protected void initRadioButtons() {
    }

    @Override
    protected void onSettingContentChange() {
        this.resultItem = this.dummy.getResult();
    }

    public CraftingDummy getDummy() {
        return this.dummy;
    }
}

