/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.IRedstoneNode;
import vswe.stevesfactory.blocks.ISystemListener;
import vswe.stevesfactory.blocks.ITriggerNode;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.blocks.TileEntityManager;

public class TileEntityInput
extends TileEntityClusterElement
implements IRedstoneNode,
ISystemListener,
ITriggerNode {
    private List<TileEntityManager> managerList = new ArrayList<TileEntityManager>();
    private int[] oldPowered = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] isPowered = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_POWER = "Power";

    @Override
    public void added(TileEntityManager owner) {
        if (!this.managerList.contains(owner)) {
            this.managerList.add(owner);
        }
    }

    @Override
    public void removed(TileEntityManager owner) {
        this.managerList.remove(owner);
    }

    public void triggerRedstone() {
        int i;
        this.isPowered = new int[this.isPowered.length];
        for (i = 0; i < this.isPowered.length; ++i) {
            ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[i];
            this.isPowered[i] = this.field_145850_b.func_72878_l(direction.offsetX + this.field_145851_c, direction.offsetY + this.field_145848_d, direction.offsetZ + this.field_145849_e, direction.ordinal());
        }
        for (i = this.managerList.size() - 1; i >= 0; --i) {
            this.managerList.get(i).triggerRedstone(this);
        }
        this.oldPowered = this.isPowered;
    }

    @Override
    public int[] getPower() {
        return this.isPowered;
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        NBTTagList sidesTag = nbtTagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < sidesTag.func_74745_c(); ++i) {
            NBTTagCompound sideTag = sidesTag.func_150305_b(i);
            byte by = sideTag.func_74771_c(NBT_POWER);
            this.isPowered[i] = by;
            this.oldPowered[i] = by;
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)11);
        NBTTagList sidesTag = new NBTTagList();
        for (int i = 0; i < this.isPowered.length; ++i) {
            NBTTagCompound sideTag = new NBTTagCompound();
            sideTag.func_74774_a(NBT_POWER, (byte)this.isPowered[i]);
            sidesTag.func_74742_a((NBTBase)sideTag);
        }
        nbtTagCompound.func_74782_a(NBT_SIDES, (NBTBase)sidesTag);
    }

    @Override
    public int[] getData() {
        return this.isPowered;
    }

    @Override
    public int[] getOldData() {
        return this.oldPowered;
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.CAN_CONNECT_REDSTONE, ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED, ClusterMethodRegistration.ON_BLOCK_ADDED);
    }
}

