/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.startinginventory;

import bspkrs.helpers.entity.player.EntityPlayerHelper;
import bspkrs.helpers.entity.player.InventoryPlayerHelper;
import bspkrs.helpers.item.ItemHelper;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.SaveHandler;

public class StartingInventory {
    public static final String VERSION_NUMBER = "1.7.2.r01";
    boolean canGiveItems;
    private static String fileName = "startingInventory.txt";
    private static String configPath = "/config/";
    private static File file = new File(new File(CommonUtils.getMinecraftDir()), configPath + fileName);
    private static Scanner scan;
    private static List<String> list;
    private static final String[] defaultItems;

    public static void init() {
        if (!file.exists()) {
            StartingInventory.createFile();
        } else {
            try {
                scan = new Scanner(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        StartingInventory.readItems();
    }

    public static boolean isPlayerNewToWorld(MinecraftServer server, EntityPlayer player) {
        SaveHandler saveHandler = (SaveHandler)server.func_71218_a(0).func_72860_G();
        File dir = new File(saveHandler.func_75765_b(), "/StartingInv");
        return !dir.exists() || !new File(dir, EntityPlayerHelper.getGameProfile((EntityPlayer)player).getName() + ".si").exists();
    }

    public static boolean isPlayerInventoryEmpty(InventoryPlayer inv) {
        int i;
        for (i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null) continue;
            return false;
        }
        for (i = 0; i < inv.field_70460_b.length; ++i) {
            if (inv.field_70460_b[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean createPlayerFile(MinecraftServer server, EntityPlayer player) {
        SaveHandler saveHandler = (SaveHandler)server.func_71218_a(0).func_72860_G();
        File dir = new File(saveHandler.func_75765_b(), "/StartingInv");
        if (!dir.exists() && !dir.mkdir()) {
            return false;
        }
        File pFile = new File(dir, EntityPlayerHelper.getGameProfile((EntityPlayer)player).getName() + ".si");
        try {
            pFile.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(pFile));
            out.println("I was here!");
            out.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean addItems(EntityPlayer player) {
        for (int i = 0; i < Math.min(player.field_71071_by.func_70302_i_(), list.size()); ++i) {
            StartingInventory.addItemToInv(list.get(i), player);
        }
        return true;
    }

    private static String[] parseLine(String entry) {
        String[] r = new String[]{"", "1", "0", ""};
        int d1 = entry.indexOf(44);
        int d2 = entry.indexOf(44, d1 + 1);
        int d3 = entry.indexOf(44, d2 + 1);
        if (d1 != -1) {
            r[0] = entry.substring(0, d1);
            if (d2 != -1) {
                r[1] = entry.substring(d1 + 1, d2);
                if (d3 != -1) {
                    r[2] = entry.substring(d2 + 1, d3);
                    r[3] = entry.substring(d3 + 1);
                } else {
                    r[2] = entry.substring(d2 + 1);
                }
            } else {
                r[1] = entry.substring(d1 + 1);
            }
        } else {
            r[0] = entry;
        }
        return r;
    }

    private static void addItemToInv(String entry, EntityPlayer player) {
        String[] item = StartingInventory.parseLine(entry);
        if (ItemHelper.getItem((String)item[0]) != null) {
            player.field_71071_by.func_70441_a(new ItemStack(ItemHelper.getItem((String)item[0]), CommonUtils.parseInt((String)item[1]), CommonUtils.parseInt((String)item[2])));
        }
    }

    private static void readItems() {
        list.clear();
        if (scan != null) {
            while (scan.hasNextLine()) {
                list.add(scan.nextLine());
            }
        }
        scan.close();
    }

    private static void createFile() {
        File dir = new File(new File(CommonUtils.getMinecraftDir()), configPath);
        file = !dir.exists() && dir.mkdir() ? new File(dir, fileName) : new File(dir, fileName);
        try {
            file.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (String s : defaultItems) {
                out.println(s);
            }
            out.close();
            scan = new Scanner(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void writeConfigFileFromInventory(EntityPlayer player) {
        list.clear();
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                String name;
                if (itemStack == null || (name = ItemHelper.getUniqueID((Item)itemStack.func_77973_b())) == null || name.isEmpty()) continue;
                list.add(name + ", " + itemStack.field_77994_a + ", " + itemStack.func_77960_j());
            }
            for (String s : list) {
                out.println(s);
            }
            out.close();
            scan = new Scanner(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StartingInventory.readItems();
    }

    protected static void loadInventoryFromConfigFile(EntityPlayer player) {
        InventoryPlayerHelper.clearInventory((InventoryPlayer)player.field_71071_by, null, (int)-1);
        StartingInventory.addItems(player);
    }

    static {
        list = new ArrayList<String>();
        defaultItems = new String[]{"minecraft:stone_pickaxe, 1", "minecraft:stone_shovel, 1", "minecraft:stone_sword, 1", "minecraft:stone_axe, 1", "minecraft:apple, 16", "minecraft:torch, 16"};
    }
}

