/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.server;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.util.SomniaState;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;

public class ServerTickHandler {
    public static final String TRANSLATION_FORMAT = "somnia.status.%s";
    private static int activeTickHandlers = 0;
    public WorldServer worldServer;
    public SomniaState currentState;
    public long lastSleepStart;
    public long currentSleepPeriod;
    public long checkTimer = 0L;
    public long lastTpsMillis = 0L;
    public long liTps = 0L;
    public long tps = 0L;
    private double multiplier;
    private double overflow;

    public ServerTickHandler(WorldServer worldServer) {
        this.multiplier = Somnia.proxy.baseMultiplier;
        this.overflow = 0.0;
        this.worldServer = worldServer;
    }

    public void tickStart() {
        this.incrementCounters();
        if (++this.checkTimer == 10L) {
            this.checkTimer = 0L;
            SomniaState prevState = this.currentState;
            this.currentState = SomniaState.getState(this);
            if (prevState != this.currentState) {
                this.currentSleepPeriod = 0L;
                if (this.currentState == SomniaState.ACTIVE) {
                    this.lastSleepStart = this.worldServer.func_82737_E();
                    ++activeTickHandlers;
                } else if (prevState == SomniaState.ACTIVE) {
                    --activeTickHandlers;
                    if (this.currentState == SomniaState.EXPIRED || this.currentState == SomniaState.NOT_NOW) {
                        this.closeGuiWithMessage(this.currentState.toString());
                    }
                }
            }
            if (this.currentState == SomniaState.ACTIVE || this.currentState == SomniaState.WAITING_PLAYERS || this.currentState == SomniaState.COOLDOWN) {
                FMLProxyPacket packet = PacketHandler.buildGUIUpdatePacket("status", this.currentState == SomniaState.ACTIVE ? Somnia.timeStringForWorldTime(this.worldServer.func_72820_D()) : "f:" + this.currentState.toString(), "speed", this.currentState == SomniaState.ACTIVE ? (double)this.tps / 20.0 : 0.0);
                Somnia.channel.sendToDimension(packet, this.worldServer.field_73011_w.field_76574_g);
            }
        }
        if (this.currentState == SomniaState.ACTIVE) {
            this.doMultipliedTicking();
        }
    }

    private void closeGuiWithMessage(String key) {
        FMLProxyPacket packet = PacketHandler.buildGUIClosePacket();
        ChatComponentTranslation chatComponent = new ChatComponentTranslation(String.format(TRANSLATION_FORMAT, key), new Object[0]);
        for (EntityPlayer ep : this.worldServer.field_73010_i) {
            if (!ep.func_70608_bn()) continue;
            Somnia.channel.sendTo(packet, (EntityPlayerMP)ep);
            if (ep.func_70608_bn()) {
                ep.func_70999_a(false, true, true);
            }
            ep.func_145747_a((IChatComponent)chatComponent);
        }
    }

    private void incrementCounters() {
        ++this.liTps;
        if (this.currentState == SomniaState.ACTIVE) {
            ++this.currentSleepPeriod;
        }
    }

    private void doMultipliedTicking() {
        long currentTimeMillis;
        int liMultiplier = (int)Math.floor(this.multiplier);
        double target = (double)liMultiplier + this.overflow;
        int liTarget = (int)Math.floor(target);
        this.overflow = target - (double)liTarget;
        long nanoTime = System.nanoTime();
        for (int i = 0; i < liTarget; ++i) {
            this.doMultipliedServerTicking();
        }
        this.multiplier = (double)nanoTime > 50.0 / (double)activeTickHandlers ? (this.multiplier += 0.1) : (this.multiplier -= 0.1);
        if (this.multiplier > Somnia.proxy.multiplierCap) {
            this.multiplier = Somnia.proxy.multiplierCap;
        }
        if (this.multiplier < Somnia.proxy.baseMultiplier) {
            this.multiplier = Somnia.proxy.baseMultiplier;
        }
        if ((currentTimeMillis = System.currentTimeMillis()) - this.lastTpsMillis > 1000L) {
            this.tps = this.liTps;
            this.liTps = 0L;
            this.lastTpsMillis = currentTimeMillis;
        }
    }

    private void doMultipliedServerTicking() {
        this.worldServer.func_72835_b();
        this.worldServer.func_72939_s();
        this.worldServer.func_73039_n().func_72788_a();
        MinecraftServer.func_71276_C().func_71203_ab().func_148537_a((Packet)new S03PacketTimeUpdate(this.worldServer.func_82737_E(), this.worldServer.func_72820_D(), this.worldServer.func_82736_K().func_82766_b("doDaylightCycle")), this.worldServer.field_73011_w.field_76574_g);
        this.incrementCounters();
    }
}

