/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import redgear.core.util.SimpleItem;

public class CoreDungeonLoot {
    public static final String[] dungeons = new String[]{"dungeonChest", "mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "strongholdCorridor"};

    public static void addLoot(String chestType, ItemStack loot, int maxStack, LootRarity rarity) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, maxStack, rarity.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addLoot(String chestType, SimpleItem loot, int maxStack, LootRarity rarity) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot.getStack(), 1, maxStack, rarity.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addLoot(String chestType, Item loot, int maxStack, LootRarity rarity) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(new ItemStack(loot, 1, 0), 1, maxStack, rarity.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addRareLoot(String chestType, ItemStack loot) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, 1, LootRarity.RARE.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addJunkLoot(String chestType, ItemStack loot, int maxStack) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, maxStack, LootRarity.JUNK.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addEpicLoot(String chestType, ItemStack loot) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, 1, LootRarity.EPIC.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addCommonLoot(String chestType, ItemStack loot, int maxStack) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, maxStack, LootRarity.COMMON.asInt());
        ChestGenHooks.getInfo((String)chestType).addItem(lootStack);
    }

    public static void addLootToDungeons(ItemStack loot, LootRarity rarity) {
        WeightedRandomChestContent lootStack = new WeightedRandomChestContent(loot, 1, 1, rarity.asInt());
        for (String chest : dungeons) {
            ChestGenHooks.getInfo((String)chest).addItem(lootStack);
        }
    }

    public static enum LootRarity {
        JUNK(65),
        WIDESPREAD(55),
        COMMON(40),
        UNCOMMON(30),
        RARE(10),
        EPIC(3);

        private final int rarity;

        private LootRarity(int level) {
            this.rarity = level;
        }

        public int asInt() {
            return this.rarity;
        }
    }
}

