/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.machine;

import net.minecraft.nbt.NBTTagCompound;
import redgear.core.machine.IMachine;

public class MachineHandler {
    private final IMachine machine;
    private final int idleRate;
    private int idle = 0;
    private int energyRate = 0;
    private int standby = 0;
    protected int workTotal = 0;
    protected int work = 0;

    public MachineHandler(IMachine machine, int idleRate) {
        this.machine = machine;
        this.idleRate = idleRate;
    }

    public void doWork() {
        if (this.standby > 0) {
            --this.standby;
            return;
        }
        if (this.idle-- <= 0) {
            this.idle = this.idleRate;
            this.machine.doPreWork();
            if (this.work == 0) {
                this.work = this.machine.checkWork();
            }
        }
        if (this.work > 0 && this.machine.tryUseEnergy(this.energyRate) && --this.work <= 0) {
            this.workTotal = 0;
            this.machine.doPostWork();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("idle", this.idle);
        tag.func_74768_a("energyRate", this.energyRate);
        tag.func_74768_a("work", this.work);
        tag.func_74768_a("workTotal", this.workTotal);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.idle = tag.func_74762_e("idle");
        this.energyRate = tag.func_74762_e("energyRate");
        this.work = tag.func_74762_e("work");
        this.workTotal = tag.func_74762_e("workTotal");
    }

    public int getWork() {
        return this.work;
    }

    public void addWork(int work) {
        this.work += work;
    }

    public int getWorkTotal() {
        return this.workTotal;
    }

    public void setWorkTotal(int workTotal) {
        this.workTotal = workTotal;
    }

    public void setEnergyRate(int energyRate) {
        this.energyRate = energyRate;
    }

    public int getIdle() {
        return this.idle;
    }

    public void setIdle(int idle) {
        this.idle = idle;
    }

    public int getStandby() {
        return this.standby;
    }

    public void setStandby(int ticks) {
        this.standby = ticks;
    }
}

