/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import redgear.core.inventory.InvSlot;

public class IntentoryStorage
implements ISidedInventory {
    private final List<InvSlot> slots = new ArrayList<InvSlot>();

    public int addSlot(InvSlot slot) {
        this.slots.add(slot);
        return slot.getSlotIndex();
    }

    public int addSlot(int x, int y) {
        return this.addSlot(new InvSlot((IInventory)this, x, y));
    }

    public ItemStack addStack(ItemStack stack) {
        for (InvSlot slot : this.slots) {
            stack = slot.addStack(stack, false);
            if (stack != null) continue;
            return null;
        }
        return stack;
    }

    public ItemStack addStack(ItemStack stack, int[] possibleSlots) {
        for (int i : possibleSlots) {
            stack = this.slots.get(i).addStack(stack, false);
            if (stack != null) continue;
            return null;
        }
        return stack;
    }

    public ItemStack addStack(int slot, ItemStack stack) {
        return this.slots.get(slot).addStack(stack);
    }

    public ItemStack addStack(int slot, ItemStack stack, boolean all) {
        return this.slots.get(slot).addStack(stack, all);
    }

    public ItemStack addStack(int slot, ItemStack stack, boolean all, boolean override) {
        return this.slots.get(slot).addStack(stack, all, override);
    }

    public boolean canAddStack(ItemStack stack) {
        boolean test = false;
        for (InvSlot slot : this.slots) {
            test = slot.canAddStack(stack, false);
            if (!test) continue;
            return test;
        }
        return test;
    }

    public boolean canAddStack(ItemStack stack, int[] possibleSlots) {
        boolean test = false;
        for (int i : possibleSlots) {
            test = this.slots.get(i).canAddStack(stack, false);
            if (!test) continue;
            return test;
        }
        return test;
    }

    public boolean canAddStack(int slot, ItemStack stack) {
        return this.slots.get(slot).canAddStack(stack);
    }

    public boolean canAddStack(int slot, ItemStack stack, boolean all) {
        return this.slots.get(slot).canAddStack(stack, all);
    }

    public boolean canAddStack(int slot, ItemStack stack, boolean all, boolean override) {
        return this.slots.get(slot).canAddStack(stack, all, override);
    }

    public boolean stackAllowed(int slot, ItemStack stack) {
        return this.slots.get(slot).stackAllowed(stack);
    }

    public boolean validSlot(int slot) {
        return slot > 0 && slot < this.slots.size();
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int index) {
        return this.slots.get(index).func_75211_c();
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.slots.get(index).func_75209_a(amount);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots.get(slot).func_75215_d(stack);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.slots.get(slot).canAddStack(itemstack, false, false);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.size(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(invTag);
            itemList.func_74742_a((NBTBase)invTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound invTag = tagList.func_150305_b(i);
            byte slot = invTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.size()) continue;
            this.slots.get(slot).func_75215_d(ItemStack.func_77949_a((NBTTagCompound)invTag));
        }
    }

    public int[] func_94128_d(int var1) {
        int[] temp = new int[this.slots.size()];
        for (int i = 0; i < this.slots.size(); ++i) {
            temp[i] = i;
        }
        return temp;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.slots.get(i).canAddStack(itemstack, false, false);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return this.slots.get(slot).canExtract();
    }

    public List<InvSlot> getSlots() {
        return this.slots;
    }

    public void func_70296_d() {
    }
}

