/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.api.util;

import java.util.Arrays;
import java.util.List;

public final class HashHelper {
    private static final int seed = 7;
    private static final int prime = 31;

    private static int start(int seed) {
        return 31 * seed;
    }

    public static int hash(int seed, boolean value) {
        return HashHelper.start(seed) + (value ? 1 : 0);
    }

    public static int hash(int seed, char value) {
        return HashHelper.hash((int)value);
    }

    public static int hash(int seed, int value) {
        return HashHelper.start(seed) + value;
    }

    public static int hash(int seed, float value) {
        return HashHelper.hash(seed, Float.floatToIntBits(value));
    }

    public static int hash(int seed, long value) {
        return HashHelper.start(seed) + (int)(value ^ value >>> 32);
    }

    public static int hash(int seed, double value) {
        return HashHelper.hash(seed, Double.doubleToLongBits(value));
    }

    public static int hash(int seed, Object obj) {
        if (obj == null) {
            return HashHelper.hash(seed, 0);
        }
        if (obj.getClass().isArray()) {
            List<Object> values = Arrays.asList(obj);
            int ans = seed;
            for (Object val : values) {
                if (val == obj) continue;
                ans = HashHelper.hash(ans, val);
            }
            return ans;
        }
        return HashHelper.hash(seed, obj.hashCode());
    }

    public static int hash(Object ... objects) {
        int ans = 7;
        for (Object obj : objects) {
            ans = HashHelper.hash(ans, obj);
        }
        return ans;
    }
}

