/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.tile;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.tile.IFacedTile;

public abstract class TileEntityGeneric
extends TileEntity
implements IFacedTile {
    private ForgeDirection direction = ForgeDirection.SOUTH;
    private boolean needsReSync = false;
    private static final int[] directionMap = new int[]{2, 5, 3, 4};

    @Override
    public final int getDirectionId() {
        return this.getDirection().ordinal();
    }

    @Override
    public ForgeDirection getDirection() {
        return this.direction;
    }

    @Override
    public final boolean setDirection(int id) {
        return this.setDirection(ForgeDirection.getOrientation((int)id));
    }

    @Override
    public boolean setDirection(ForgeDirection side) {
        boolean ans = false;
        if (side != ForgeDirection.UNKNOWN) {
            ans = this.direction != side;
            this.direction = side;
        }
        return ans;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        this.setDirection(directionMap[MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3]);
    }

    protected boolean isClient() {
        return !this.isServer();
    }

    protected boolean isServer() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K;
    }

    public void func_145845_h() {
        if (this.isServer() && this.needsReSync) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            this.needsReSync = false;
        }
    }

    public void forceSync() {
        this.needsReSync = true;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.direction = ForgeDirection.getOrientation((int)tag.func_74771_c("direction"));
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

