/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.render;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import redgear.core.render.ContainerBase;
import redgear.core.render.RenderHelper;
import redgear.core.render.gui.TabTracker;
import redgear.core.render.gui.element.ElementBase;
import redgear.core.render.gui.element.TabBase;

public abstract class GuiBase<C extends ContainerBase<? extends TileEntity>>
extends GuiContainer {
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected final C myContainer;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();

    public GuiBase(C container) {
        super(container);
        this.myContainer = container;
    }

    public GuiBase(C container, ResourceLocation texture) {
        this(container);
        this.texture = texture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.name), 8, 4, 0x404040);
        if (this.drawInventory) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 3, 0x404040);
        }
        if (!Loader.isModLoaded((String)"NotEnoughItems") && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        this.updateElements();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawElements();
        this.drawTabs();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        ElementBase element;
        super.func_73864_a(x, y, mouseButton);
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null && !tab.handleMouseClicked(this.mouseX, this.mouseY, mouseButton)) {
            for (TabBase other : this.tabs) {
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null) {
            element.handleMouseClicked(this.mouseX, this.mouseY, mouseButton);
        }
    }

    private boolean isMouseOverSlot(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.func_146978_c(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    private Slot getSlotAtPosition(int p_146975_1_, int p_146975_2_) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, p_146975_1_, p_146975_2_)) continue;
            return slot;
        }
        return null;
    }

    protected void func_146273_a(int mX, int mY, int lastClick, long timeSinceClick) {
        Slot slot = this.getSlotAtPosition(mX, mY);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_146291_p && slot != null && itemstack != null) {
            if (this.lastIndex != slot.field_75222_d) {
                this.lastIndex = slot.field_75222_d;
                this.func_146984_a(slot, slot.field_75222_d, 0, 0);
            }
        } else {
            this.lastIndex = -1;
            super.func_146273_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    public void func_146274_d() {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        super.func_146274_d();
    }

    protected void drawElements() {
        for (ElementBase element : this.elements) {
            element.draw();
        }
    }

    protected void drawTabs() {
        int yPosRight = 4;
        int yPosLeft = 4;
        for (TabBase tab : this.tabs) {
            tab.update();
            if (!tab.isVisible()) continue;
            if (tab.side == 0) {
                tab.draw(this.field_147003_i, this.field_147009_r + yPosLeft);
                yPosLeft += tab.currentHeight;
                continue;
            }
            tab.draw(this.field_147003_i + this.field_146999_f, this.field_147009_r + yPosRight);
            yPosRight += tab.currentHeight;
        }
    }

    public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
        this.addTooltips(tooltip);
        return tooltip;
    }

    public void addTooltips(List<String> tooltip) {
        ElementBase element;
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            tab.addTooltip(tooltip);
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null) {
            element.addTooltip(tooltip);
        }
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    public TabBase addTab(TabBase tab) {
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        for (ElementBase element : this.elements) {
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected void updateElements() {
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
    }

    public void drawButton(IIcon icon, int x, int y, int spriteSheet, int mode) {
        this.drawIcon(icon, x, y, spriteSheet);
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub(fluid.getFluid().getColor(fluid));
        this.drawTiledTexture(x, y, fluid.getFluid().getIcon(fluid), width, height);
    }

    public void drawTiledTexture(int x, int y, IIcon icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(IIcon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(x, y, icon, 16, 16);
    }

    public void drawIcon(String iconName, int x, int y, int spriteSheet) {
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX, this.mouseY, this.field_146289_q);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int x, int y, FontRenderer font) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        for (String s : list) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (list.size() > 1) {
            k1 += 2 + (list.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiBase.field_146296_j.field_77023_b = 300.0f;
        int l1 = -267386864;
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            String s1 = (String)list.get(k2);
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiBase.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void mouseClicked(int mouseButton) {
        super.func_73864_a(this.field_147003_i + this.mouseX, this.field_147009_r + this.mouseY, mouseButton);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_146289_q.func_78256_a(string)) / 2;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void overlayRecipe() {
    }
}

