/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import redgear.core.recipes.Level;
import redgear.core.recipes.RecipeMap;
import redgear.core.recipes.Replacement;
import redgear.core.util.SimpleItem;

public class LeveledRecipe {
    final RecipeMap recipe;
    final List<Level> levels;

    public LeveledRecipe(RecipeMap recipe) {
        this(recipe, new ArrayList<Level>(0));
    }

    public LeveledRecipe(RecipeMap recipe, Level ... levels) {
        this(recipe, Arrays.asList(levels));
    }

    public LeveledRecipe(RecipeMap recipe, List<Level> levels) {
        this.recipe = recipe;
        this.levels = levels;
    }

    public LeveledRecipe(String ... craftMap) {
        this(new RecipeMap(craftMap));
    }

    public LeveledRecipe(String[] craftMap, Level level) {
        this(new RecipeMap(craftMap, level));
    }

    public LeveledRecipe(String[] craftMap, Object ... charMap) {
        this(new RecipeMap(craftMap, charMap));
    }

    public LeveledRecipe(String[] craftMap, Object[] charMap, Level ... levels) {
        this(new RecipeMap(craftMap, charMap), levels);
    }

    public LeveledRecipe(String[] craftMap, Object[] charMap, List<Level> levels) {
        this(new RecipeMap(craftMap, charMap), levels);
    }

    public void addLevel(Level newLevel) {
        this.levels.add(newLevel);
    }

    public void addLevel(boolean requirement, Object ... data) {
        this.addLevel(new Level(requirement, data));
    }

    public void addLevel(boolean requirement, char key, Object value) {
        this.addLevel(new Level(requirement, key, value));
    }

    public void addLevel(boolean requirement, Replacement replace) {
        this.addLevel(new Level(requirement, replace));
    }

    public Object[] compileShaped() {
        for (Level bit : this.levels) {
            this.recipe.replace(bit);
        }
        return this.recipe.outputShaped();
    }

    public Object[] compileShapeless() {
        for (Level bit : this.levels) {
            this.recipe.replace(bit);
        }
        return this.recipe.outputShapeless();
    }

    public void registerShaped(ItemStack result) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, this.compileShaped()));
    }

    public void registerShapeless(ItemStack result) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, this.compileShapeless()));
    }

    public void registerShaped(SimpleItem result, int stackSize) {
        this.registerShaped(result.getStack(stackSize));
    }

    public void registerShapeless(SimpleItem result, int stackSize) {
        this.registerShapeless(result.getStack(stackSize));
    }

    public void registerShaped(SimpleItem result) {
        this.registerShaped(result, 1);
    }

    public void registerShapeless(SimpleItem result) {
        this.registerShapeless(result, 1);
    }
}

