/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import redgear.core.item.MetaItem;
import redgear.core.item.SubItemBucket;
import redgear.core.util.SimpleItem;
import redgear.core.world.Location;

public class MetaItemBucket
extends MetaItem<SubItemBucket> {
    public MetaItemBucket(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77642_a(Items.field_151133_ar);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public SimpleItem addMetaItem(SubItemBucket newItem) {
        SimpleItem temp = super.addMetaItem(newItem);
        FluidContainerRegistry.registerFluidContainer((Fluid)newItem.fluid, (ItemStack)temp.getStack(), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        return temp;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        Location loc = new Location(event.target);
        Block id = loc.getBlock((IBlockAccess)event.world);
        int meta = this.getMeta(id);
        if (meta > -1 && loc.getBlockMeta((IBlockAccess)event.world) == 0) {
            loc.setAir(event.world);
            event.result = new ItemStack((Item)this, 1, meta);
            event.setResult(Event.Result.ALLOW);
        }
    }

    private int getMeta(Block block) {
        if (block != null) {
            for (Map.Entry set : this.items.entrySet()) {
                if (!block.equals(((SubItemBucket)set.getValue()).fluid.getBlock())) continue;
                return (Integer)set.getKey();
            }
        }
        return -1;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(par2World, par3EntityPlayer, false);
        if (movingobjectposition == null) {
            return par1ItemStack;
        }
        FillBucketEvent event = new FillBucketEvent(par3EntityPlayer, par1ItemStack, par2World, movingobjectposition);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return par1ItemStack;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (par3EntityPlayer.field_71075_bZ.field_75098_d) {
                return par1ItemStack;
            }
            if (--par1ItemStack.field_77994_a <= 0) {
                return event.result;
            }
            if (!par3EntityPlayer.field_71071_by.func_70441_a(event.result)) {
                par3EntityPlayer.func_70099_a(event.result, 0.0f);
            }
            return par1ItemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!par2World.func_72962_a(par3EntityPlayer, i, j, k)) {
                return par1ItemStack;
            }
            if (movingobjectposition.field_72310_e == 0) {
                --j;
            }
            if (movingobjectposition.field_72310_e == 1) {
                ++j;
            }
            if (movingobjectposition.field_72310_e == 2) {
                --k;
            }
            if (movingobjectposition.field_72310_e == 3) {
                ++k;
            }
            if (movingobjectposition.field_72310_e == 4) {
                --i;
            }
            if (movingobjectposition.field_72310_e == 5) {
                ++i;
            }
            if (!par3EntityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, par1ItemStack)) {
                return par1ItemStack;
            }
            if (this.tryPlaceContainedLiquid(par2World, par1ItemStack, i, j, k) && !par3EntityPlayer.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return par1ItemStack;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack bucket, int x, int y, int z) {
        Fluid working;
        boolean flag;
        Location loc = new Location(x, y, z);
        Material material = loc.getMaterial((IBlockAccess)world);
        boolean bl = flag = !material.func_76220_a();
        if (!loc.isAir((IBlockAccess)world) && !flag) {
            return false;
        }
        if (!world.field_72995_K && flag && !material.func_76224_d()) {
            loc.setAir(world);
        }
        if ((working = ((SubItemBucket)this.getMetaItem((int)bucket.func_77960_j())).fluid) == null || working.getBlock() == null) {
            return false;
        }
        loc.placeBlock(world, new SimpleItem(working.getBlock()));
        return true;
    }
}

