/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.energy.thermal;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.energy.thermal.HeatStack;
import redgear.core.energy.thermal.IThermalHandler;
import redgear.core.energy.thermal.ThermalStorage;
import redgear.core.tile.TileEntityMachine;
import redgear.core.world.WorldLocation;

public abstract class TileEntityThermalMachine
extends TileEntityMachine
implements IThermalHandler {
    protected ThermalStorage storage;
    private ForgeDirection heatCheckDirect;

    public TileEntityThermalMachine(int idleRate, float specificHeat, float conductivity) {
        super(idleRate);
        this.storage = new ThermalStorage(specificHeat, conductivity);
        this.heatCheckDirect = ForgeDirection.UP;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.shareHeat(this.heatCheckDirect);
        int ord = this.heatCheckDirect.ordinal() + 1;
        this.heatCheckDirect = ForgeDirection.VALID_DIRECTIONS[ord % 6];
    }

    private void shareHeat(ForgeDirection side) {
        this.storage.shareHeat(new WorldLocation(this).translate(side, 1).getTile(), side.getOpposite());
    }

    @Override
    protected boolean tryUseEnergy(int energy) {
        if (energy <= this.storage.getHeat()) {
            this.storage.modifyHeatStored(-energy);
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.storage.writeToNBT(tag);
        tag.func_74774_a("heatCheckDirect", (byte)this.heatCheckDirect.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.storage.readFromNBT(tag);
        this.heatCheckDirect = ForgeDirection.getOrientation((int)tag.func_74771_c("heatCheckDirect"));
    }

    @Override
    public float getSpecificHeat() {
        return this.storage.getSpecificHeat();
    }

    @Override
    public float getConductivity(ForgeDirection side) {
        return this.storage.getConductivity();
    }

    @Override
    public int getHeat() {
        return this.storage.getHeat();
    }

    @Override
    public int shareHeat(ForgeDirection side, HeatStack heatStack, boolean simulate) {
        return this.storage.shareHeat(heatStack, simulate);
    }
}

