/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.energy.thermal;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.energy.thermal.HeatStack;
import redgear.core.energy.thermal.IThermalContainerItem;
import redgear.core.energy.thermal.IThermalHandler;
import redgear.core.energy.thermal.IThermalStorage;

public class ThermalStorage
implements IThermalStorage {
    protected final float specificHeat;
    protected final float conductivity;
    protected int heat;

    public ThermalStorage(float specificHeat, float conductivity) {
        this.specificHeat = specificHeat;
        this.conductivity = conductivity;
    }

    public ThermalStorage readFromNBT(NBTTagCompound nbt) {
        this.heat = nbt.func_74762_e("Heat");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.heat < 0) {
            this.heat = 0;
        }
        nbt.func_74768_a("Heat", this.heat);
        return nbt;
    }

    public void setEnergyStored(int heat) {
        this.heat = heat;
        if (this.heat < 0) {
            this.heat = 0;
        }
    }

    public void modifyHeatStored(int heat) {
        this.heat += heat;
        if (this.heat < 0) {
            this.heat = 0;
        }
    }

    public void shareHeat(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IThermalHandler) {
            this.shareHeat((IThermalHandler)tile, side);
        }
    }

    public void shareHeat(IThermalHandler other, ForgeDirection side) {
        if (other != null) {
            this.modifyHeatStored(-other.shareHeat(side, new HeatStack(this), false));
        }
    }

    public void shareHeat(ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof IThermalContainerItem) {
            this.shareHeat((IThermalContainerItem)item, stack);
        }
    }

    public void shareHeat(IThermalContainerItem item, ItemStack stack) {
        if (item != null) {
            this.modifyHeatStored(-item.shareHeat(stack, new HeatStack(this), false));
        }
    }

    @Override
    public float getSpecificHeat() {
        return this.specificHeat;
    }

    @Override
    public float getConductivity() {
        return this.conductivity;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public int shareHeat(HeatStack heatStack, boolean simulate) {
        int ans = heatStack.shareHeat(new HeatStack(this));
        if (simulate) {
            this.heat += ans;
        }
        return ans;
    }
}

