/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.api.item;

import cpw.mods.fml.common.Loader;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import redgear.core.api.item.ISimpleItem;
import redgear.core.api.util.ReflectionHelper;
import redgear.core.world.Location;

public class SimpleItemFactory {
    public static ISimpleItem create(ItemStack stack) {
        return SimpleItemFactory.build(stack);
    }

    public static ISimpleItem create(Item item) {
        return SimpleItemFactory.build(item);
    }

    public static ISimpleItem create(Block block) {
        return SimpleItemFactory.build(block);
    }

    public static ISimpleItem create(IBlockAccess world, int x, int y, int z) {
        return SimpleItemFactory.build(world, x, y, z);
    }

    public static ISimpleItem create(IBlockAccess world, Location loc) {
        return SimpleItemFactory.build(new Object[]{world, loc});
    }

    public static ISimpleItem create(NBTTagCompound tag) {
        return SimpleItemFactory.build(tag);
    }

    public static ISimpleItem create(NBTTagCompound tag, String name) {
        return SimpleItemFactory.build(tag, name);
    }

    private static ISimpleItem build(Object ... args) {
        if (Loader.isModLoaded((String)"redgear_core")) {
            return (ISimpleItem)ReflectionHelper.constructObjectNullFail("redgear.core.util.SimpleItem", args);
        }
        return null;
    }
}

