/*
 * Decompiled with CFR 0.152.
 */
package redgear.snowfall.asm;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import redgear.core.api.item.ISimpleItem;
import redgear.core.util.SimpleItem;
import redgear.core.world.WorldLocation;
import redgear.snowfall.asm.Snowfall;

public class SnowfallHooks {
    public SnowfallHooks() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void updateTick(World world, int x, int y, int z, Random rand) {
        WorldLocation loc = new WorldLocation(x, y, z, world);
        int meta = loc.getBlockMeta();
        int k1 = meta & 7;
        if (world.func_72972_b(EnumSkyBlock.Block, x, y, z) > 11) {
            if (meta < 1) {
                loc.setAir();
            } else {
                loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150431_aC, k1 - 1));
            }
        }
    }

    public static boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return SnowfallHooks.canPlaceBlockAt(new WorldLocation(x, y, z, world));
    }

    public static boolean canPlaceBlockAt(WorldLocation loc) {
        if (loc.getBlock() == Blocks.field_150431_aC || loc.isAir() || loc.getMaterial() == Material.field_151585_k || loc.getMaterial() == Material.field_151582_l) {
            return (loc = loc.translate(ForgeDirection.DOWN, 1)).isSideSolid(ForgeDirection.UP) || loc.getBlock().isLeaves((IBlockAccess)loc.world, loc.getX(), loc.getY(), loc.getZ()) || loc.getBlock() == Blocks.field_150458_ak;
        }
        return false;
    }

    public static boolean canSnowAtBody(World world, int x, int y, int z, boolean checkLight) {
        WorldLocation loc = new WorldLocation(x, y, z, world);
        BiomeGenBase biomegenbase = world.func_72807_a(x, z);
        float f = biomegenbase.func_150564_a(x, y, z);
        if (f > 0.15f) {
            return false;
        }
        if (!checkLight) {
            return true;
        }
        if (world.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10) {
            Block block = loc.getBlock();
            if (block == Blocks.field_150431_aC) {
                int smallest = loc.getBlockMeta();
                if (smallest == 7) {
                    if (Snowfall.deepSnow || Snowfall.iceAge) {
                        loc = loc.translate(-1, 0, -1);
                        for (int i = 0; i < 3; ++i) {
                            for (int j = 0; j < 3; ++j) {
                                SnowfallHooks.deepSnow(loc.translate(i, 0, j));
                            }
                        }
                    }
                    return false;
                }
                if (world.field_73012_v.nextInt(smallest + 2) == 0) {
                    int j;
                    int i;
                    loc = loc.translate(-1, 0, -1);
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            smallest = SnowfallHooks.findSmallest(loc.translate(i, 0, j), smallest);
                        }
                    }
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            SnowfallHooks.grow(loc.translate(i, 0, j), smallest);
                        }
                    }
                }
                return false;
            }
            return SnowfallHooks.canPlaceBlockAt(world, x, y, z);
        }
        return false;
    }

    private static void deepSnow(WorldLocation loc) {
        if (loc.getBlockMeta() == 7) {
            if (Snowfall.deepSnow && !Snowfall.iceAge && !SnowfallHooks.checkDeepSnow(loc.translate(ForgeDirection.DOWN, 2))) {
                loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150433_aE));
            }
            if (Snowfall.iceAge) {
                if (loc.translate(ForgeDirection.DOWN, 6).getBlock() != Blocks.field_150403_cj) {
                    loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150433_aE));
                }
                if ((loc = loc.translate(ForgeDirection.DOWN, 3)).getBlock() == Blocks.field_150433_aE) {
                    loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150432_aD));
                    loc = loc.translate(ForgeDirection.DOWN, 2);
                    if (loc.getBlock() == Blocks.field_150432_aD) {
                        loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150403_cj));
                    }
                }
            }
        }
    }

    private static boolean checkDeepSnow(WorldLocation loc) {
        Material mat = loc.getMaterial();
        return mat == Material.field_151597_y ? true : (mat == Material.field_151596_z ? true : (mat == Material.field_151588_w ? true : mat == Material.field_151598_x));
    }

    private static int findSmallest(WorldLocation loc, int smallest) {
        if (loc.getBlock() == Blocks.field_150431_aC) {
            return Math.min(loc.getBlockMeta(), smallest);
        }
        if (SnowfallHooks.canPlaceBlockAt(loc)) {
            return -1;
        }
        return smallest;
    }

    private static void grow(WorldLocation loc, int test) {
        if (loc.getBlock() == Blocks.field_150431_aC && loc.getBlockMeta() == test || test == -1 && SnowfallHooks.canPlaceBlockAt(loc)) {
            loc.placeBlock((ISimpleItem)new SimpleItem(Blocks.field_150431_aC, test + 1));
        }
    }

    public static int onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        Block snow;
        WorldLocation loc = new WorldLocation(x, y, z, world);
        if (stack.field_77994_a == 0) {
            return 1;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return 1;
        }
        Block target = loc.getBlock();
        if (target == (snow = Blocks.field_150431_aC)) {
            int meta = loc.getBlockMeta();
            if (meta <= 6) {
                if (world.func_72855_b(snow.func_149668_a(world, x, y, z)) && world.func_72921_c(x, y, z, meta + 1, 2)) {
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), snow.field_149762_H.func_150496_b(), (snow.field_149762_H.func_150497_c() + 1.0f) / 2.0f, snow.field_149762_H.func_150494_d() * 0.8f);
                    --stack.field_77994_a;
                    return 0;
                }
            } else {
                return 2;
            }
        }
        return 1;
    }

    @SubscribeEvent
    public void snowShovelHook(BlockEvent.HarvestDropsEvent event) {
        ItemStack heldItem;
        if (event.harvester != null && (event.block == Blocks.field_150433_aE || event.block == Blocks.field_150431_aC) && (heldItem = event.harvester.func_70694_bm()) != null && heldItem.func_77973_b() instanceof ISnowShovel) {
            event.drops.clear();
            if (event.block == Blocks.field_150431_aC) {
                event.drops.add(new ItemStack(Blocks.field_150431_aC, event.blockMetadata + 1, 0));
            } else {
                event.drops.add(new ItemStack(Blocks.field_150433_aE, 1, 0));
            }
        }
    }

    public static interface ISnowShovel {
    }
}

