/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import redgear.core.api.tile.IBucketableTank;
import redgear.core.fluids.AdvFluidTank;
import redgear.core.fluids.FluidUtil;
import redgear.core.tile.TileEntityInventory;
import redgear.core.tile.TileEntityMachine;
import redgear.core.util.ItemStackUtil;

public abstract class TileEntityTank
extends TileEntityInventory
implements IFluidHandler,
IBucketableTank {
    private final List<AdvFluidTank> tanks = new ArrayList<AdvFluidTank>();
    private ejectMode currMode = ejectMode.MACHINE;

    public TileEntityTank(int idleRate) {
        super(idleRate);
    }

    public int addTank(AdvFluidTank newTank) {
        this.tanks.add(newTank);
        return this.tanks.size() - 1;
    }

    public int tanks() {
        return this.tanks.size();
    }

    private boolean validTank(int index) {
        return index >= 0 && index < this.tanks.size() && this.tanks.get(index) != null;
    }

    public AdvFluidTank getTank(int index) {
        if (this.validTank(index)) {
            return this.tanks.get(index);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int filled = 0;
        for (AdvFluidTank tank : this.tanks) {
            filled = tank.fillWithMap(resource, doFill);
            if (filled <= 0) continue;
            if (doFill) {
                this.forceSync();
            }
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack removed = null;
        for (AdvFluidTank tank : this.tanks) {
            removed = tank.drainWithMap(resource, doDrain);
            if (removed == null || removed.amount <= 0) continue;
            if (doDrain) {
                this.forceSync();
            }
            return removed;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack removed = null;
        for (AdvFluidTank tank : this.tanks) {
            removed = tank.drainWithMap(maxDrain, doDrain);
            if (removed == null || removed.amount <= 0) continue;
            if (doDrain) {
                this.forceSync();
            }
            return removed;
        }
        return null;
    }

    @Override
    public boolean bucket(EntityPlayer player, int index, ItemStack container) {
        if (FluidContainerRegistry.isFilledContainer((ItemStack)container)) {
            return this.fill(player, index, container);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            return this.empty(player, index, container);
        }
        return false;
    }

    @Override
    public boolean fill(EntityPlayer player, int index, ItemStack container) {
        if (container == null) {
            return false;
        }
        FluidStack contents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (contents != null && this.fill(ForgeDirection.UNKNOWN, contents, false) == contents.amount) {
            this.fill(ForgeDirection.UNKNOWN, contents, true);
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            ItemStack ans = container.func_77973_b().getContainerItem(container);
            player.field_71071_by.func_70298_a(index, 1);
            if (ans != null && !player.field_71071_by.func_70441_a(ans)) {
                ItemStackUtil.dropItemStack(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, ans);
            }
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean empty(EntityPlayer player, int index, ItemStack container) {
        for (AdvFluidTank tank : this.tanks) {
            int capacity;
            ItemStack filled;
            FluidStack contents = tank.getFluid();
            if (contents == null || (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)contents.copy(), (ItemStack)container.func_77946_l())) == null || !tank.canDrainWithMap(capacity = FluidUtil.getContainerCapacity(contents, filled))) continue;
            tank.drainWithMap(capacity, true);
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            player.field_71071_by.func_70298_a(index, 1);
            if (!player.field_71071_by.func_70441_a(filled)) {
                ItemStackUtil.dropItemStack(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, filled);
            }
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tankList = new NBTTagList();
        for (int i = 0; i < this.tanks.size(); ++i) {
            AdvFluidTank tank = this.getTank(i);
            if (tank == null) continue;
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_74774_a("tank", (byte)i);
            tankList.func_74742_a((NBTBase)tank.writeToNBT(invTag));
        }
        tag.func_74782_a("Tanks", (NBTBase)tankList);
        tag.func_74768_a("ejectMode", this.currMode.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Tanks", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound invTag = tagList.func_150305_b(i);
            byte slot = invTag.func_74771_c("tank");
            AdvFluidTank tank = this.getTank(slot);
            if (tank == null) continue;
            tank.readFromNBT(invTag);
        }
        this.currMode = ejectMode.valueOf(tag.func_74762_e("ejectMode"));
    }

    protected void incrementEjectMode() {
        this.currMode = ejectMode.increment(this.currMode);
    }

    protected String getEjectMode() {
        return this.currMode.name();
    }

    protected boolean ejectAllFluids() {
        boolean check = false;
        int max = this.tanks();
        for (int i = 0; i < max; ++i) {
            check |= this.ejectFluidAllSides(i);
        }
        return check;
    }

    protected boolean ejectFluidAllSides(int tankIndex) {
        AdvFluidTank temp = this.getTank(tankIndex);
        if (temp != null) {
            return this.ejectFluidAllSides(temp);
        }
        return false;
    }

    protected boolean ejectFluidAllSides(AdvFluidTank tank) {
        boolean check = false;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            check |= this.ejectFluid(side, tank);
        }
        return check;
    }

    protected boolean ejectFluid(ForgeDirection side, AdvFluidTank tank, int maxDrain) {
        if (tank == null || tank.getFluid() == null || this.currMode == ejectMode.OFF) {
            return false;
        }
        TileEntity otherTile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (otherTile != null && IFluidHandler.class.isAssignableFrom(otherTile.getClass()) && (this.currMode == ejectMode.ALL || TileEntityMachine.class.isAssignableFrom(otherTile.getClass()))) {
            FluidStack drain = tank.drainWithMap(maxDrain, false);
            if (drain == null) {
                return false;
            }
            int fill = ((IFluidHandler)otherTile).fill(side.getOpposite(), drain, true);
            tank.drain(fill, true);
            return true;
        }
        return false;
    }

    protected boolean ejectFluid(ForgeDirection side, int tankIndex, int maxDrain) {
        return this.ejectFluid(side, this.getTank(tankIndex), maxDrain);
    }

    protected boolean ejectFluid(ForgeDirection side, AdvFluidTank tank) {
        return this.ejectFluid(side, tank, tank.getCapacity());
    }

    protected boolean ejectFluid(ForgeDirection side, int tankIndex) {
        AdvFluidTank temp = this.getTank(tankIndex);
        if (temp != null) {
            return this.ejectFluid(side, temp, temp.getCapacity());
        }
        return false;
    }

    protected void writeFluidStack(NBTTagCompound tag, String name, FluidStack stack) {
        if (stack == null) {
            return;
        }
        tag.func_74782_a(name, (NBTBase)stack.writeToNBT(new NBTTagCompound()));
    }

    protected FluidStack readFluidStack(NBTTagCompound tag, String name) {
        NBTTagCompound subTag = tag.func_74775_l(name);
        if (subTag == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)subTag);
    }

    protected boolean fillTank(int slotFullIndex, int slotEmptyIndex, AdvFluidTank tank) {
        ItemStack fullSlot = this.func_70301_a(slotFullIndex);
        if (fullSlot == null || tank == null || !this.validSlot(slotEmptyIndex)) {
            return false;
        }
        FluidStack contents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fullSlot);
        ItemStack emptyContainer = FluidUtil.getEmptyContainer(fullSlot);
        if (tank.canFillWithMap(contents, true) && this.canAddStack(slotEmptyIndex, emptyContainer)) {
            tank.fillWithMap(contents, true);
            if (emptyContainer != null) {
                this.addStack(slotEmptyIndex, emptyContainer);
            }
            this.func_70298_a(slotFullIndex, 1);
            return true;
        }
        return false;
    }

    protected boolean fillTank(int slotFullIndex, int slotEmptyIndex, int tankIndex) {
        return this.fillTank(slotFullIndex, slotEmptyIndex, this.getTank(tankIndex));
    }

    protected boolean emptyTank(int slotEmptyIndex, int slotFullIndex, AdvFluidTank tank) {
        int capacity;
        ItemStack filled;
        ItemStack emptySlot = this.func_70301_a(slotEmptyIndex);
        if (emptySlot == null || tank == null || !this.validSlot(slotFullIndex)) {
            return false;
        }
        FluidStack contents = tank.getFluid();
        if (emptySlot != null && contents != null && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)contents.copy(), (ItemStack)emptySlot.func_77946_l())) != null && tank.canDrainWithMap(capacity = FluidUtil.getContainerCapacity(contents, filled)) && this.canAddStack(slotFullIndex, filled)) {
            this.addStack(slotFullIndex, filled);
            tank.drainWithMap(capacity, true);
            this.func_70298_a(slotEmptyIndex, 1);
            return true;
        }
        return false;
    }

    protected boolean emptyTank(int slotEmptyIndex, int slotFullIndex, int tankIndex) {
        return this.emptyTank(slotEmptyIndex, slotFullIndex, this.getTank(tankIndex));
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (AdvFluidTank tank : this.tanks) {
            if (!tank.canAccept(fluid.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        for (AdvFluidTank tank : this.tanks) {
            if (!tank.canEject(fluid.getID())) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.tanks.size()];
        for (int x = 0; x < this.tanks.size(); ++x) {
            info[x] = this.tanks.get(x).getInfo();
        }
        return info;
    }

    private static enum ejectMode {
        OFF,
        MACHINE,
        ALL;


        public static ejectMode increment(ejectMode lastMode) {
            return lastMode == OFF ? MACHINE : (lastMode == MACHINE ? ALL : OFF);
        }

        public static ejectMode valueOf(int ordinal) {
            return ordinal == 0 ? OFF : (ordinal == 2 ? ALL : MACHINE);
        }
    }
}

